/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.jain.pkg;

import java.util.ArrayList;
import java.util.HashMap;
import org.mobicents.protocols.mgcp.jain.pkg.AnnouncementParmValue;
import org.mobicents.protocols.mgcp.jain.pkg.BooleanValue;
import org.mobicents.protocols.mgcp.jain.pkg.DisplayTextSeg;
import org.mobicents.protocols.mgcp.jain.pkg.EventsValue;
import org.mobicents.protocols.mgcp.jain.pkg.NumberValue;
import org.mobicents.protocols.mgcp.jain.pkg.ParameterEnum;
import org.mobicents.protocols.mgcp.jain.pkg.ParserException;
import org.mobicents.protocols.mgcp.jain.pkg.PosKeyValue;
import org.mobicents.protocols.mgcp.jain.pkg.SegmentId;
import org.mobicents.protocols.mgcp.jain.pkg.SilenceSeg;
import org.mobicents.protocols.mgcp.jain.pkg.StringValue;
import org.mobicents.protocols.mgcp.jain.pkg.TextToSpeechSeg;
import org.mobicents.protocols.mgcp.jain.pkg.Value;

public class AUUtils {
    int index = 0;
    char[] chars = null;
    String rawString = null;
    int totalChars = -1;
    Value value = null;

    AUUtils(String rawString) {
        this.rawString = rawString;
        System.out.println("rawString = " + rawString);
        this.chars = rawString.toCharArray();
        this.totalChars = this.chars.length;
        this.value = new EventsValue();
        System.out.println("totalChars = " + this.totalChars);
    }

    public static void main(String[] args) throws ParserException {
        String s = "it=4 an=39<1212,ssss>,40[Lang=dan,gender=female,accent=cajun],47,ts(blaaa),dt(GOOOD),si(asssss)";
        AUUtils a = new AUUtils(s);
        Value v = a.decode_PlayAnnParmList();
        System.out.println("Here it come = " + v.get(ParameterEnum.an) + " " + v.get(ParameterEnum.it));
        s = "ip=21 rp=109 nd=102 fa=81 sa=72 dp=#*222 psk=9,nxt sik=*#12345667 na=3";
        a = new AUUtils(s);
        v = a.decode_PlayColParmList();
        System.out.println("Here it come = " + v.get(ParameterEnum.ip) + " " + v.get(ParameterEnum.rp) + " " + v.get(ParameterEnum.nd) + " " + v.get(ParameterEnum.fa) + " " + v.get(ParameterEnum.sa) + " " + v.get(ParameterEnum.na) + " " + v.get(ParameterEnum.dp) + " " + v.get(ParameterEnum.psk) + " " + v.get(ParameterEnum.sik));
    }

    public Value decode_PlayAnnParmList() throws ParserException {
        boolean f = this.decode_PlayAnnParm();
        if (!f) {
            throw new ParserException("Parsing of AnnParm failed");
        }
        while (f) {
            f = this.decode_WSP();
            if (!f) continue;
            f = this.decode_PlayAnnParm();
        }
        return this.value;
    }

    public Value decode_PlayColParmList() throws ParserException {
        boolean f = this.decode_PlayColParm();
        if (!f) {
            throw new ParserException("Parsing of PlayColParm failed");
        }
        while (f) {
            f = this.decode_WSP();
            if (!f) continue;
            f = this.decode_PlayColParm();
        }
        return this.value;
    }

    public Value decode_PlayRecParmList() throws ParserException {
        boolean f = this.decode_PlayRecParm();
        if (!f) {
            throw new ParserException("Parsing of PlayRecParm failed");
        }
        while (f) {
            f = this.decode_WSP();
            if (!f) continue;
            f = this.decode_PlayRecParm();
        }
        return this.value;
    }

    public Value decode_OpCompleteParmList() throws ParserException {
        boolean f = this.decode_OpCompleteParm();
        if (!f) {
            throw new ParserException("Parsing of OpCompleteParm failed");
        }
        while (f) {
            f = this.decode_WSP();
            if (!f) continue;
            f = this.decode_OpCompleteParm();
        }
        return this.value;
    }

    private boolean decode_WSP() {
        boolean decoded = false;
        if (this.index < this.totalChars && (this.chars[this.index] == ' ' || this.chars[this.index] == '\t')) {
            ++this.index;
            decoded = true;
        }
        return decoded;
    }

    private boolean decode_Segid(AnnouncementParmValue annPaVa) {
        boolean decoded = false;
        String strSegId = "";
        SegmentId segId = null;
        if (this.chars[this.index] >= '0' && this.chars[this.index] <= '9') {
            strSegId = strSegId + this.chars[this.index];
            decoded = true;
            ++this.index;
        }
        if (decoded) {
            for (int i = 0; i <= 31 && this.index < this.totalChars && this.chars[this.index] >= '0' && this.chars[this.index] <= '9'; ++i) {
                strSegId = strSegId + this.chars[this.index];
                ++this.index;
            }
            segId = new SegmentId(strSegId, null);
            annPaVa.addSegmentId(segId);
        } else if (this.chars[this.index] == '/') {
            ++this.index;
            decoded = true;
            while (this.chars[this.index] != '/') {
                strSegId = strSegId + this.chars[this.index];
                ++this.index;
            }
            segId = new SegmentId(null, strSegId);
            annPaVa.addSegmentId(segId);
        }
        if (decoded && this.index < this.totalChars) {
            String[] s;
            String tmp;
            if (this.chars[this.index] == '<') {
                ++this.index;
                ArrayList<String> embedVarList = new ArrayList<String>();
                tmp = "";
                while (this.chars[this.index] != '>') {
                    tmp = tmp + this.chars[this.index];
                    ++this.index;
                }
                ++this.index;
                for (String sTemp : s = tmp.split(",")) {
                    embedVarList.add(sTemp);
                }
                segId.setEmbedVarList(embedVarList);
            }
            if (this.chars[this.index] == '[') {
                ++this.index;
                HashMap<String, String> segSelectorMap = new HashMap<String, String>();
                tmp = "";
                while (this.chars[this.index] != ']') {
                    tmp = tmp + this.chars[this.index];
                    ++this.index;
                }
                ++this.index;
                for (String sTemp : s = tmp.split(",")) {
                    String[] s1 = sTemp.split("=");
                    segSelectorMap.put(s1[0], s1[1]);
                }
                segId.setSegSelectorMap(segSelectorMap);
            }
        }
        return decoded;
    }

    private boolean decode_TextToSpeechSeg(AnnouncementParmValue annPaVa) {
        boolean decoded = false;
        String textTpSpeech = "";
        if (this.chars[this.index] == 't' && this.chars[this.index + 1] == 's') {
            this.index += 3;
            while (this.chars[this.index] != ')') {
                textTpSpeech = textTpSpeech + this.chars[this.index];
                ++this.index;
            }
            decoded = true;
            ++this.index;
            TextToSpeechSeg ts = new TextToSpeechSeg(textTpSpeech);
            annPaVa.addTextToSpeechSeg(ts);
            if (this.index < this.totalChars && this.chars[this.index] == '[') {
                String[] s;
                ++this.index;
                HashMap<String, String> segSelectorMap = new HashMap<String, String>();
                String tmp = "";
                while (this.chars[this.index] != ']') {
                    tmp = tmp + this.chars[this.index];
                    ++this.index;
                }
                ++this.index;
                for (String sTemp : s = tmp.split(",")) {
                    String[] s1 = sTemp.split("=");
                    segSelectorMap.put(s1[0], s1[1]);
                }
                ts.setSegSelectorMap(segSelectorMap);
            }
        }
        return decoded;
    }

    private boolean decode_DisplayTextSeg(AnnouncementParmValue annPaVa) {
        boolean decoded = false;
        String displayText = "";
        if (this.chars[this.index] == 'd' && this.chars[this.index + 1] == 't') {
            this.index += 3;
            while (this.chars[this.index] != ')') {
                displayText = displayText + this.chars[this.index];
                ++this.index;
            }
            decoded = true;
            ++this.index;
            DisplayTextSeg ds = new DisplayTextSeg(displayText);
            annPaVa.addDisplayTextSeg(ds);
            if (this.index < this.totalChars && this.chars[this.index] == '[') {
                String[] s;
                ++this.index;
                HashMap<String, String> segSelectorMap = new HashMap<String, String>();
                String tmp = "";
                while (this.chars[this.index] != ']') {
                    tmp = tmp + this.chars[this.index];
                    ++this.index;
                }
                ++this.index;
                for (String sTemp : s = tmp.split(",")) {
                    String[] s1 = sTemp.split("=");
                    segSelectorMap.put(s1[0], s1[1]);
                }
                ds.setSegSelectorMap(segSelectorMap);
            }
        }
        return decoded;
    }

    private boolean decode_SilenceSeg(AnnouncementParmValue annPaVa) {
        boolean decoded = false;
        if (this.index < this.totalChars && this.chars[this.index] == 's' && this.chars[this.index + 1] == 'i') {
            this.index += 3;
            String silenceSeg = "";
            while (this.chars[this.index] != ')') {
                silenceSeg = silenceSeg + this.chars[this.index];
                ++this.index;
            }
            ++this.index;
            SilenceSeg si = new SilenceSeg(silenceSeg);
            annPaVa.addSilenceSeg(si);
        }
        return decoded;
    }

    private boolean decode_SegmentDescriptor(AnnouncementParmValue annPaVa) throws ParserException {
        boolean decoded = false;
        decoded = this.decode_Segid(annPaVa);
        if (!decoded) {
            decoded = this.decode_TextToSpeechSeg(annPaVa);
        }
        if (!decoded) {
            decoded = this.decode_DisplayTextSeg(annPaVa);
        }
        if (!decoded) {
            decoded = this.decode_SilenceSeg(annPaVa);
        }
        return decoded;
    }

    private boolean decode_Segmentlist(AnnouncementParmValue annPaVa) throws ParserException {
        boolean decoded = false;
        decoded = this.decode_SegmentDescriptor(annPaVa);
        if (decoded) {
            boolean f = true;
            while (f && this.index < this.totalChars) {
                if (this.chars[this.index] == ',') {
                    ++this.index;
                    f = this.decode_SegmentDescriptor(annPaVa);
                    continue;
                }
                f = false;
            }
        }
        return decoded;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decode_OpCompleteParm() throws ParserException {
        boolean decoded = false;
        if (this.chars[this.index] == 'v' && this.chars[this.index + 1] == 'i') {
            this.index += 3;
            boolean boolStrValue = this.decode_BOOLSTR();
            BooleanValue boolValue = new BooleanValue(ParameterEnum.vi, boolStrValue);
            this.value.put(ParameterEnum.vi, boolValue);
            return true;
        }
        if (this.chars[this.index] == 'i' && this.chars[this.index + 1] == 'k') {
            this.index += 3;
            String cmdKeySequence = "";
            if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                if (this.chars[this.index] != '#') throw new ParserException("Decoding of IntKeySeqParm failed");
            }
            decoded = true;
            cmdKeySequence = cmdKeySequence + this.chars[this.index];
            ++this.index;
            for (int i = 1; i < 3 && this.index < this.totalChars && (this.chars[this.index] >= '0' && this.chars[this.index] <= '9' || this.chars[this.index] == '*' || this.chars[this.index] == '#'); ++i) {
                cmdKeySequence = cmdKeySequence + this.chars[this.index];
                ++this.index;
            }
            StringValue s = new StringValue(ParameterEnum.ik, cmdKeySequence);
            this.value.put(ParameterEnum.ik, s);
            return true;
        }
        if (this.chars[this.index] == 'n' && this.chars[this.index + 1] == 'a') {
            this.index += 3;
            int number = this.decode_NUMBER();
            NumberValue n = new NumberValue(ParameterEnum.na, number);
            this.value.put(ParameterEnum.na, n);
            return true;
        }
        if (this.chars[this.index] == 'a' && this.chars[this.index + 1] == 'p') {
            this.index += 3;
            int number = this.decode_NUMBER();
            NumberValue n = new NumberValue(ParameterEnum.ap, number);
            this.value.put(ParameterEnum.ap, n);
            return true;
        }
        if (this.chars[this.index] == 'd' && this.chars[this.index + 1] == 'c') {
            this.index += 3;
            String keySequence = "";
            if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                if (this.chars[this.index] != '#') throw new ParserException("Decoding of DigitsColParm failed");
            }
            decoded = true;
            keySequence = keySequence + this.chars[this.index];
            ++this.index;
            for (int i = 1; i < 64 && this.index < this.totalChars && (this.chars[this.index] >= '0' && this.chars[this.index] <= '9' || this.chars[this.index] == '*' || this.chars[this.index] == '#'); ++i) {
                keySequence = keySequence + this.chars[this.index];
                ++this.index;
            }
            StringValue s = new StringValue(ParameterEnum.dc, keySequence);
            this.value.put(ParameterEnum.dc, s);
            return true;
        }
        if (this.chars[this.index] == 'r' && this.chars[this.index + 1] == 'i') {
            this.index += 3;
            int number = this.decode_NUMBER();
            NumberValue n = new NumberValue(ParameterEnum.ri, number);
            this.value.put(ParameterEnum.ri, n);
            return true;
        }
        if (this.chars[this.index] != 'r') throw new ParserException("Decoding of PlayRecParm failed");
        if (this.chars[this.index + 1] != 'c') throw new ParserException("Decoding of PlayRecParm failed");
        this.index += 3;
        String rc = "";
        if (this.chars[this.index] < '0') throw new ParserException("Decoding of ReturnCodeParm failed");
        if (this.chars[this.index] > '9') throw new ParserException("Decoding of ReturnCodeParm failed");
        rc = rc + this.chars[this.index];
        ++this.index;
        if (this.chars[this.index] < '0') throw new ParserException("Decoding of ReturnCodeParm failed");
        if (this.chars[this.index] > '9') throw new ParserException("Decoding of ReturnCodeParm failed");
        rc = rc + this.chars[this.index];
        ++this.index;
        if (this.chars[this.index] < '0') throw new ParserException("Decoding of ReturnCodeParm failed");
        if (this.chars[this.index] > '9') throw new ParserException("Decoding of ReturnCodeParm failed");
        rc = rc + this.chars[this.index];
        ++this.index;
        try {
            int number = Integer.parseInt(rc);
            NumberValue n = new NumberValue(ParameterEnum.rc, number);
            this.value.put(ParameterEnum.rc, n);
            return true;
        }
        catch (NumberFormatException e) {
            throw new ParserException("Decoding of ReturnCodeParm failed. The Return code is not number");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decode_PlayRecParm() throws ParserException {
        boolean decoded = false;
        if (this.chars[this.index] == 'i' && this.chars[this.index + 1] == 'p') {
            this.index += 3;
            AnnouncementParmValue annPaVa = new AnnouncementParmValue(ParameterEnum.ip);
            this.value.put(ParameterEnum.ip, annPaVa);
            return this.decode_Segmentlist(annPaVa);
        }
        if (this.chars[this.index] == 'r' && this.chars[this.index + 1] == 'p') {
            this.index += 3;
            AnnouncementParmValue annPaVa = new AnnouncementParmValue(ParameterEnum.rp);
            this.value.put(ParameterEnum.rp, annPaVa);
            return this.decode_Segmentlist(annPaVa);
        }
        if (this.chars[this.index] == 'n' && this.chars[this.index + 1] == 's') {
            this.index += 3;
            AnnouncementParmValue annPaVa = new AnnouncementParmValue(ParameterEnum.ns);
            this.value.put(ParameterEnum.ns, annPaVa);
            return this.decode_Segmentlist(annPaVa);
        }
        if (this.chars[this.index] == 'f' && this.chars[this.index + 1] == 'a') {
            this.index += 3;
            AnnouncementParmValue annPaVa = new AnnouncementParmValue(ParameterEnum.fa);
            this.value.put(ParameterEnum.fa, annPaVa);
            return this.decode_Segmentlist(annPaVa);
        }
        if (this.chars[this.index] == 's' && this.chars[this.index + 1] == 'a') {
            this.index += 3;
            AnnouncementParmValue annPaVa = new AnnouncementParmValue(ParameterEnum.sa);
            this.value.put(ParameterEnum.sa, annPaVa);
            return this.decode_Segmentlist(annPaVa);
        }
        if (this.chars[this.index] == 'n' && this.chars[this.index + 1] == 'i') {
            this.index += 3;
            boolean boolStrValue = this.decode_BOOLSTR();
            BooleanValue boolValue = new BooleanValue(ParameterEnum.ni, boolStrValue);
            this.value.put(ParameterEnum.ni, boolValue);
            return true;
        }
        if (this.chars[this.index] == 's' && this.chars[this.index + 1] == 'p') {
            this.index += 3;
            String s = this.decode_SIGNEDINT();
            StringValue sValue = new StringValue(ParameterEnum.sp, s);
            this.value.put(ParameterEnum.sp, sValue);
            return true;
        }
        if (this.chars[this.index] == 'v' && this.chars[this.index + 1] == 'l') {
            this.index += 3;
            String s = this.decode_SIGNEDINT();
            StringValue sValue = new StringValue(ParameterEnum.vl, s);
            this.value.put(ParameterEnum.vl, sValue);
            return true;
        }
        if (this.chars[this.index] == 'c' && this.chars[this.index + 1] == 'b') {
            this.index += 3;
            boolean boolStrValue = this.decode_BOOLSTR();
            BooleanValue boolValue = new BooleanValue(ParameterEnum.cb, boolStrValue);
            this.value.put(ParameterEnum.cb, boolValue);
            return true;
        }
        if (this.chars[this.index] == 'p' && this.chars[this.index + 1] == 'r' && this.chars[this.index + 2] == 't') {
            this.index += 4;
            int number = this.decode_NUMBER();
            NumberValue n = new NumberValue(ParameterEnum.prt, number);
            this.value.put(ParameterEnum.prt, n);
            return true;
        }
        if (this.chars[this.index] == 'p' && this.chars[this.index + 1] == 's' && this.chars[this.index + 2] == 't') {
            this.index += 4;
            int number = this.decode_NUMBER();
            NumberValue n = new NumberValue(ParameterEnum.pst, number);
            this.value.put(ParameterEnum.pst, n);
            return true;
        }
        if (this.chars[this.index] == 'r' && this.chars[this.index + 1] == 'l' && this.chars[this.index + 2] == 't') {
            this.index += 4;
            int number = this.decode_NUMBER();
            NumberValue n = new NumberValue(ParameterEnum.rlt, number);
            this.value.put(ParameterEnum.rlt, n);
            return true;
        }
        if (this.chars[this.index] == 'r' && this.chars[this.index + 1] == 's' && this.chars[this.index + 2] == 'k') {
            this.index += 4;
            String cmdKeySequence = "";
            if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                if (this.chars[this.index] != '#') throw new ParserException("Decoding of RestartKeyParm failed");
            }
            decoded = true;
            cmdKeySequence = cmdKeySequence + this.chars[this.index];
            ++this.index;
            for (int i = 1; i < 3 && this.index < this.totalChars && (this.chars[this.index] >= '0' && this.chars[this.index] <= '9' || this.chars[this.index] == '*' || this.chars[this.index] == '#'); ++i) {
                cmdKeySequence = cmdKeySequence + this.chars[this.index];
                ++this.index;
            }
            StringValue s = new StringValue(ParameterEnum.rsk, cmdKeySequence);
            this.value.put(ParameterEnum.rsk, s);
            return true;
        }
        if (this.chars[this.index] == 'r' && this.chars[this.index + 1] == 'i' && this.chars[this.index + 2] == 'k') {
            this.index += 4;
            String cmdKeySequence = "";
            if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                if (this.chars[this.index] != '#') throw new ParserException("Decoding of ReinputKeyParm failed");
            }
            decoded = true;
            cmdKeySequence = cmdKeySequence + this.chars[this.index];
            ++this.index;
            for (int i = 1; i < 3 && this.index < this.totalChars && (this.chars[this.index] >= '0' && this.chars[this.index] <= '9' || this.chars[this.index] == '*' || this.chars[this.index] == '#'); ++i) {
                cmdKeySequence = cmdKeySequence + this.chars[this.index];
                ++this.index;
            }
            StringValue s = new StringValue(ParameterEnum.rik, cmdKeySequence);
            this.value.put(ParameterEnum.rik, s);
            return true;
        }
        if (this.chars[this.index] == 'r' && this.chars[this.index + 1] == 't' && this.chars[this.index + 2] == 'k') {
            this.index += 4;
            String cmdKeySequence = "";
            if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                if (this.chars[this.index] != '#') throw new ParserException("Decoding of ReinputKeyParm failed");
            }
            decoded = true;
            cmdKeySequence = cmdKeySequence + this.chars[this.index];
            ++this.index;
            for (int i = 1; i < 3 && this.index < this.totalChars && (this.chars[this.index] >= '0' && this.chars[this.index] <= '9' || this.chars[this.index] == '*' || this.chars[this.index] == '#'); ++i) {
                cmdKeySequence = cmdKeySequence + this.chars[this.index];
                ++this.index;
            }
            StringValue s = new StringValue(ParameterEnum.rtk, cmdKeySequence);
            this.value.put(ParameterEnum.rtk, s);
            return true;
        }
        if (this.chars[this.index] == 'p' && this.chars[this.index + 1] == 's' && this.chars[this.index + 2] == 'k') {
            this.index += 4;
            if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                if (this.chars[this.index] != '#') throw new ParserException("Decoding of PosKeyParm failed");
            }
            String keyPadKey = String.valueOf(this.chars[this.index]);
            String posKeyAction = null;
            ++this.index;
            if (this.chars[this.index] != ',') throw new ParserException("Decoding of PosKeyParm failed. No comma found after KeyPadKey");
            ++this.index;
            if (this.chars[this.index] == 'f' && this.chars[this.index + 1] == 's' && this.chars[this.index + 2] == 't') {
                posKeyAction = "fst";
                this.index += 3;
            } else if (this.chars[this.index] == 'l' && this.chars[this.index + 1] == 's' && this.chars[this.index + 2] == 't') {
                posKeyAction = "lst";
                this.index += 3;
            } else if (this.chars[this.index] == 'p' && this.chars[this.index + 1] == 'r' && this.chars[this.index + 2] == 'v') {
                posKeyAction = "prv";
                this.index += 3;
            } else if (this.chars[this.index] == 'n' && this.chars[this.index + 1] == 'x' && this.chars[this.index + 2] == 't') {
                posKeyAction = "nxt";
                this.index += 3;
            } else {
                if (this.chars[this.index] != 'c') throw new ParserException("Decoding of PosKeyParm's PosKeyAction failed");
                if (this.chars[this.index + 1] != 'u') throw new ParserException("Decoding of PosKeyParm's PosKeyAction failed");
                if (this.chars[this.index + 2] != 'r') throw new ParserException("Decoding of PosKeyParm's PosKeyAction failed");
                posKeyAction = "cur";
                this.index += 3;
            }
            PosKeyValue p = new PosKeyValue(ParameterEnum.psk, keyPadKey, posKeyAction);
            this.value.put(ParameterEnum.psk, p);
            return true;
        }
        if (this.chars[this.index] == 's' && this.chars[this.index + 1] == 't' && this.chars[this.index + 2] == 'k') {
            this.index += 4;
            if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                if (this.chars[this.index] != '#') throw new ParserException("Decoding of StopKeyParm failed.");
            }
            StringValue s = new StringValue(ParameterEnum.stk, String.valueOf(this.chars[this.index]));
            this.value.put(ParameterEnum.stk, s);
            ++this.index;
            return true;
        }
        if (this.chars[this.index] == 'e' && this.chars[this.index + 1] == 'i' && this.chars[this.index + 2] == 'k') {
            this.index += 4;
            if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                if (this.chars[this.index] != '#') throw new ParserException("Decoding of EndInputKeyParm failed.");
            }
            StringValue s = new StringValue(ParameterEnum.eik, String.valueOf(this.chars[this.index]));
            this.value.put(ParameterEnum.eik, s);
            ++this.index;
            return true;
        }
        if (this.chars[this.index] == 'e' && this.chars[this.index + 1] == 'i' && this.chars[this.index + 2] == 'k') {
            this.index += 4;
            boolean boolStrValue = this.decode_BOOLSTR();
            BooleanValue boolValue = new BooleanValue(ParameterEnum.eik, boolStrValue);
            this.value.put(ParameterEnum.eik, boolValue);
            return true;
        }
        if (this.chars[this.index] == 'o' && this.chars[this.index + 1] == 'a') {
            int number = this.decode_NUMBER();
            NumberValue n = new NumberValue(ParameterEnum.oa, number);
            this.value.put(ParameterEnum.oa, n);
            return true;
        }
        if (this.chars[this.index] == 'r' && this.chars[this.index + 1] == 'a') {
            int number = this.decode_NUMBER();
            NumberValue n = new NumberValue(ParameterEnum.ra, number);
            this.value.put(ParameterEnum.ra, n);
            return true;
        }
        if (this.chars[this.index] == 'd' && this.chars[this.index + 1] == 'p' && this.chars[this.index + 2] == 'a') {
            int number = this.decode_NUMBER();
            NumberValue n = new NumberValue(ParameterEnum.dpa, number);
            this.value.put(ParameterEnum.dpa, n);
            return true;
        }
        if (this.chars[this.index] != 'n') throw new ParserException("Decoding of PlayRecParm failed");
        if (this.chars[this.index + 1] != 'a') throw new ParserException("Decoding of PlayRecParm failed");
        this.index += 3;
        int number = this.decode_NUMBER();
        NumberValue n = new NumberValue(ParameterEnum.na, number);
        this.value.put(ParameterEnum.na, n);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean decode_PlayColParm() throws ParserException {
        String digitPattern;
        boolean decoded = false;
        if (this.index >= this.totalChars) return decoded;
        if (this.chars[this.index] == 'i' && this.chars[this.index + 1] == 'p') {
            this.index += 3;
            AnnouncementParmValue annPaVa = new AnnouncementParmValue(ParameterEnum.ip);
            this.value.put(ParameterEnum.ip, annPaVa);
            return this.decode_Segmentlist(annPaVa);
        }
        if (this.chars[this.index] == 'r' && this.chars[this.index + 1] == 'p') {
            this.index += 3;
            AnnouncementParmValue annPaVa = new AnnouncementParmValue(ParameterEnum.rp);
            this.value.put(ParameterEnum.rp, annPaVa);
            return this.decode_Segmentlist(annPaVa);
        }
        if (this.chars[this.index] == 'n' && this.chars[this.index + 1] == 'd') {
            this.index += 3;
            AnnouncementParmValue annPaVa = new AnnouncementParmValue(ParameterEnum.nd);
            this.value.put(ParameterEnum.nd, annPaVa);
            return this.decode_Segmentlist(annPaVa);
        }
        if (this.chars[this.index] == 'f' && this.chars[this.index + 1] == 'a') {
            this.index += 3;
            AnnouncementParmValue annPaVa = new AnnouncementParmValue(ParameterEnum.fa);
            this.value.put(ParameterEnum.fa, annPaVa);
            return this.decode_Segmentlist(annPaVa);
        }
        if (this.chars[this.index] == 's' && this.chars[this.index + 1] == 'a') {
            this.index += 3;
            AnnouncementParmValue annPaVa = new AnnouncementParmValue(ParameterEnum.sa);
            this.value.put(ParameterEnum.sa, annPaVa);
            return this.decode_Segmentlist(annPaVa);
        }
        if (this.chars[this.index] == 'n' && this.chars[this.index + 1] == 'i') {
            this.index += 3;
            boolean boolStrValue = this.decode_BOOLSTR();
            BooleanValue boolValue = new BooleanValue(ParameterEnum.ni, boolStrValue);
            this.value.put(ParameterEnum.ni, boolValue);
            return true;
        }
        if (this.chars[this.index] == 's' && this.chars[this.index + 1] == 'p') {
            this.index += 3;
            String s = this.decode_SIGNEDINT();
            StringValue sValue = new StringValue(ParameterEnum.sp, s);
            this.value.put(ParameterEnum.sp, sValue);
            return true;
        }
        if (this.chars[this.index] == 'v' && this.chars[this.index + 1] == 'l') {
            this.index += 3;
            String s = this.decode_SIGNEDINT();
            StringValue sValue = new StringValue(ParameterEnum.vl, s);
            this.value.put(ParameterEnum.vl, sValue);
            return true;
        }
        if (this.chars[this.index] == 'c' && this.chars[this.index + 1] == 'b') {
            this.index += 3;
            boolean boolStrValue = this.decode_BOOLSTR();
            BooleanValue boolValue = new BooleanValue(ParameterEnum.cb, boolStrValue);
            this.value.put(ParameterEnum.cb, boolValue);
            return true;
        }
        if (this.chars[this.index] == 'm' && this.chars[this.index + 1] == 'x') {
            this.index += 3;
            int number = this.decode_NUMBER();
            NumberValue n = new NumberValue(ParameterEnum.mx, number);
            this.value.put(ParameterEnum.mx, n);
            return true;
        }
        if (this.chars[this.index] == 'm' && this.chars[this.index + 1] == 'n') {
            this.index += 3;
            int number = this.decode_NUMBER();
            NumberValue n = new NumberValue(ParameterEnum.mn, number);
            this.value.put(ParameterEnum.mn, n);
            return true;
        }
        if (this.chars[this.index] == 'd' && this.chars[this.index + 1] == 'p') {
            this.index += 3;
            digitPattern = "";
            while (this.chars[this.index] != ' ' && this.chars[this.index] != '\t') {
                digitPattern = digitPattern + this.chars[this.index];
                ++this.index;
            }
        } else {
            if (this.chars[this.index] == 'f' && this.chars[this.index + 1] == 'd' && this.chars[this.index + 2] == 't') {
                this.index += 4;
                int number = this.decode_NUMBER();
                NumberValue n = new NumberValue(ParameterEnum.fdt, number);
                this.value.put(ParameterEnum.fdt, n);
                return true;
            }
            if (this.chars[this.index] == 'i' && this.chars[this.index + 1] == 'd' && this.chars[this.index + 2] == 't') {
                this.index += 4;
                int number = this.decode_NUMBER();
                NumberValue n = new NumberValue(ParameterEnum.idt, number);
                this.value.put(ParameterEnum.idt, n);
                return true;
            }
            if (this.chars[this.index] == 'e' && this.chars[this.index + 1] == 'd' && this.chars[this.index + 2] == 't') {
                this.index += 4;
                int number = this.decode_NUMBER();
                NumberValue n = new NumberValue(ParameterEnum.edt, number);
                this.value.put(ParameterEnum.edt, n);
                return true;
            }
            if (this.chars[this.index] == 'r' && this.chars[this.index + 1] == 's' && this.chars[this.index + 2] == 'k') {
                this.index += 4;
                String cmdKeySequence = "";
                if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                    if (this.chars[this.index] != '#') throw new ParserException("Decoding of RestartKeyParm failed");
                }
                decoded = true;
                cmdKeySequence = cmdKeySequence + this.chars[this.index];
                ++this.index;
                for (int i = 1; i < 3 && this.index < this.totalChars && (this.chars[this.index] >= '0' && this.chars[this.index] <= '9' || this.chars[this.index] == '*' || this.chars[this.index] == '#'); ++i) {
                    cmdKeySequence = cmdKeySequence + this.chars[this.index];
                    ++this.index;
                }
                StringValue s = new StringValue(ParameterEnum.rsk, cmdKeySequence);
                this.value.put(ParameterEnum.rsk, s);
                return true;
            }
            if (this.chars[this.index] == 'r' && this.chars[this.index + 1] == 'i' && this.chars[this.index + 2] == 'k') {
                this.index += 4;
                String cmdKeySequence = "";
                if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                    if (this.chars[this.index] != '#') throw new ParserException("Decoding of ReinputKeyParm failed");
                }
                decoded = true;
                cmdKeySequence = cmdKeySequence + this.chars[this.index];
                ++this.index;
                for (int i = 1; i < 3 && this.index < this.totalChars && (this.chars[this.index] >= '0' && this.chars[this.index] <= '9' || this.chars[this.index] == '*' || this.chars[this.index] == '#'); ++i) {
                    cmdKeySequence = cmdKeySequence + this.chars[this.index];
                    ++this.index;
                }
                StringValue s = new StringValue(ParameterEnum.rik, cmdKeySequence);
                this.value.put(ParameterEnum.rik, s);
                return true;
            }
            if (this.chars[this.index] == 'r' && this.chars[this.index + 1] == 't' && this.chars[this.index + 2] == 'k') {
                this.index += 4;
                String cmdKeySequence = "";
                if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                    if (this.chars[this.index] != '#') throw new ParserException("Decoding of ReinputKeyParm failed");
                }
                decoded = true;
                cmdKeySequence = cmdKeySequence + this.chars[this.index];
                ++this.index;
                for (int i = 1; i < 3 && this.index < this.totalChars && (this.chars[this.index] >= '0' && this.chars[this.index] <= '9' || this.chars[this.index] == '*' || this.chars[this.index] == '#'); ++i) {
                    cmdKeySequence = cmdKeySequence + this.chars[this.index];
                    ++this.index;
                }
                StringValue s = new StringValue(ParameterEnum.rtk, cmdKeySequence);
                this.value.put(ParameterEnum.rtk, s);
                return true;
            }
            if (this.chars[this.index] == 'p' && this.chars[this.index + 1] == 's' && this.chars[this.index + 2] == 'k') {
                this.index += 4;
                if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                    if (this.chars[this.index] != '#') throw new ParserException("Decoding of PosKeyParm failed");
                }
                String keyPadKey = String.valueOf(this.chars[this.index]);
                String posKeyAction = null;
                ++this.index;
                if (this.chars[this.index] != ',') throw new ParserException("Decoding of PosKeyParm failed. No comma found after KeyPadKey");
                ++this.index;
                if (this.chars[this.index] == 'f' && this.chars[this.index + 1] == 's' && this.chars[this.index + 2] == 't') {
                    posKeyAction = "fst";
                    this.index += 3;
                } else if (this.chars[this.index] == 'l' && this.chars[this.index + 1] == 's' && this.chars[this.index + 2] == 't') {
                    posKeyAction = "lst";
                    this.index += 3;
                } else if (this.chars[this.index] == 'p' && this.chars[this.index + 1] == 'r' && this.chars[this.index + 2] == 'v') {
                    posKeyAction = "prv";
                    this.index += 3;
                } else if (this.chars[this.index] == 'n' && this.chars[this.index + 1] == 'x' && this.chars[this.index + 2] == 't') {
                    posKeyAction = "nxt";
                    this.index += 3;
                } else {
                    if (this.chars[this.index] != 'c') throw new ParserException("Decoding of PosKeyParm's PosKeyAction failed");
                    if (this.chars[this.index + 1] != 'u') throw new ParserException("Decoding of PosKeyParm's PosKeyAction failed");
                    if (this.chars[this.index + 2] != 'r') throw new ParserException("Decoding of PosKeyParm's PosKeyAction failed");
                    posKeyAction = "cur";
                    this.index += 3;
                }
                PosKeyValue p = new PosKeyValue(ParameterEnum.psk, keyPadKey, posKeyAction);
                this.value.put(ParameterEnum.psk, p);
                return true;
            }
            if (this.chars[this.index] == 's' && this.chars[this.index + 1] == 't' && this.chars[this.index + 2] == 'k') {
                this.index += 4;
                if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                    if (this.chars[this.index] != '#') throw new ParserException("Decoding of StopKeyParm failed.");
                }
                StringValue s = new StringValue(ParameterEnum.stk, String.valueOf(this.chars[this.index]));
                this.value.put(ParameterEnum.stk, s);
                ++this.index;
                return true;
            }
            if (this.chars[this.index] == 's' && this.chars[this.index + 1] == 'i' && this.chars[this.index + 2] == 'k') {
                this.index += 4;
                String keySet = "";
                if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                    if (this.chars[this.index] != '#') throw new ParserException("Decoding of StartInputKeyParm failed.");
                }
                keySet = keySet + this.chars[this.index];
                ++this.index;
                for (int i = 1; i < 11 && this.chars[this.index] != ' ' && this.chars[this.index] != '\t'; ++i) {
                    keySet = keySet + this.chars[this.index];
                    ++this.index;
                }
                StringValue s = new StringValue(ParameterEnum.sik, keySet);
                this.value.put(ParameterEnum.sik, s);
                return true;
            }
            if (this.chars[this.index] == 'e' && this.chars[this.index + 1] == 'i' && this.chars[this.index + 2] == 'k') {
                this.index += 4;
                if ((this.chars[this.index] < '0' || this.chars[this.index] > '9') && this.chars[this.index] != '*') {
                    if (this.chars[this.index] != '#') throw new ParserException("Decoding of EndInputKeyParm failed.");
                }
                StringValue s = new StringValue(ParameterEnum.eik, String.valueOf(this.chars[this.index]));
                this.value.put(ParameterEnum.eik, s);
                ++this.index;
                return true;
            }
            if (this.chars[this.index] == 'i' && this.chars[this.index + 1] == 'e' && this.chars[this.index + 2] == 'k') {
                this.index += 4;
                boolean boolStrValue = this.decode_BOOLSTR();
                BooleanValue boolValue = new BooleanValue(ParameterEnum.iek, boolStrValue);
                this.value.put(ParameterEnum.iek, boolValue);
                return true;
            }
            if (this.chars[this.index] != 'n') throw new ParserException("Decoding of PlayColParm failed");
            if (this.chars[this.index + 1] != 'a') throw new ParserException("Decoding of PlayColParm failed");
            this.index += 3;
            int number = this.decode_NUMBER();
            NumberValue n = new NumberValue(ParameterEnum.na, number);
            this.value.put(ParameterEnum.na, n);
            return true;
        }
        decoded = true;
        StringValue s = new StringValue(ParameterEnum.dp, digitPattern);
        this.value.put(ParameterEnum.dp, s);
        return decoded;
    }

    private boolean decode_BOOLSTR() throws ParserException {
        boolean value = false;
        if (this.chars[this.index] == 't' && this.chars[this.index + 1] == 'r' && this.chars[this.index + 2] == 'u' && this.chars[this.index + 3] == 'e') {
            value = true;
            this.index += 5;
        } else if (this.chars[this.index] == 'f' && this.chars[this.index + 1] == 'a' && this.chars[this.index + 2] == 'l' && this.chars[this.index + 3] == 's' && this.chars[this.index + 3] == 'e') {
            value = false;
            this.index += 6;
        } else {
            throw new ParserException("Parsing of BOOLSTR failed");
        }
        return value;
    }

    private String decode_SIGNEDINT() throws ParserException {
        String sign = "";
        if (this.chars[this.index] == '+') {
            sign = "+";
            ++this.index;
        } else if (this.chars[this.index] == '-') {
            sign = "-";
            ++this.index;
        } else {
            throw new ParserException("Parsing of SIGNEDINT failed");
        }
        return sign + this.decode_NUMBER();
    }

    private int decode_NUMBER() throws ParserException {
        boolean decoded = false;
        String number = "";
        int num = 0;
        if (this.chars[this.index] >= '0' && this.chars[this.index] <= '9') {
            number = number + this.chars[this.index];
            ++this.index;
            decoded = true;
            for (int i = 0; i < 31 && decoded && this.index < this.totalChars; ++i) {
                if (this.chars[this.index] >= '0' && this.chars[this.index] <= '9') {
                    number = number + this.chars[this.index];
                    ++this.index;
                    decoded = true;
                    continue;
                }
                decoded = false;
            }
            try {
                num = Integer.parseInt(number);
            }
            catch (NumberFormatException e) {
                throw new ParserException("decode_NUMBER failed");
            }
        } else {
            throw new ParserException("decode_NUMBER failed");
        }
        return num;
    }

    private boolean decode_PlayAnnParm() throws ParserException {
        boolean decoded = false;
        if (this.index < this.totalChars) {
            if (this.chars[this.index] == 'a' && this.chars[this.index + 1] == 'n') {
                this.index += 3;
                AnnouncementParmValue annPaVa = new AnnouncementParmValue(ParameterEnum.an);
                this.value.put(ParameterEnum.an, annPaVa);
                decoded = this.decode_Segmentlist(annPaVa);
            } else if (this.chars[this.index] == 'i' && this.chars[this.index + 1] == 't') {
                this.index += 3;
                if (this.index < this.totalChars && this.chars[this.index] == '-') {
                    NumberValue temp = new NumberValue(ParameterEnum.it, -1);
                    this.value.put(ParameterEnum.it, temp);
                    this.index += 3;
                    decoded = true;
                } else {
                    int interval = this.decode_NUMBER();
                    NumberValue temp = new NumberValue(ParameterEnum.it, interval);
                    this.value.put(ParameterEnum.it, temp);
                    decoded = true;
                }
            } else if (this.chars[this.index] == 'i' && this.chars[this.index + 1] == 'v') {
                this.index += 3;
                decoded = true;
                int interval = this.decode_NUMBER();
                NumberValue temp = new NumberValue(ParameterEnum.iv, interval);
                this.value.put(ParameterEnum.iv, temp);
            } else if (this.chars[this.index] == 'd' && this.chars[this.index + 1] == 'u') {
                this.index += 3;
                decoded = true;
                int interval = this.decode_NUMBER();
                NumberValue temp = new NumberValue(ParameterEnum.du, interval);
                this.value.put(ParameterEnum.du, temp);
            } else if (this.chars[this.index] == 's' && this.chars[this.index + 1] == 'p') {
                this.index += 3;
                String num = this.decode_SIGNEDINT();
                decoded = true;
                StringValue temp = new StringValue(ParameterEnum.sp, num);
                this.value.put(ParameterEnum.sp, temp);
            } else if (this.chars[this.index] == 'v' && this.chars[this.index + 1] == 'l') {
                this.index += 3;
                String num = this.decode_SIGNEDINT();
                decoded = true;
                StringValue temp = new StringValue(ParameterEnum.vl, num);
                this.value.put(ParameterEnum.vl, temp);
            } else {
                throw new ParserException("PlayAnn decoding failed. None of AnnouncementParm / IterationsParm / IntervalParm / DurationParm / SpeedParm / VolumeParm found");
            }
        }
        return decoded;
    }
}

