/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.io.tls;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdiameter.api.Configuration;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.client.impl.transport.tls.TLSClientConnection;
import org.jdiameter.client.impl.transport.tls.TLSUtils;
import org.jdiameter.common.api.concurrent.DummyConcurrentFactory;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.server.api.IMetaData;
import org.jdiameter.server.api.io.INetworkConnectionListener;
import org.jdiameter.server.api.io.INetworkGuard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkGuard
implements INetworkGuard,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(NetworkGuard.class);
    private IMessageParser parser;
    private IConcurrentFactory concurrentFactory;
    private int port;
    private CopyOnWriteArrayList<INetworkConnectionListener> listeners = new CopyOnWriteArrayList();
    private boolean isWork = false;
    private ServerSocket serverSocket;
    private Configuration localPeerSSLConfig;
    private Thread thread;
    private String secRef;

    public NetworkGuard(InetAddress inetAddress, int port, IConcurrentFactory concurrentFactory, IMessageParser parser, IMetaData data) throws Exception {
        this.port = port;
        this.parser = parser;
        this.concurrentFactory = concurrentFactory == null ? new DummyConcurrentFactory() : concurrentFactory;
        this.thread = this.concurrentFactory.getThread("NetworkGuard", this);
        Configuration conf = data.getConfiguration();
        if (!conf.isAttributeExist(Parameters.SecurityRef.ordinal())) {
            throw new IllegalArgumentException("No security_ref attribute present in local peer!");
        }
        String secRef = conf.getStringValue(Parameters.SecurityRef.ordinal(), "");
        this.localPeerSSLConfig = TLSUtils.getSSLConfiguration(conf, secRef);
        if (this.localPeerSSLConfig == null) {
            throw new IllegalArgumentException("No Security for security_reference '" + secRef + "'");
        }
        try {
            this.serverSocket = new ServerSocket();
            this.serverSocket.bind(new InetSocketAddress(inetAddress, port));
            this.isWork = true;
            logger.info("Open server socket {} ", (Object)this.serverSocket);
            this.thread.start();
        }
        catch (Exception exc) {
            this.destroy();
            throw new Exception(exc);
        }
    }

    @Override
    public void run() {
        try {
            while (this.isWork) {
                try {
                    Socket clientConnection = this.serverSocket.accept();
                    logger.info("Open incomming SSL connection {}", (Object)clientConnection);
                    TLSClientConnection client = new TLSClientConnection(null, this.localPeerSSLConfig, this.concurrentFactory, clientConnection, this.parser);
                    this.notifyListeners(client);
                }
                catch (Exception e) {
                    logger.debug("Failed to accept connection,", (Throwable)e);
                }
            }
        }
        catch (Exception exc) {
            logger.warn("Server socket stopped", (Throwable)exc);
        }
    }

    @Override
    public void addListener(INetworkConnectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void remListener(INetworkConnectionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void destroy() {
        try {
            this.isWork = false;
            try {
                if (this.thread != null) {
                    this.thread.join(2000L);
                    if (this.thread.isAlive()) {
                        this.thread.interrupt();
                    }
                    this.thread = null;
                }
            }
            catch (InterruptedException e) {
                logger.debug("Can not stop thread", (Throwable)e);
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }

    private void notifyListeners(TLSClientConnection client) {
        for (INetworkConnectionListener listener : this.listeners) {
            try {
                listener.newNetworkConnection(client);
            }
            catch (Exception e) {
                logger.debug("Connection listener threw exception!", (Throwable)e);
            }
        }
    }
}

