/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.io.sctp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.OverloadException;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.io.IConnection;
import org.jdiameter.client.api.io.IConnectionListener;
import org.jdiameter.client.api.io.TransportError;
import org.jdiameter.client.api.io.TransportException;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.server.impl.io.sctp.NetworkGuard;
import org.jdiameter.server.impl.io.sctp.SCTPTransportServer;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.Management;
import org.mobicents.protocols.api.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCTPServerConnection
implements IConnection {
    private static Logger logger = LoggerFactory.getLogger(SCTPServerConnection.class);
    private final long createdTime;
    private SCTPTransportServer server;
    private LinkedBlockingQueue<Event> buffer = new LinkedBlockingQueue(64);
    private IMessageParser parser;
    private Lock lock = new ReentrantLock();
    private ConcurrentLinkedQueue<IConnectionListener> listeners = new ConcurrentLinkedQueue();
    private String cachedKey = null;
    private NetworkGuard parentGuard;

    protected SCTPServerConnection(IMessageParser parser, NetworkGuard guard) {
        this.createdTime = System.currentTimeMillis();
        this.parser = parser;
        this.parentGuard = guard;
        this.server = new SCTPTransportServer(this);
    }

    public SCTPServerConnection(Configuration config, InetAddress localAddress, int localPort, IMessageParser parser, String ref, NetworkGuard guard) throws Exception {
        this(parser, guard);
        logger.debug("SCTP Server constructor for listening server @ {}:{}", (Object)localAddress, (Object)localPort);
        this.server.setOrigAddress(new InetSocketAddress(localAddress, localPort));
        this.server.startServer();
    }

    public SCTPServerConnection(Configuration config, InetAddress remoteAddress, int remotePort, InetAddress localAddress, int localPort, IMessageParser parser, String ref, NetworkGuard guard, Server globalServer, Association association, Management management) throws Exception {
        this(parser, guard);
        logger.debug("SCTP Server constructor for remote client connections @ {}:{} <=> {}:{}", new Object[]{localAddress, localPort, remoteAddress, remotePort});
        this.server.setOrigAddress(new InetSocketAddress(localAddress, localPort));
        this.server.setDestAddress(new InetSocketAddress(remoteAddress, remotePort));
        this.server.setManagement(management);
        this.server.startNewRemoteConnection(globalServer, association, remoteAddress.getHostAddress(), remotePort);
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public void connect() throws TransportException {
    }

    @Override
    public void disconnect() throws InternalError {
        logger.debug("Disconnecting SCTP Server Connection {}", (Object)this.getKey());
        try {
            if (this.getServer() != null) {
                this.getServer().stop();
            }
        }
        catch (Exception e) {
            throw new InternalError("Error while stopping transport: " + e.getMessage());
        }
    }

    public Management getManagement() {
        return this.getServer().getManagement();
    }

    public void destroy() throws InternalError {
        logger.debug("Destroying SCTP Server Connection {}", (Object)this.getKey());
        try {
            if (this.getServer() != null) {
                this.getServer().destroy();
            }
        }
        catch (Exception e) {
            throw new InternalError("Error while stopping transport: " + e.getMessage());
        }
    }

    @Override
    public void release() throws IOException {
        logger.debug("Releasing SCTP Server Connection {}", (Object)this.getKey());
        try {
            if (this.getServer() != null) {
                this.getServer().release();
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            this.buffer.clear();
            this.remAllConnectionListener();
        }
    }

    public void onNewRemoteConnection(Server server, Association association) {
        this.getParentGuard().onNewRemoteConnection(server, association, this);
    }

    public NetworkGuard getParentGuard() {
        return this.parentGuard;
    }

    @Override
    public void sendMessage(IMessage message) throws TransportException, OverloadException {
        try {
            if (this.getServer() != null) {
                this.getServer().sendMessage(this.parser.encodeMessage(message));
            }
        }
        catch (Exception e) {
            throw new TransportException("Cannot send message: ", TransportError.FailedSendMessage, e);
        }
    }

    protected SCTPTransportServer getServer() {
        return this.server;
    }

    @Override
    public boolean isNetworkInitiated() {
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.getServer() != null && this.getServer().isConnected();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.getServer().getDestAddress().getAddress();
    }

    @Override
    public int getRemotePort() {
        if (this.getServer() == null) {
            logger.debug("server is null");
        } else if (this.getServer().getDestAddress() == null) {
            logger.debug("dest address is null");
        } else if (this.getServer().getDestAddress().getPort() == 0) {
            logger.debug("dest address port is 0");
        }
        return this.getServer().getDestAddress().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionListener(IConnectionListener listener) {
        this.lock.lock();
        try {
            this.listeners.add(listener);
            if (this.buffer.size() != 0) {
                for (Event e : this.buffer) {
                    try {
                        this.onEvent(e);
                    }
                    catch (AvpDataException avpDataException) {}
                }
                this.buffer.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remAllConnectionListener() {
        this.lock.lock();
        try {
            this.listeners.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remConnectionListener(IConnectionListener listener) {
        this.lock.lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        return false;
    }

    public <T> T unwrap(Class<T> aClass) throws InternalException {
        return null;
    }

    @Override
    public String getKey() {
        if (this.cachedKey == null) {
            this.cachedKey = new StringBuffer("aaa://").append(this.getRemoteAddress().getHostName()).append(":").append(this.getRemotePort()).toString();
        }
        return this.cachedKey;
    }

    protected void onDisconnect() throws AvpDataException {
        this.onEvent(new Event(EventType.DISCONNECTED));
    }

    protected void onMessageReceived(ByteBuffer message) throws AvpDataException {
        if (logger.isDebugEnabled()) {
            logger.debug("Received message of size [{}]", (Object)message.array().length);
        }
        this.onEvent(new Event(EventType.MESSAGE_RECEIVED, message));
    }

    protected void onAvpDataException(AvpDataException e) {
        try {
            this.onEvent(new Event(EventType.DATA_EXCEPTION, (Exception)((Object)e)));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    protected void onConnected() {
        try {
            this.onEvent(new Event(EventType.CONNECTED));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    protected void logDetails() throws AvpDataException {
        if (logger.isDebugEnabled()) {
            logger.debug("Listeners for {}", (Object)this.getKey());
            for (IConnectionListener listener : this.listeners) {
                logger.debug("Listener [{}]", (Object)listener);
            }
            logger.debug("Event Queue for {}", (Object)this.getKey());
            for (Event event : this.buffer) {
                logger.debug("Event [{}]", (Object)event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEvent(Event event) throws AvpDataException {
        logger.debug("In onEvent for connection [{}]. Getting lock", (Object)this.getKey());
        this.lock.lock();
        this.logDetails();
        try {
            for (IConnectionListener listener : this.listeners) {
                switch (event.type) {
                    case CONNECTED: {
                        listener.connectionOpened(this.getKey());
                        break;
                    }
                    case DISCONNECTED: {
                        listener.connectionClosed(this.getKey(), null);
                        break;
                    }
                    case MESSAGE_RECEIVED: {
                        listener.messageReceived(this.getKey(), this.parser.createMessage(event.message));
                        break;
                    }
                    case DATA_EXCEPTION: {
                        listener.internalError(this.getKey(), null, new TransportException("Avp Data Exception:", TransportError.ReceivedBrokenMessage, event.exception));
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class Event {
        EventType type;
        ByteBuffer message;
        Exception exception;

        Event(EventType type) {
            this.type = type;
        }

        Event(EventType type, Exception exception) {
            this(type);
            this.exception = exception;
        }

        Event(EventType type, ByteBuffer message) {
            this(type);
            this.message = message;
        }
    }

    private static enum EventType {
        CONNECTED,
        DISCONNECTED,
        MESSAGE_RECEIVED,
        DATA_EXCEPTION;

    }
}

