/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.s13;

import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.s13.ServerS13Session;
import org.jdiameter.api.s13.ServerS13SessionListener;
import org.jdiameter.api.s13.events.JMEIdentityCheckAnswer;
import org.jdiameter.api.s13.events.JMEIdentityCheckRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.s13.IS13MessageFactory;
import org.jdiameter.common.api.app.s13.S13SessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.s13.S13Session;
import org.jdiameter.server.impl.app.s13.Event;
import org.jdiameter.server.impl.app.s13.IServerS13SessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S13ServerSessionImpl
extends S13Session
implements ServerS13Session,
EventListener<Request, Answer>,
NetworkReqListener {
    private static final Logger logger = LoggerFactory.getLogger(S13ServerSessionImpl.class);
    private transient ServerS13SessionListener listener;
    protected long appId = -1L;
    protected IServerS13SessionData sessionData;

    public S13ServerSessionImpl(IServerS13SessionData sessionData, IS13MessageFactory fct, ISessionFactory sf, ServerS13SessionListener lst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        this.appId = fct.getApplicationId();
        if (this.appId < 0L) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.listener = lst;
        this.messageFactory = fct;
        this.sessionData = sessionData;
    }

    public void sendMEIdentityCheckAnswer(JMEIdentityCheckAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, null, (AppEvent)answer);
    }

    public <E> E getState(Class<E> stateType) {
        return (E)((Object)(stateType == S13SessionState.class ? this.sessionData.getS13SessionState() : null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            if (!this.session.isValid()) {
                boolean bl = false;
                return bl;
            }
            S13SessionState state = this.sessionData.getS13SessionState();
            S13SessionState newState = null;
            Event localEvent = (Event)event;
            Event.Type eventType = (Event.Type)event.getType();
            switch (state) {
                case IDLE: {
                    switch (eventType) {
                        case RECEIVE_ECR: {
                            this.sessionData.setBuffer((Request)((AppEvent)event.getData()).getMessage());
                            super.cancelMsgTimer();
                            super.startMsgTimer();
                            newState = S13SessionState.MESSAGE_SENT_RECEIVED;
                            this.setState(newState);
                            this.listener.doMEIdentityCheckRequestEvent((ServerS13Session)this, (JMEIdentityCheckRequest)event.getData());
                            return true;
                        }
                        case SEND_MESSAGE: {
                            this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                            newState = S13SessionState.MESSAGE_SENT_RECEIVED;
                            this.setState(newState);
                            return true;
                        }
                    }
                    logger.error("Wrong action in S13 Server FSM. State: IDLE, Event Type: {}", (Object)eventType);
                    return true;
                }
                case MESSAGE_SENT_RECEIVED: {
                    switch (eventType) {
                        case TIMEOUT_EXPIRES: {
                            newState = S13SessionState.TIMEDOUT;
                            this.setState(newState);
                            return true;
                        }
                        case SEND_MESSAGE: {
                            try {
                                this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                                return true;
                            }
                            finally {
                                newState = S13SessionState.TERMINATED;
                                this.setState(newState);
                            }
                        }
                    }
                    throw new InternalException("Should not receive more messages after initial. Command: " + event.getData());
                }
                case TERMINATED: {
                    throw new InternalException("Cant receive message in state TERMINATED. Command: " + event.getData());
                }
                case TIMEDOUT: {
                    throw new InternalException("Cant receive message in state TIMEDOUT. Command: " + event.getData());
                }
            }
            logger.error("S13 Server FSM in wrong state: {}", (Object)state);
            return true;
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        try {
            this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)request), null));
        }
        catch (Exception e) {
            logger.debug("Failed to process timeout message", (Throwable)e);
        }
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    protected void send(Event.Type type, AppEvent request, AppEvent answer) throws InternalException {
        try {
            if (type != null) {
                this.handleEvent(new Event(type, request, answer));
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    protected void setState(S13SessionState newState) {
        S13SessionState oldState = this.sessionData.getS13SessionState();
        this.sessionData.setS13SessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
        if (newState == S13SessionState.TERMINATED || newState == S13SessionState.TIMEDOUT) {
            super.cancelMsgTimer();
            this.release();
        }
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals("IDLE_SESSION_TIMER")) {
            this.checkIdleAppSession();
        } else {
            if (timerName.equals("MSG_TIMEOUT")) {
                try {
                    this.sendAndStateLock.lock();
                    try {
                        this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)this.sessionData.getBuffer()), null));
                    }
                    catch (Exception e) {
                        logger.debug("Failure handling Timeout event.");
                    }
                    this.sessionData.setBuffer(null);
                    this.sessionData.setTsTimerId(null);
                }
                finally {
                    this.sendAndStateLock.unlock();
                }
            }
            logger.warn("Received an unknown timer '{}' for Session-ID '{}'", (Object)timerName, (Object)this.getSessionId());
        }
    }

    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
            }
            catch (Exception e) {
                logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    private class AnswerDelivery
    implements Runnable {
        ServerS13Session session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        @Override
        public void run() {
            try {
                switch (this.answer.getCommandCode()) {
                    default: 
                }
                S13ServerSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
            }
            catch (Exception e) {
                logger.debug("Failed to process success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ServerS13Session session;
        Request request;

        private RequestDelivery() {
        }

        @Override
        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 324: {
                        S13ServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_ECR, (AppEvent)S13ServerSessionImpl.this.messageFactory.createMEIdentityCheckRequest(this.request), null));
                        break;
                    }
                    default: {
                        S13ServerSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }
}

