/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.concurrent;

import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.jdiameter.common.impl.concurrent.AbstractTask;

class DefaultRunnable
extends AbstractTask<Runnable>
implements Runnable {
    DefaultRunnable(Runnable task, IStatistic statistic, IStatisticRecord ... statisticRecords) {
        super(task, statistic, statisticRecords);
    }

    @Override
    public void run() {
        if (this.getCounter(IStatisticRecord.Counters.WorkingThread) != null) {
            this.getCounter(IStatisticRecord.Counters.WorkingThread).inc();
        }
        long time = System.nanoTime();
        try {
            ((Runnable)this.parentTask).run();
        }
        catch (RuntimeException e) {
            if (this.getCounter(IStatisticRecord.Counters.BrokenTasks) != null) {
                this.getCounter(IStatisticRecord.Counters.BrokenTasks).inc();
            }
            throw e;
        }
        finally {
            this.updateTimeStatistic(time, time - this.createdTime);
            if (this.getCounter(IStatisticRecord.Counters.WorkingThread) != null) {
                this.getCounter(IStatisticRecord.Counters.WorkingThread).dec();
            }
        }
    }
}

