/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.slh;

import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.slh.ClientSLhSession;
import org.jdiameter.api.slh.ClientSLhSessionListener;
import org.jdiameter.api.slh.ServerSLhSession;
import org.jdiameter.api.slh.ServerSLhSessionListener;
import org.jdiameter.api.slh.events.LCSRoutingInfoAnswer;
import org.jdiameter.api.slh.events.LCSRoutingInfoRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.slh.IClientSLhSessionData;
import org.jdiameter.client.impl.app.slh.SLhClientSessionImpl;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.slh.ISLhMessageFactory;
import org.jdiameter.common.api.app.slh.ISLhSessionData;
import org.jdiameter.common.api.app.slh.ISLhSessionFactory;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.slh.LCSRoutingInfoAnswerImpl;
import org.jdiameter.common.impl.app.slh.LCSRoutingInfoRequestImpl;
import org.jdiameter.common.impl.app.slh.SLhSession;
import org.jdiameter.server.impl.app.slh.IServerSLhSessionData;
import org.jdiameter.server.impl.app.slh.SLhServerSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLhSessionFactoryImpl
implements ISLhSessionFactory,
ServerSLhSessionListener,
ClientSLhSessionListener,
ISLhMessageFactory,
StateChangeListener<AppSession> {
    private static final Logger logger = LoggerFactory.getLogger(SLhSessionFactoryImpl.class);
    protected ISessionFactory sessionFactory;
    protected ServerSLhSessionListener serverSessionListener;
    protected ClientSLhSessionListener clientSessionListener;
    protected ISLhMessageFactory messageFactory;
    protected StateChangeListener<AppSession> stateListener;
    protected ISessionDatasource iss;
    protected IAppSessionDataFactory<ISLhSessionData> sessionDataFactory;

    public SLhSessionFactoryImpl() {
    }

    public SLhSessionFactoryImpl(SessionFactory sessionFactory) {
        this.init(sessionFactory);
    }

    public void init(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
        this.iss = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        this.sessionDataFactory = this.iss.getDataFactory(ISLhSessionData.class);
    }

    @Override
    public ServerSLhSessionListener getServerSessionListener() {
        return this.serverSessionListener != null ? this.serverSessionListener : this;
    }

    @Override
    public void setServerSessionListener(ServerSLhSessionListener serverSessionListener) {
        this.serverSessionListener = serverSessionListener;
    }

    @Override
    public ClientSLhSessionListener getClientSessionListener() {
        return this.clientSessionListener != null ? this.clientSessionListener : this;
    }

    @Override
    public void setClientSessionListener(ClientSLhSessionListener clientSessionListener) {
        this.clientSessionListener = clientSessionListener;
    }

    @Override
    public ISLhMessageFactory getMessageFactory() {
        return this.messageFactory != null ? this.messageFactory : this;
    }

    @Override
    public void setMessageFactory(ISLhMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public StateChangeListener<AppSession> getStateListener() {
        return this.stateListener != null ? this.stateListener : this;
    }

    @Override
    public void setStateListener(StateChangeListener<AppSession> stateListener) {
        this.stateListener = stateListener;
    }

    @Override
    public AppSession getSession(String sessionId, Class<? extends AppSession> aClass) {
        SLhSession appSession;
        block6: {
            if (sessionId == null) {
                throw new IllegalArgumentException("SessionId must not be null");
            }
            if (!this.iss.exists(sessionId)) {
                return null;
            }
            appSession = null;
            try {
                if (aClass == ServerSLhSession.class) {
                    IServerSLhSessionData sessionData = (IServerSLhSessionData)this.sessionDataFactory.getAppSessionData(ServerSLhSession.class, sessionId);
                    SLhServerSessionImpl serverSession = new SLhServerSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener());
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block6;
                }
                if (aClass == ClientSLhSession.class) {
                    IClientSLhSessionData sessionData = (IClientSLhSessionData)this.sessionDataFactory.getAppSessionData(ClientSLhSession.class, sessionId);
                    SLhClientSessionImpl clientSession = new SLhClientSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener());
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block6;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ServerSLhSession.class + "]");
            }
            catch (Exception e) {
                logger.error("Failure to obtain new SLh Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    @Override
    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        SLhSession appSession;
        block10: {
            appSession = null;
            try {
                if (aClass == ServerSLhSession.class) {
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    IServerSLhSessionData sessionData = (IServerSLhSessionData)this.sessionDataFactory.getAppSessionData(ServerSLhSession.class, sessionId);
                    sessionData.setApplicationId(applicationId);
                    SLhServerSessionImpl serverSession = new SLhServerSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener());
                    this.iss.addSession((BaseSession)serverSession);
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block10;
                }
                if (aClass == ClientSLhSession.class) {
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    IClientSLhSessionData sessionData = (IClientSLhSessionData)this.sessionDataFactory.getAppSessionData(ClientSLhSession.class, sessionId);
                    sessionData.setApplicationId(applicationId);
                    SLhClientSessionImpl clientSession = new SLhClientSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener());
                    this.iss.addSession((BaseSession)clientSession);
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block10;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ServerSLhSession.class + "]");
            }
            catch (Exception e) {
                logger.error("Failure to obtain new SLh Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    public void stateChanged(Enum oldState, Enum newState) {
        logger.info("Diameter SLh Session Factory :: stateChanged :: oldState[{}], newState[{}]", (Object)oldState, (Object)newState);
    }

    @Override
    public long getApplicationId() {
        return 16777291L;
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        logger.info("Diameter SLh Session Factory :: stateChanged :: Session, [{}], oldState[{}], newState[{}]", new Object[]{source, oldState, newState});
    }

    @Override
    public LCSRoutingInfoAnswer createLCSRoutingInfoAnswer(Answer answer) {
        return new LCSRoutingInfoAnswerImpl(answer);
    }

    @Override
    public LCSRoutingInfoRequest createLCSRoutingInfoRequest(Request request) {
        return new LCSRoutingInfoRequestImpl((Message)request);
    }

    public void doLCSRoutingInfoRequestEvent(ServerSLhSession appSession, LCSRoutingInfoRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter SLh Session Factory :: doLCSRoutingInfoRequestEvent :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter SLh Session Factory :: doOtherEvent :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doLCSRoutingInfoAnswerEvent(ClientSLhSession appSession, LCSRoutingInfoRequest request, LCSRoutingInfoAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter SLh Session Factory :: doLCSRoutingInfoAnswerEvent :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }
}

