/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.slg;

import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.slg.ClientSLgSession;
import org.jdiameter.api.slg.ClientSLgSessionListener;
import org.jdiameter.api.slg.ServerSLgSession;
import org.jdiameter.api.slg.ServerSLgSessionListener;
import org.jdiameter.api.slg.events.LocationReportAnswer;
import org.jdiameter.api.slg.events.LocationReportRequest;
import org.jdiameter.api.slg.events.ProvideLocationAnswer;
import org.jdiameter.api.slg.events.ProvideLocationRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.slg.IClientSLgSessionData;
import org.jdiameter.client.impl.app.slg.SLgClientSessionImpl;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.slg.ISLgMessageFactory;
import org.jdiameter.common.api.app.slg.ISLgSessionData;
import org.jdiameter.common.api.app.slg.ISLgSessionFactory;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.slg.LocationReportAnswerImpl;
import org.jdiameter.common.impl.app.slg.LocationReportRequestImpl;
import org.jdiameter.common.impl.app.slg.ProvideLocationAnswerImpl;
import org.jdiameter.common.impl.app.slg.ProvideLocationRequestImpl;
import org.jdiameter.common.impl.app.slg.SLgSession;
import org.jdiameter.server.impl.app.slg.IServerSLgSessionData;
import org.jdiameter.server.impl.app.slg.SLgServerSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLgSessionFactoryImpl
implements ISLgSessionFactory,
ServerSLgSessionListener,
ClientSLgSessionListener,
ISLgMessageFactory,
StateChangeListener<AppSession> {
    private static final Logger logger = LoggerFactory.getLogger(SLgSessionFactoryImpl.class);
    protected ISessionFactory sessionFactory;
    protected ServerSLgSessionListener serverSessionListener;
    protected ClientSLgSessionListener clientSessionListener;
    protected ISLgMessageFactory messageFactory;
    protected StateChangeListener<AppSession> stateListener;
    protected ISessionDatasource iss;
    protected IAppSessionDataFactory<ISLgSessionData> sessionDataFactory;

    public SLgSessionFactoryImpl() {
    }

    public SLgSessionFactoryImpl(SessionFactory sessionFactory) {
        this.init(sessionFactory);
    }

    public void init(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
        this.iss = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        this.sessionDataFactory = this.iss.getDataFactory(ISLgSessionData.class);
    }

    @Override
    public ServerSLgSessionListener getServerSessionListener() {
        return this.serverSessionListener != null ? this.serverSessionListener : this;
    }

    @Override
    public void setServerSessionListener(ServerSLgSessionListener serverSessionListener) {
        this.serverSessionListener = serverSessionListener;
    }

    @Override
    public ClientSLgSessionListener getClientSessionListener() {
        return this.clientSessionListener != null ? this.clientSessionListener : this;
    }

    @Override
    public void setClientSessionListener(ClientSLgSessionListener clientSessionListener) {
        this.clientSessionListener = clientSessionListener;
    }

    @Override
    public ISLgMessageFactory getMessageFactory() {
        return this.messageFactory != null ? this.messageFactory : this;
    }

    @Override
    public void setMessageFactory(ISLgMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public StateChangeListener<AppSession> getStateListener() {
        return this.stateListener != null ? this.stateListener : this;
    }

    @Override
    public void setStateListener(StateChangeListener<AppSession> stateListener) {
        this.stateListener = stateListener;
    }

    @Override
    public AppSession getSession(String sessionId, Class<? extends AppSession> aClass) {
        SLgSession appSession;
        block6: {
            if (sessionId == null) {
                throw new IllegalArgumentException("SessionId must not be null");
            }
            if (!this.iss.exists(sessionId)) {
                return null;
            }
            appSession = null;
            try {
                if (aClass == ServerSLgSession.class) {
                    IServerSLgSessionData sessionData = (IServerSLgSessionData)this.sessionDataFactory.getAppSessionData(ServerSLgSession.class, sessionId);
                    SLgServerSessionImpl serverSession = new SLgServerSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener());
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block6;
                }
                if (aClass == ClientSLgSession.class) {
                    IClientSLgSessionData sessionData = (IClientSLgSessionData)this.sessionDataFactory.getAppSessionData(ClientSLgSession.class, sessionId);
                    SLgClientSessionImpl clientSession = new SLgClientSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener());
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block6;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ServerSLgSession.class + "]");
            }
            catch (Exception e) {
                logger.error("Failure to obtain new SLg Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    @Override
    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        SLgSession appSession;
        block10: {
            appSession = null;
            try {
                if (aClass == ServerSLgSession.class) {
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    IServerSLgSessionData sessionData = (IServerSLgSessionData)this.sessionDataFactory.getAppSessionData(ServerSLgSession.class, sessionId);
                    sessionData.setApplicationId(applicationId);
                    SLgServerSessionImpl serverSession = new SLgServerSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener());
                    this.iss.addSession((BaseSession)serverSession);
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block10;
                }
                if (aClass == ClientSLgSession.class) {
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    IClientSLgSessionData sessionData = (IClientSLgSessionData)this.sessionDataFactory.getAppSessionData(ClientSLgSession.class, sessionId);
                    sessionData.setApplicationId(applicationId);
                    SLgClientSessionImpl clientSession = new SLgClientSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener());
                    this.iss.addSession((BaseSession)clientSession);
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block10;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ServerSLgSession.class + "]");
            }
            catch (Exception e) {
                logger.error("Failure to obtain new SLg Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    public void stateChanged(Enum oldState, Enum newState) {
        logger.info("Diameter SLg Session Factory :: stateChanged :: oldState[{}], newState[{}]", (Object)oldState, (Object)newState);
    }

    @Override
    public long getApplicationId() {
        return 16777255L;
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        logger.info("Diameter SLg Session Factory :: stateChanged :: Session, [{}], oldState[{}], newState[{}]", new Object[]{source, oldState, newState});
    }

    @Override
    public ProvideLocationRequest createProvideLocationRequest(Request request) {
        return new ProvideLocationRequestImpl((Message)request);
    }

    @Override
    public ProvideLocationAnswer createProvideLocationAnswer(Answer answer) {
        return new ProvideLocationAnswerImpl(answer);
    }

    public void doProvideLocationRequestEvent(ServerSLgSession appSession, ProvideLocationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter SLg Session Factory :: doProvideLocationRequestEvent :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doProvideLocationAnswerEvent(ClientSLgSession appSession, ProvideLocationRequest request, ProvideLocationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter SLg Session Factory :: doProvideLocationAnswerEvent :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    @Override
    public LocationReportRequest createLocationReportRequest(Request request) {
        return new LocationReportRequestImpl((Message)request);
    }

    @Override
    public LocationReportAnswer createLocationReportAnswer(Answer answer) {
        return new LocationReportAnswerImpl(answer);
    }

    public void doLocationReportRequestEvent(ClientSLgSession appSession, LocationReportRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter SLg Session Factory :: doLocationReportRequestEvent :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doLocationReportAnswerEvent(ServerSLgSession appSession, LocationReportRequest request, LocationReportAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter SLg Session Factory :: doLocationReportAnswerEvent :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter SLg Session Factory :: doOtherEvent :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }
}

