/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.s13;

import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.s13.ClientS13Session;
import org.jdiameter.api.s13.ClientS13SessionListener;
import org.jdiameter.api.s13.ServerS13Session;
import org.jdiameter.api.s13.ServerS13SessionListener;
import org.jdiameter.api.s13.events.JMEIdentityCheckAnswer;
import org.jdiameter.api.s13.events.JMEIdentityCheckRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.s13.IClientS13SessionData;
import org.jdiameter.client.impl.app.s13.S13ClientSessionImpl;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.s13.IS13MessageFactory;
import org.jdiameter.common.api.app.s13.IS13SessionData;
import org.jdiameter.common.api.app.s13.IS13SessionFactory;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.s13.JMEIdentityCheckAnswerImpl;
import org.jdiameter.common.impl.app.s13.JMEIdentityCheckRequestImpl;
import org.jdiameter.common.impl.app.s13.S13Session;
import org.jdiameter.server.impl.app.s13.IServerS13SessionData;
import org.jdiameter.server.impl.app.s13.S13ServerSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S13SessionFactoryImpl
implements IS13SessionFactory,
ServerS13SessionListener,
ClientS13SessionListener,
IS13MessageFactory,
StateChangeListener<AppSession> {
    private static final Logger logger = LoggerFactory.getLogger(S13SessionFactoryImpl.class);
    protected ISessionFactory sessionFactory;
    protected ServerS13SessionListener serverSessionListener;
    protected ClientS13SessionListener clientSessionListener;
    protected IS13MessageFactory messageFactory;
    protected StateChangeListener<AppSession> stateListener;
    protected ISessionDatasource iss;
    protected IAppSessionDataFactory<IS13SessionData> sessionDataFactory;

    public S13SessionFactoryImpl() {
    }

    public S13SessionFactoryImpl(SessionFactory sessionFactory) {
        this.init(sessionFactory);
    }

    public void init(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
        this.iss = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        this.sessionDataFactory = this.iss.getDataFactory(IS13SessionData.class);
    }

    @Override
    public ServerS13SessionListener getServerSessionListener() {
        return this.serverSessionListener != null ? this.serverSessionListener : this;
    }

    @Override
    public void setServerSessionListener(ServerS13SessionListener serverSessionListener) {
        this.serverSessionListener = serverSessionListener;
    }

    @Override
    public ClientS13SessionListener getClientSessionListener() {
        return this.clientSessionListener != null ? this.clientSessionListener : this;
    }

    @Override
    public void setClientSessionListener(ClientS13SessionListener clientSessionListener) {
        this.clientSessionListener = clientSessionListener;
    }

    @Override
    public IS13MessageFactory getMessageFactory() {
        return this.messageFactory != null ? this.messageFactory : this;
    }

    @Override
    public void setMessageFactory(IS13MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public StateChangeListener<AppSession> getStateListener() {
        return this.stateListener != null ? this.stateListener : this;
    }

    @Override
    public void setStateListener(StateChangeListener<AppSession> stateListener) {
        this.stateListener = stateListener;
    }

    @Override
    public AppSession getSession(String sessionId, Class<? extends AppSession> aClass) {
        S13Session appSession;
        block6: {
            if (sessionId == null) {
                throw new IllegalArgumentException("SessionId must not be null");
            }
            if (!this.iss.exists(sessionId)) {
                return null;
            }
            appSession = null;
            try {
                if (aClass == ServerS13Session.class) {
                    IServerS13SessionData sessionData = (IServerS13SessionData)this.sessionDataFactory.getAppSessionData(ServerS13Session.class, sessionId);
                    S13ServerSessionImpl serverSession = new S13ServerSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener());
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block6;
                }
                if (aClass == ClientS13Session.class) {
                    IClientS13SessionData sessionData = (IClientS13SessionData)this.sessionDataFactory.getAppSessionData(ClientS13Session.class, sessionId);
                    S13ClientSessionImpl clientSession = new S13ClientSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener());
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block6;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ServerS13Session.class + "]");
            }
            catch (Exception e) {
                logger.error("Failure to obtain new S13 Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    @Override
    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        S13Session appSession;
        block10: {
            appSession = null;
            try {
                if (aClass == ServerS13Session.class) {
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    IServerS13SessionData sessionData = (IServerS13SessionData)this.sessionDataFactory.getAppSessionData(ServerS13Session.class, sessionId);
                    sessionData.setApplicationId(applicationId);
                    S13ServerSessionImpl serverSession = new S13ServerSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener());
                    this.iss.addSession((BaseSession)serverSession);
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block10;
                }
                if (aClass == ClientS13Session.class) {
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    IClientS13SessionData sessionData = (IClientS13SessionData)this.sessionDataFactory.getAppSessionData(ClientS13Session.class, sessionId);
                    sessionData.setApplicationId(applicationId);
                    S13ClientSessionImpl clientSession = new S13ClientSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener());
                    this.iss.addSession((BaseSession)clientSession);
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block10;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ServerS13Session.class + "]");
            }
            catch (Exception e) {
                logger.error("Failure to obtain new S13 Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    public void stateChanged(Enum oldState, Enum newState) {
        logger.info("Diameter S13 Session Factory :: stateChanged :: oldState[{}], newState[{}]", (Object)oldState, (Object)newState);
    }

    @Override
    public long getApplicationId() {
        return 16777252L;
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        logger.info("Diameter S13 Session Factory :: stateChanged :: Session, [{}], oldState[{}], newState[{}]", new Object[]{source, oldState, newState});
    }

    @Override
    public JMEIdentityCheckAnswer createMEIdentityCheckAnswer(Answer answer) {
        return new JMEIdentityCheckAnswerImpl(answer);
    }

    @Override
    public JMEIdentityCheckRequest createMEIdentityCheckRequest(Request request) {
        return new JMEIdentityCheckRequestImpl((Message)request);
    }

    public void doMEIdentityCheckRequestEvent(ServerS13Session appSession, JMEIdentityCheckRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S13 Session Factory :: doMEIdentityCheckRequestEvent :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S13 Session Factory :: doOtherEvent :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doMEIdentityCheckAnswerEvent(ClientS13Session appSession, JMEIdentityCheckRequest request, JMEIdentityCheckAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S13 Session Factory :: doMEIdentityCheckAnswerEvent :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }
}

