/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.gq;

import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.auth.ClientAuthSession;
import org.jdiameter.api.auth.ClientAuthSessionListener;
import org.jdiameter.api.auth.ServerAuthSession;
import org.jdiameter.api.auth.ServerAuthSessionListener;
import org.jdiameter.api.auth.events.AbortSessionAnswer;
import org.jdiameter.api.auth.events.AbortSessionRequest;
import org.jdiameter.api.auth.events.ReAuthAnswer;
import org.jdiameter.api.auth.events.ReAuthRequest;
import org.jdiameter.api.auth.events.SessionTermAnswer;
import org.jdiameter.api.auth.events.SessionTermRequest;
import org.jdiameter.api.gq.GqClientSession;
import org.jdiameter.api.gq.GqServerSession;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.auth.IClientAuthSessionData;
import org.jdiameter.client.impl.app.gq.GqClientSessionImpl;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.auth.IAuthMessageFactory;
import org.jdiameter.common.api.app.auth.IAuthSessionData;
import org.jdiameter.common.api.app.auth.IAuthSessionFactory;
import org.jdiameter.common.api.app.auth.IClientAuthActionContext;
import org.jdiameter.common.api.app.auth.IServerAuthActionContext;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.server.impl.app.auth.IServerAuthSessionData;
import org.jdiameter.server.impl.app.gq.GqServerSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GqSessionFactoryImpl
implements IAuthSessionFactory,
IAuthMessageFactory,
ServerAuthSessionListener,
ClientAuthSessionListener,
IClientAuthActionContext,
IServerAuthActionContext,
StateChangeListener<AppSession> {
    private static final long authAppId = 0x1000006L;
    protected IAuthMessageFactory messageFactory;
    protected ServerAuthSessionListener serverSessionListener;
    protected StateChangeListener<AppSession> stateListener;
    protected ClientAuthSessionListener clientSessionListener;
    protected boolean stateles;
    protected long messageTimeout = 5000L;
    protected static final Logger logger = LoggerFactory.getLogger(GqSessionFactoryImpl.class);
    protected ISessionDatasource iss;
    protected ISessionFactory sessionFactory = null;
    protected IServerAuthActionContext serverSessionContext;
    protected IClientAuthActionContext clientSessionContext;
    protected IAppSessionDataFactory<IAuthSessionData> sessionDataFactory;

    public GqSessionFactoryImpl(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
        this.iss = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        this.sessionDataFactory = this.iss.getDataFactory(IAuthSessionData.class);
    }

    @Override
    public IClientAuthActionContext getClientSessionContext() {
        return this.clientSessionContext != null ? this.clientSessionContext : this;
    }

    @Override
    public void setClientSessionContext(IClientAuthActionContext clientSessionContext) {
        this.clientSessionContext = clientSessionContext;
    }

    @Override
    public IServerAuthActionContext getServerSessionContext() {
        return this.serverSessionContext != null ? this.serverSessionContext : this;
    }

    @Override
    public void setServerSessionContext(IServerAuthActionContext serverSessionContext) {
        this.serverSessionContext = serverSessionContext;
    }

    @Override
    public long getMessageTimeout() {
        return this.messageTimeout;
    }

    @Override
    public void setMessageTimeout(long messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    @Override
    public IAuthMessageFactory getMessageFactory() {
        return this.messageFactory != null ? this.messageFactory : this;
    }

    @Override
    public void setMessageFactory(IAuthMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public ServerAuthSessionListener getServerSessionListener() {
        return this.serverSessionListener != null ? this.serverSessionListener : this;
    }

    @Override
    public void setServerSessionListener(ServerAuthSessionListener serverSessionListener) {
        this.serverSessionListener = serverSessionListener;
    }

    @Override
    public StateChangeListener<AppSession> getStateListener() {
        return this.stateListener != null ? this.stateListener : this;
    }

    @Override
    public void setStateListener(StateChangeListener<AppSession> stateListener) {
        this.stateListener = stateListener;
    }

    @Override
    public ClientAuthSessionListener getClientSessionListener() {
        return this.clientSessionListener != null ? this.clientSessionListener : this;
    }

    @Override
    public void setClientSessionListener(ClientAuthSessionListener clientSessionListener) {
        this.clientSessionListener = clientSessionListener;
    }

    @Override
    public boolean isStateles() {
        return this.stateles;
    }

    @Override
    public void setStateles(boolean stateles) {
        this.stateles = stateles;
    }

    @Override
    public AppSession getSession(String sessionId, Class<? extends AppSession> aClass) {
        if (sessionId == null) {
            throw new IllegalArgumentException("SessionId must not be null");
        }
        if (!this.iss.exists(sessionId)) {
            return null;
        }
        try {
            if (aClass == GqServerSession.class) {
                IServerAuthSessionData sessionData = (IServerAuthSessionData)this.sessionDataFactory.getAppSessionData(GqServerSession.class, sessionId);
                GqServerSessionImpl session = new GqServerSessionImpl(sessionData, this.sessionFactory, this.getServerSessionListener(), this.getMessageFactory(), this.getStateListener(), this.getServerSessionContext(), this.messageTimeout, this.isStateles());
                session.getSessions().get(0).setRequestListener((NetworkReqListener)session);
                return session;
            }
            if (aClass == GqClientSession.class) {
                IClientAuthSessionData sessionData = (IClientAuthSessionData)this.sessionDataFactory.getAppSessionData(GqClientSession.class, sessionId);
                GqClientSessionImpl session = new GqClientSessionImpl(sessionData, this.sessionFactory, this.getClientSessionListener(), this.getMessageFactory(), this.getStateListener(), this.getClientSessionContext(), this.isStateles());
                session.getSessions().get(0).setRequestListener((NetworkReqListener)session);
                return session;
            }
        }
        catch (Exception e) {
            logger.error("Failure trying to obtain new authorization session", (Throwable)e);
        }
        return null;
    }

    @Override
    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        try {
            if (aClass == GqServerSession.class) {
                if (sessionId == null) {
                    if (args != null && args.length > 0 && args[0] instanceof Request) {
                        Request request = (Request)args[0];
                        sessionId = request.getSessionId();
                    } else {
                        sessionId = this.sessionFactory.getSessionId();
                    }
                }
                IServerAuthSessionData sessionData = (IServerAuthSessionData)this.sessionDataFactory.getAppSessionData(ServerAuthSession.class, sessionId);
                sessionData.setApplicationId(applicationId);
                GqServerSessionImpl session = new GqServerSessionImpl(sessionData, this.sessionFactory, this.getServerSessionListener(), this.getMessageFactory(), this.getStateListener(), this.getServerSessionContext(), this.messageTimeout, this.isStateles());
                this.iss.addSession((BaseSession)session);
                session.getSessions().get(0).setRequestListener((NetworkReqListener)session);
                return session;
            }
            if (aClass == GqClientSession.class) {
                if (sessionId == null) {
                    if (args != null && args.length > 0 && args[0] instanceof Request) {
                        Request request = (Request)args[0];
                        sessionId = request.getSessionId();
                    } else {
                        sessionId = this.sessionFactory.getSessionId();
                    }
                }
                IClientAuthSessionData sessionData = (IClientAuthSessionData)this.sessionDataFactory.getAppSessionData(ClientAuthSession.class, sessionId);
                sessionData.setApplicationId(applicationId);
                GqClientSessionImpl session = new GqClientSessionImpl(sessionData, this.sessionFactory, this.getClientSessionListener(), this.getMessageFactory(), this.getStateListener(), this.getClientSessionContext(), this.isStateles());
                this.iss.addSession((BaseSession)session);
                session.getSessions().get(0).setRequestListener((NetworkReqListener)session);
                return session;
            }
        }
        catch (Exception e) {
            logger.error("Failure trying to obtain new authorization session", (Throwable)e);
        }
        return null;
    }

    @Override
    public AppAnswerEvent createAuthAnswer(Answer answer) {
        return new AppAnswerEventImpl(answer);
    }

    @Override
    public AppRequestEvent createAuthRequest(Request request) {
        return new AppRequestEventImpl((Message)request);
    }

    @Override
    public int getAuthMessageCommandCode() {
        return 265;
    }

    @Override
    public ApplicationId getApplicationId() {
        return ApplicationId.createByAuthAppId((long)0x1000006L);
    }

    public void doAbortSessionRequestEvent(ClientAuthSession appSession, AbortSessionRequest asr) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Gq AuthorizationSessionFactory :: doAbortSessionRequestEvent :: appSession[{}], ASR[{}]", (Object)appSession, (Object)asr);
    }

    public void doAbortSessionAnswerEvent(ServerAuthSession appSession, AbortSessionAnswer asa) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Gq AuthorizationSessionFactory :: doAbortSessionAnswerEvent :: appSession[{}], ASA[{}]", (Object)appSession, (Object)asa);
    }

    public void doSessionTerminationRequestEvent(ServerAuthSession appSession, SessionTermRequest str) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Gq AuthorizationSessionFactory :: doSessionTerminationRequestEvent :: appSession[{}], STR[{}]", (Object)appSession, (Object)str);
    }

    public void doSessionTerminationAnswerEvent(ClientAuthSession appSession, SessionTermAnswer sta) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Gq AuthorizationSessionFactory :: doSessionTerminationAnswerEvent :: appSession[{}], STA[{}]", (Object)appSession, (Object)sta);
    }

    public void doAuthRequestEvent(ServerAuthSession appSession, AppRequestEvent request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Gq AuthorizationSessionFactory :: doAuthRequestEvent :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doAuthAnswerEvent(ClientAuthSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Gq AuthorizationSessionFactory :: doAuthAnswerEvent :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doReAuthRequestEvent(ClientAuthSession appSession, ReAuthRequest rar) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Gq AuthorizationSessionFactory :: doReAuthRequestEvent :: appSession[{}], RAR[{}]", (Object)appSession, (Object)rar);
    }

    public void doReAuthAnswerEvent(ServerAuthSession appSession, ReAuthRequest rar, ReAuthAnswer raa) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Gq AuthorizationSessionFactory :: doReAuthAnswerEvent :: appSession[{}], RAR[{}], RAA[{}]", new Object[]{appSession, rar, raa});
    }

    public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Gq AuthorizationSessionFactory :: doOtherEvent :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void stateChanged(Enum oldState, Enum newState) {
        logger.info("Diameter Gq AuthorizationSessionFactory  :: stateChanged :: oldState[{}], newState[{}]", (Object)oldState, (Object)newState);
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        logger.info("Diameter Gq AuthorizationSessionFactory :: stateChanged :: source[{}], oldState[{}], newState[{}]", new Object[]{source, oldState, newState});
    }

    @Override
    public void accessTimeoutElapses(ClientAuthSession session) throws InternalException {
    }

    @Override
    public long getAccessTimeout() throws InternalException {
        return 20000L;
    }

    @Override
    public void disconnectUserOrDev(ClientAuthSession session, Message request) throws InternalException {
    }

    @Override
    public void accessTimeoutElapses(ServerAuthSession session) throws InternalException {
    }
}

