/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.cca;

import org.jdiameter.api.Answer;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Request;
import org.jdiameter.api.cca.events.JCreditControlAnswer;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCreditControlAnswerImpl
extends AppAnswerEventImpl
implements JCreditControlAnswer {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = LoggerFactory.getLogger(JCreditControlAnswerImpl.class);
    private static final int CREDIT_CONTROL_FAILURE_HANDLING_AVP_CODE = 427;
    private static final int DIRECT_DEBITING_FAILURE_HANDLING_AVP_CODE = 428;
    private static final int REQUESTED_ACTION_AVP_CODE = 436;
    private static final int CC_REQUEST_TYPE_AVP_CODE = 416;
    private static final int VALIDITY_TIME_AVP_CODE = 448;

    public JCreditControlAnswerImpl(Answer answer) {
        super(answer);
    }

    public JCreditControlAnswerImpl(Request request, long vendorId, long resultCode) {
        super(request, vendorId, resultCode);
    }

    public JCreditControlAnswerImpl(Request request, long resultCode) {
        super(request, resultCode);
    }

    public JCreditControlAnswerImpl(Request request) {
        super(request);
    }

    public boolean isCreditControlFailureHandlingAVPPresent() {
        return this.message.getAvps().getAvp(427) != null;
    }

    public int getCredidControlFailureHandlingAVPValue() {
        Avp credidControlFailureHandlingAvp = this.message.getAvps().getAvp(427);
        if (credidControlFailureHandlingAvp != null) {
            try {
                return credidControlFailureHandlingAvp.getInteger32();
            }
            catch (AvpDataException e) {
                logger.debug("Failure trying to obtain Credit-Control-Failure-Handling AVP value", (Throwable)e);
            }
        }
        return -1;
    }

    public boolean isDirectDebitingFailureHandlingAVPPresent() {
        return this.message.getAvps().getAvp(428) != null;
    }

    public int getDirectDebitingFailureHandlingAVPValue() {
        Avp directDebitingFailureHandlingAvp = this.message.getAvps().getAvp(428);
        if (directDebitingFailureHandlingAvp != null) {
            try {
                return directDebitingFailureHandlingAvp.getInteger32();
            }
            catch (AvpDataException e) {
                logger.debug("Failure trying to obtain Direct-Debiting-Failure-Handling AVP value", (Throwable)e);
            }
        }
        return -1;
    }

    public Avp getValidityTimeAvp() {
        return this.message.getAvps().getAvp(448);
    }

    public boolean isRequestTypeAVPPresent() {
        return this.message.getAvps().getAvp(416) != null;
    }

    public int getRequestTypeAVPValue() {
        Avp requestTypeAvp = this.message.getAvps().getAvp(416);
        if (requestTypeAvp != null) {
            try {
                return requestTypeAvp.getInteger32();
            }
            catch (AvpDataException e) {
                logger.debug("Failure trying to obtain CC-Request-Type AVP value", (Throwable)e);
            }
        }
        return -1;
    }

    public boolean isRequestedActionAVPPresent() {
        return this.message.getAvps().getAvp(436) != null;
    }

    public int getRequestedActionAVPValue() {
        Avp requestedActionAvp = this.message.getAvps().getAvp(436);
        if (requestedActionAvp != null) {
            try {
                return requestedActionAvp.getInteger32();
            }
            catch (AvpDataException e) {
                logger.debug("Failure trying to obtain Requested-Action AVP value", (Throwable)e);
            }
        }
        return -1;
    }
}

