/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.fsm;

import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.Message;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.PeerState;
import org.jdiameter.api.StatisticRecord;
import org.jdiameter.api.app.State;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.api.validation.Dictionary;
import org.jdiameter.api.validation.ValidatorLevel;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.fsm.EventTypes;
import org.jdiameter.client.api.fsm.FsmEvent;
import org.jdiameter.client.api.fsm.IContext;
import org.jdiameter.client.api.fsm.IStateMachine;
import org.jdiameter.client.impl.DictionarySingleton;
import org.jdiameter.client.impl.fsm.FsmState;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerFSMImpl
implements IStateMachine {
    private static final Logger logger = LoggerFactory.getLogger(PeerFSMImpl.class);
    protected final Dictionary dictionary = DictionarySingleton.getDictionary();
    protected ConcurrentLinkedQueue<StateChangeListener> listeners;
    protected LinkedBlockingQueue<StateEvent> eventQueue;
    protected FsmState state = FsmState.DOWN;
    protected boolean watchdogSent;
    protected long timer;
    protected long CEA_TIMEOUT = 0L;
    protected long IAC_TIMEOUT = 0L;
    protected long REC_TIMEOUT = 0L;
    protected long DWA_TIMEOUT = 0L;
    protected long DPA_TIMEOUT = 0L;
    private static int FSM_THREAD_COUNT = 3;
    protected final StateEvent timeOutEvent = new FsmEvent(EventTypes.TIMEOUT_EVENT);
    protected Random random = new Random();
    protected IConcurrentFactory concurrentFactory;
    protected IContext context;
    protected State[] states;
    protected int predefSize;
    private Lock lock = new ReentrantLock();
    protected IStatisticManager statisticFactory;
    protected IStatistic queueStat;
    protected IStatisticRecord timeSumm;
    protected IStatisticRecord timeCount;
    protected boolean mustRun = false;
    protected AtomicInteger numberOfThreadsRunning = new AtomicInteger(0);

    public PeerFSMImpl(IContext aContext, IConcurrentFactory concurrentFactory, Configuration config, IStatisticManager statisticFactory) {
        this.context = aContext;
        this.statisticFactory = statisticFactory;
        this.predefSize = config.getIntValue(Parameters.QueueSize.ordinal(), ((Integer)Parameters.QueueSize.defValue()).intValue());
        logger.debug("Maximum FSM Queue size is [{}]", (Object)this.predefSize);
        this.eventQueue = new LinkedBlockingQueue(this.predefSize);
        this.listeners = new ConcurrentLinkedQueue();
        this.loadTimeOuts(config);
        this.concurrentFactory = concurrentFactory;
        FSM_THREAD_COUNT = config.getIntValue(Parameters.PeerFSMThreadCount.ordinal(), ((Integer)Parameters.PeerFSMThreadCount.defValue()).intValue());
        this.runQueueProcessing();
    }

    @Override
    public IStatistic getStatistic() {
        return this.queueStat;
    }

    public void removeStateChangeNotification(StateChangeListener stateChangeListener) {
        this.listeners.remove(stateChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQueueProcessing() {
        try {
            this.lock.lock();
            if (this.numberOfThreadsRunning.get() > 0) {
                return;
            }
            this.eventQueue.clear();
            this.mustRun = true;
            IStatisticRecord queueSize = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.QueueSize, new IStatisticRecord.IntegerValueHolder(){

                @Override
                public int getValueAsInt() {
                    return PeerFSMImpl.this.eventQueue.size();
                }

                @Override
                public String getValueAsString() {
                    return String.valueOf(this.getValueAsInt());
                }
            });
            this.timeSumm = this.statisticFactory.newCounterRecord("TimeSumm", "TimeSumm");
            this.timeCount = this.statisticFactory.newCounterRecord("TimeCount", "TimeCount");
            IStatisticRecord messagePrcAverageTime = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.MessageProcessingTime, new IStatisticRecord.DoubleValueHolder(){

                @Override
                public double getValueAsDouble() {
                    if (PeerFSMImpl.this.queueStat == null) {
                        return 0.0;
                    }
                    IStatisticRecord mpta = PeerFSMImpl.this.queueStat.getRecordByName(IStatisticRecord.Counters.MessageProcessingTime.name());
                    StatisticRecord[] children = mpta.getChilds();
                    if (children.length == 2 && children[1].getValueAsLong() != 0L) {
                        long count = children[1].getValueAsLong();
                        return (float)children[0].getValueAsLong() / (float)(count != 0L ? count : 1L);
                    }
                    return 0.0;
                }

                @Override
                public String getValueAsString() {
                    return String.valueOf(this.getValueAsDouble());
                }
            }, this.timeSumm, this.timeCount);
            logger.debug("Initializing QueueStat @ Thread[{}]", (Object)Thread.currentThread().getName());
            this.queueStat = this.statisticFactory.newStatistic(this.context.getPeerDescription(), IStatistic.Groups.PeerFSM, queueSize, messagePrcAverageTime);
            logger.debug("Finished Initializing QueueStat @ Thread[{}]", (Object)Thread.currentThread().getName());
            Runnable fsmQueueProcessor = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int runningNow = PeerFSMImpl.this.numberOfThreadsRunning.incrementAndGet();
                    logger.debug("Starting ... [{}] FSM threads are running", (Object)runningNow);
                    while (PeerFSMImpl.this.mustRun) {
                        StateEvent event;
                        block12: {
                            try {
                                event = PeerFSMImpl.this.eventQueue.poll(100L, TimeUnit.MILLISECONDS);
                                if (!logger.isDebugEnabled() || event == null) break block12;
                                logger.debug("Got Event [{}] from Queue", (Object)event);
                            }
                            catch (InterruptedException e) {
                                logger.debug("Peer FSM stopped", (Throwable)e);
                                break;
                            }
                        }
                        try {
                            if (event != null) {
                                if (event instanceof FsmEvent && PeerFSMImpl.this.queueStat != null && PeerFSMImpl.this.queueStat.isEnabled()) {
                                    PeerFSMImpl.this.timeSumm.inc(System.currentTimeMillis() - ((FsmEvent)event).getCreatedTime());
                                    PeerFSMImpl.this.timeCount.inc();
                                }
                                logger.debug("Process event [{}]. Peer State is [{}]", (Object)event, (Object)PeerFSMImpl.this.state);
                                PeerFSMImpl.this.getStates()[PeerFSMImpl.this.state.ordinal()].processEvent(event);
                            }
                            if (PeerFSMImpl.this.timer == 0L || PeerFSMImpl.this.timer >= System.currentTimeMillis()) continue;
                            PeerFSMImpl.this.lock.lock();
                            try {
                                if (PeerFSMImpl.this.timer == 0L || PeerFSMImpl.this.timer >= System.currentTimeMillis()) continue;
                                PeerFSMImpl.this.timer = 0L;
                                if (PeerFSMImpl.this.state == FsmState.DOWN) continue;
                                logger.debug("Sending timeout event");
                                PeerFSMImpl.this.handleEvent(PeerFSMImpl.this.timeOutEvent);
                            }
                            finally {
                                PeerFSMImpl.this.lock.unlock();
                            }
                        }
                        catch (Exception e) {
                            logger.debug("Error during processing FSM event", (Throwable)e);
                        }
                    }
                    logger.debug("FSM Thread {} is exiting", (Object)Thread.currentThread().getName());
                    PeerFSMImpl.this.statisticFactory.removeStatistic(PeerFSMImpl.this.queueStat);
                    logger.debug("Setting QueueStat to null @ Thread [{}]", (Object)Thread.currentThread().getName());
                    PeerFSMImpl.this.queueStat = null;
                    logger.debug("Done Setting QueueStat to null @ Thread [{}]", (Object)Thread.currentThread().getName());
                    int runningNowAfterStop = PeerFSMImpl.this.numberOfThreadsRunning.decrementAndGet();
                    logger.debug("Stopping ... [{}] FSM threads are running", (Object)runningNowAfterStop);
                }
            };
            for (int i = 1; i <= FSM_THREAD_COUNT; ++i) {
                logger.debug("Starting FSM Thread {} of {}", (Object)i, (Object)FSM_THREAD_COUNT);
                Thread executor = this.concurrentFactory.getThread("FSM-" + this.context.getPeerDescription() + "_" + i, fsmQueueProcessor);
                executor.start();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public double getQueueInfo() {
        return (double)this.eventQueue.size() * 1.0 / (double)this.predefSize;
    }

    protected void loadTimeOuts(Configuration config) {
        this.CEA_TIMEOUT = config.getLongValue(Parameters.CeaTimeOut.ordinal(), ((Long)Parameters.CeaTimeOut.defValue()).longValue());
        this.IAC_TIMEOUT = config.getLongValue(Parameters.IacTimeOut.ordinal(), ((Long)Parameters.IacTimeOut.defValue()).longValue());
        this.DWA_TIMEOUT = config.getLongValue(Parameters.DwaTimeOut.ordinal(), ((Long)Parameters.DwaTimeOut.defValue()).longValue());
        this.DPA_TIMEOUT = config.getLongValue(Parameters.DpaTimeOut.ordinal(), ((Long)Parameters.DpaTimeOut.defValue()).longValue());
        this.REC_TIMEOUT = config.getLongValue(Parameters.RecTimeOut.ordinal(), ((Long)Parameters.RecTimeOut.defValue()).longValue());
    }

    public void addStateChangeNotification(StateChangeListener stateChangeListener) {
        if (!this.listeners.contains(stateChangeListener)) {
            this.listeners.add(stateChangeListener);
        }
    }

    @Override
    public void remStateChangeNotification(StateChangeListener stateChangeListener) {
        this.listeners.remove(stateChangeListener);
    }

    protected void switchToNextState(FsmState newState) {
        if (newState.getPublicState() != this.state.getPublicState()) {
            for (StateChangeListener l : this.listeners) {
                l.stateChanged(this.state.getPublicState(), newState.getPublicState());
            }
        }
        this.getStates()[this.state.ordinal()].exitAction();
        if (logger.isDebugEnabled()) {
            logger.debug("{} FSM switch state: {} -> {}", new Object[]{this.context.getPeerDescription(), this.state, newState});
        }
        this.state = newState;
        this.getStates()[this.state.ordinal()].entryAction();
    }

    public boolean handleEvent(StateEvent event) throws InternalError, OverloadException {
        if (logger.isDebugEnabled()) {
            logger.debug("Handling event with type [{}]", (Object)event.getType());
        }
        if (this.numberOfThreadsRunning.get() == 0) {
            logger.debug("No FSM threads are running so calling runQueueProcessing()");
            this.runQueueProcessing();
        }
        if (event.getData() != null) {
            boolean incoming = event.getType() == EventTypes.RECEIVE_MSG_EVENT;
            ValidatorLevel incomingLevel = this.dictionary.getReceiveLevel();
            if (incoming && this.dictionary != null && this.dictionary.isEnabled() && incomingLevel != ValidatorLevel.OFF) {
                logger.debug("Performing validation to INCOMING message since validator is ENABLED.");
                try {
                    this.dictionary.validate((Message)event.getData(), incoming);
                }
                catch (AvpNotAllowedException e) {
                    logger.error("Failed to validate incoming message.", (Throwable)e);
                    return false;
                }
            } else {
                logger.debug("Not performing incoming validation on message. Validator Enabled [{}] Incoming [{}] Incoming Level [{}]", new Object[]{this.dictionary != null && this.dictionary.isEnabled(), incoming, incomingLevel});
            }
        }
        boolean rc = false;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Placing event [{}] into linked blocking queue with remaining capacity: [{}].", (Object)event, (Object)this.eventQueue.remainingCapacity());
            }
            rc = this.eventQueue.offer(event, this.IAC_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.debug("Can not put event '" + event.toString() + "' to FSM " + this.toString(), (Throwable)e);
            throw new InternalError("Can not put event '" + event.toString() + "' to FSM " + this.toString());
        }
        if (!rc) {
            throw new OverloadException("FSM overloaded");
        }
        return true;
    }

    protected void setInActiveTimer() {
        this.timer = this.IAC_TIMEOUT - 2000L + (long)(this.random.nextInt(5) * 1000) + System.currentTimeMillis();
    }

    public String toString() {
        return "PeerFSM{context=" + this.context + ", state=" + this.state + '}';
    }

    public <E> E getState(Class<E> a) {
        if (a == PeerState.class) {
            return (E)this.state.getPublicState();
        }
        return null;
    }

    protected State[] getStates() {
        if (this.states == null) {
            this.states = new State[]{new MyState(){

                @Override
                public void entryAction() {
                    PeerFSMImpl.this.setInActiveTimer();
                    PeerFSMImpl.this.watchdogSent = false;
                }

                public boolean processEvent(StateEvent event) {
                    switch ((EventTypes)((Object)event.encodeType(EventTypes.class))) {
                        case DISCONNECT_EVENT: {
                            PeerFSMImpl.this.timer = PeerFSMImpl.this.REC_TIMEOUT + System.currentTimeMillis();
                            PeerFSMImpl.this.switchToNextState(FsmState.REOPEN);
                            break;
                        }
                        case TIMEOUT_EVENT: {
                            try {
                                PeerFSMImpl.this.context.sendDwrMessage();
                                this.setTimer(PeerFSMImpl.this.DWA_TIMEOUT);
                                if (PeerFSMImpl.this.watchdogSent) {
                                    PeerFSMImpl.this.switchToNextState(FsmState.SUSPECT);
                                    break;
                                }
                                PeerFSMImpl.this.watchdogSent = true;
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DWR", e);
                                this.doDisconnect();
                                this.setTimer(PeerFSMImpl.this.REC_TIMEOUT);
                                PeerFSMImpl.this.switchToNextState(FsmState.REOPEN);
                            }
                            break;
                        }
                        case STOP_EVENT: {
                            try {
                                if (event.getData() == null) {
                                    PeerFSMImpl.this.context.sendDprMessage(0);
                                } else {
                                    Integer disconnectCause = (Integer)event.getData();
                                    PeerFSMImpl.this.context.sendDprMessage(disconnectCause);
                                }
                                this.setTimer(PeerFSMImpl.this.DPA_TIMEOUT);
                                PeerFSMImpl.this.switchToNextState(FsmState.STOPPING);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DPR", e);
                                this.doDisconnect();
                                PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            }
                            break;
                        }
                        case RECEIVE_MSG_EVENT: {
                            PeerFSMImpl.this.setInActiveTimer();
                            PeerFSMImpl.this.context.receiveMessage(this.message(event));
                            break;
                        }
                        case DPR_EVENT: {
                            try {
                                int code = PeerFSMImpl.this.context.processDprMessage(this.message(event));
                                PeerFSMImpl.this.context.sendDpaMessage(this.message(event), code, null);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DPA", e);
                            }
                            this.doDisconnect();
                            PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            break;
                        }
                        case DWR_EVENT: {
                            PeerFSMImpl.this.setInActiveTimer();
                            try {
                                int code = PeerFSMImpl.this.context.processDwrMessage(this.message(event));
                                PeerFSMImpl.this.context.sendDwaMessage(this.message(event), code, null);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DWA", e);
                                this.doDisconnect();
                                PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            }
                            break;
                        }
                        case DWA_EVENT: {
                            PeerFSMImpl.this.setInActiveTimer();
                            PeerFSMImpl.this.watchdogSent = false;
                            break;
                        }
                        case SEND_MSG_EVENT: {
                            try {
                                PeerFSMImpl.this.context.sendMessage(this.message(event));
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send message", e);
                                this.doDisconnect();
                                this.setTimer(PeerFSMImpl.this.REC_TIMEOUT);
                                PeerFSMImpl.this.switchToNextState(FsmState.REOPEN);
                            }
                            break;
                        }
                        default: {
                            logger.debug("Unknown event type: {} in state {}", event.encodeType(EventTypes.class), (Object)PeerFSMImpl.this.state);
                            return false;
                        }
                    }
                    return true;
                }
            }, new MyState(){

                public boolean processEvent(StateEvent event) {
                    switch ((EventTypes)((Object)event.encodeType(EventTypes.class))) {
                        case DISCONNECT_EVENT: {
                            this.setTimer(PeerFSMImpl.this.REC_TIMEOUT);
                            PeerFSMImpl.this.switchToNextState(FsmState.REOPEN);
                            break;
                        }
                        case TIMEOUT_EVENT: {
                            this.doDisconnect();
                            this.setTimer(PeerFSMImpl.this.REC_TIMEOUT);
                            PeerFSMImpl.this.switchToNextState(FsmState.REOPEN);
                            break;
                        }
                        case STOP_EVENT: {
                            try {
                                if (event.getData() == null) {
                                    PeerFSMImpl.this.context.sendDprMessage(0);
                                } else {
                                    Integer disconnectCause = (Integer)event.getData();
                                    PeerFSMImpl.this.context.sendDprMessage(disconnectCause);
                                }
                                PeerFSMImpl.this.setInActiveTimer();
                                PeerFSMImpl.this.switchToNextState(FsmState.STOPPING);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DPR", e);
                                this.doDisconnect();
                                PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            }
                            break;
                        }
                        case DPR_EVENT: {
                            try {
                                int code = PeerFSMImpl.this.context.processDprMessage(this.message(event));
                                PeerFSMImpl.this.context.sendDpaMessage(this.message(event), code, null);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DPA", e);
                            }
                            this.doDisconnect();
                            PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            break;
                        }
                        case DWA_EVENT: {
                            PeerFSMImpl.this.switchToNextState(FsmState.OKAY);
                            break;
                        }
                        case DWR_EVENT: {
                            try {
                                int code = PeerFSMImpl.this.context.processDwrMessage(this.message(event));
                                PeerFSMImpl.this.context.sendDwaMessage(this.message(event), code, null);
                                PeerFSMImpl.this.switchToNextState(FsmState.OKAY);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DWA", e);
                                this.doDisconnect();
                                PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            }
                            break;
                        }
                        case RECEIVE_MSG_EVENT: {
                            PeerFSMImpl.this.context.receiveMessage(this.message(event));
                            PeerFSMImpl.this.switchToNextState(FsmState.OKAY);
                            break;
                        }
                        case SEND_MSG_EVENT: {
                            throw new RuntimeException("Connection is down");
                        }
                        default: {
                            logger.debug("Unknown event type: {} in state {}", event.encodeType(EventTypes.class), (Object)PeerFSMImpl.this.state);
                            return false;
                        }
                    }
                    return true;
                }
            }, new MyState(){

                @Override
                public void entryAction() {
                    this.clearTimer();
                    logger.debug("Setting mustRun to false @ Thread [{}]", (Object)Thread.currentThread().getName());
                    PeerFSMImpl.this.mustRun = false;
                    logger.debug("Finished Setting mustRun to false @ Thread [{}]", (Object)Thread.currentThread().getName());
                    PeerFSMImpl.this.context.removeStatistics();
                }

                public boolean processEvent(StateEvent event) {
                    switch ((EventTypes)((Object)event.encodeType(EventTypes.class))) {
                        case START_EVENT: {
                            try {
                                PeerFSMImpl.this.context.createStatistics();
                                PeerFSMImpl.this.context.connect();
                                PeerFSMImpl.this.context.sendCerMessage();
                                this.setTimer(PeerFSMImpl.this.CEA_TIMEOUT);
                                PeerFSMImpl.this.switchToNextState(FsmState.INITIAL);
                            }
                            catch (Throwable e) {
                                logger.debug("Connect error", e);
                                this.setTimer(PeerFSMImpl.this.REC_TIMEOUT);
                                PeerFSMImpl.this.switchToNextState(FsmState.REOPEN);
                            }
                            break;
                        }
                        case SEND_MSG_EVENT: {
                            throw new RuntimeException("Connection is down");
                        }
                        case DISCONNECT_EVENT: 
                        case STOP_EVENT: {
                            break;
                        }
                        default: {
                            logger.debug("Unknown event type: {} in state {}", event.encodeType(EventTypes.class), (Object)PeerFSMImpl.this.state);
                            return false;
                        }
                    }
                    return true;
                }
            }, new MyState(){

                public boolean processEvent(StateEvent event) {
                    switch ((EventTypes)((Object)event.encodeType(EventTypes.class))) {
                        case CONNECT_EVENT: {
                            try {
                                PeerFSMImpl.this.context.sendCerMessage();
                                this.setTimer(PeerFSMImpl.this.CEA_TIMEOUT);
                                PeerFSMImpl.this.switchToNextState(FsmState.INITIAL);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send CER", e);
                                this.setTimer(PeerFSMImpl.this.REC_TIMEOUT);
                            }
                            break;
                        }
                        case TIMEOUT_EVENT: {
                            try {
                                PeerFSMImpl.this.context.connect();
                            }
                            catch (Exception e) {
                                logger.debug("Timeout processed. Can not connect to {}", (Object)PeerFSMImpl.this.context.getPeerDescription());
                                this.setTimer(PeerFSMImpl.this.REC_TIMEOUT);
                            }
                            break;
                        }
                        case STOP_EVENT: {
                            this.clearTimer();
                            this.doDisconnect();
                            PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            break;
                        }
                        case DISCONNECT_EVENT: {
                            break;
                        }
                        case SEND_MSG_EVENT: {
                            throw new IllegalStateException("Connection is down");
                        }
                        default: {
                            logger.debug("Unknown event type: {} in state {}", event.encodeType(EventTypes.class), (Object)PeerFSMImpl.this.state);
                            return false;
                        }
                    }
                    return true;
                }
            }, new MyState(){

                @Override
                public void entryAction() {
                    this.setTimer(PeerFSMImpl.this.CEA_TIMEOUT);
                }

                public boolean processEvent(StateEvent event) {
                    switch ((EventTypes)((Object)event.encodeType(EventTypes.class))) {
                        case DISCONNECT_EVENT: {
                            this.setTimer(PeerFSMImpl.this.REC_TIMEOUT);
                            PeerFSMImpl.this.switchToNextState(FsmState.REOPEN);
                            break;
                        }
                        case TIMEOUT_EVENT: {
                            this.doDisconnect();
                            this.setTimer(PeerFSMImpl.this.REC_TIMEOUT);
                            PeerFSMImpl.this.switchToNextState(FsmState.REOPEN);
                            break;
                        }
                        case STOP_EVENT: {
                            this.clearTimer();
                            this.doDisconnect();
                            PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            break;
                        }
                        case CEA_EVENT: {
                            this.clearTimer();
                            if (PeerFSMImpl.this.context.processCeaMessage(((FsmEvent)event).getKey(), ((FsmEvent)event).getMessage())) {
                                PeerFSMImpl.this.switchToNextState(FsmState.OKAY);
                                break;
                            }
                            this.doDisconnect();
                            this.setTimer(PeerFSMImpl.this.REC_TIMEOUT);
                            PeerFSMImpl.this.switchToNextState(FsmState.REOPEN);
                            break;
                        }
                        case SEND_MSG_EVENT: {
                            throw new RuntimeException("Connection is down");
                        }
                        default: {
                            logger.debug("Unknown event type: {} in state {}", event.encodeType(EventTypes.class), (Object)PeerFSMImpl.this.state);
                            return false;
                        }
                    }
                    return true;
                }
            }, new MyState(){

                public boolean processEvent(StateEvent event) {
                    switch ((EventTypes)((Object)event.encodeType(EventTypes.class))) {
                        case TIMEOUT_EVENT: 
                        case DPA_EVENT: {
                            this.doDisconnect();
                            PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            break;
                        }
                        case RECEIVE_MSG_EVENT: {
                            PeerFSMImpl.this.context.receiveMessage(this.message(event));
                            break;
                        }
                        case SEND_MSG_EVENT: {
                            throw new RuntimeException("Stack now is stopping");
                        }
                        case DISCONNECT_EVENT: 
                        case STOP_EVENT: {
                            this.doDisconnect();
                            break;
                        }
                        default: {
                            logger.debug("Unknown event type: {} in state {}", event.encodeType(EventTypes.class), (Object)PeerFSMImpl.this.state);
                            return false;
                        }
                    }
                    return true;
                }
            }};
        }
        return this.states;
    }

    protected abstract class MyState
    implements State {
        protected MyState() {
        }

        public void entryAction() {
        }

        public void exitAction() {
        }

        protected void doEndConnection() {
            if (PeerFSMImpl.this.context.isRestoreConnection()) {
                PeerFSMImpl.this.timer = PeerFSMImpl.this.REC_TIMEOUT + System.currentTimeMillis();
                PeerFSMImpl.this.switchToNextState(FsmState.REOPEN);
            } else {
                PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
            }
        }

        protected void doDisconnect() {
            try {
                PeerFSMImpl.this.context.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        protected void setTimer(long value) {
            PeerFSMImpl.this.timer = value + System.currentTimeMillis();
        }

        protected String key(StateEvent event) {
            return ((FsmEvent)event).getKey();
        }

        protected IMessage message(StateEvent event) {
            return ((FsmEvent)event).getMessage();
        }

        protected EventTypes type(StateEvent event) {
            return (EventTypes)event.getType();
        }

        protected void clearTimer() {
            PeerFSMImpl.this.timer = 0L;
        }
    }
}

