/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.acc;

import java.io.Serializable;
import org.jdiameter.api.Answer;
import org.jdiameter.api.Avp;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.acc.ClientAccSession;
import org.jdiameter.api.acc.ClientAccSessionListener;
import org.jdiameter.api.acc.events.AccountAnswer;
import org.jdiameter.api.acc.events.AccountRequest;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.acc.Event;
import org.jdiameter.client.impl.app.acc.IClientAccSessionData;
import org.jdiameter.common.api.app.IAppSessionState;
import org.jdiameter.common.api.app.acc.ClientAccSessionState;
import org.jdiameter.common.api.app.acc.IClientAccActionContext;
import org.jdiameter.common.impl.app.AppEventImpl;
import org.jdiameter.common.impl.app.acc.AppAccSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAccSessionImpl
extends AppAccSessionImpl
implements EventListener<Request, Answer>,
ClientAccSession {
    private static final Logger logger = LoggerFactory.getLogger(ClientAccSessionImpl.class);
    public static final int DELIVER_AND_GRANT = 1;
    public static final int GRANT_AND_LOSE = 3;
    protected IClientAccActionContext context;
    protected ClientAccSessionListener listener;
    protected static final String TIMER_NAME_INTERIM = "CLIENT_INTERIM";
    protected IClientAccSessionData sessionData;

    public ClientAccSessionImpl(IClientAccSessionData sessionData, ISessionFactory sessionFactory, ClientAccSessionListener clientAccSessionListener, IClientAccActionContext iClientAccActionContext, StateChangeListener<AppSession> stateChangeListener) {
        super(sessionFactory, sessionData);
        this.sessionData = sessionData;
        this.listener = clientAccSessionListener;
        this.context = iClientAccActionContext;
        super.addStateChangeNotification(stateChangeListener);
    }

    public void sendAccountRequest(AccountRequest accountRequest) throws InternalException, IllegalStateException, RouteException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            this.handleEvent(new Event(accountRequest));
            try {
                this.session.send(accountRequest.getMessage(), (EventListener)this);
                this.sessionData.setDestinationRealm(accountRequest.getMessage().getAvps().getAvp(283).getDiameterIdentity());
                Avp destHostAvp = accountRequest.getMessage().getAvps().getAvp(293);
                if (destHostAvp != null) {
                    this.sessionData.setDestinationHost(destHostAvp.getDiameterIdentity());
                }
            }
            catch (Throwable t) {
                logger.debug("Failed to send ACR.", t);
                this.handleEvent(new Event(Event.Type.FAILED_SEND_RECORD, accountRequest));
            }
        }
        catch (Exception exc) {
            throw new InternalException((Throwable)exc);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    protected synchronized void storeToBuffer(Request accountRequest) {
        this.sessionData.setBuffer(accountRequest);
    }

    protected synchronized boolean checkBufferSpace() {
        return this.sessionData.getBuffer() == null;
    }

    protected void setState(IAppSessionState newState) {
        ClientAccSessionState oldState = this.sessionData.getClientAccSessionState();
        this.sessionData.setClientAccSessionState((ClientAccSessionState)newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)((Object)newState));
        }
    }

    public boolean isStateless() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        ClientAccSessionState oldState = this.sessionData.getClientAccSessionState();
        try {
            ClientAccSessionImpl accRtReq;
            block94: {
                block16 : switch (oldState) {
                    case IDLE: {
                        switch ((Event.Type)event.getType()) {
                            case SEND_START_RECORD: {
                                this.setState(ClientAccSessionState.PENDING_START);
                                break block16;
                            }
                            case SEND_EVENT_RECORD: {
                                this.setState(ClientAccSessionState.PENDING_EVENT);
                                break block16;
                            }
                        }
                        throw new IllegalStateException("Current state " + oldState + " action " + event.getType());
                    }
                    case PENDING_START: {
                        AccountAnswer answer;
                        Request str;
                        AccountRequest request;
                        switch ((Event.Type)event.getType()) {
                            case FAILED_SEND_RECORD: {
                                request = (AccountRequest)event.getData();
                                accRtReq = request.getMessage().getAvps().getAvp(483);
                                if (this.checkBufferSpace() && accRtReq != null && accRtReq.getInteger32() != 1) {
                                    this.storeToBuffer((Request)((AppEventImpl)request).getMessage());
                                    this.setState(ClientAccSessionState.OPEN);
                                    break;
                                }
                                if (!this.checkBufferSpace() && accRtReq != null && accRtReq.getInteger32() == 3) {
                                    this.setState(ClientAccSessionState.OPEN);
                                    break;
                                }
                                if (!this.checkBufferSpace() && accRtReq != null && accRtReq.getInteger32() != 3) {
                                    try {
                                        if (this.context == null) break block16;
                                        str = this.createSessionTermRequest();
                                        this.context.disconnectUserOrDev(this, str);
                                        this.session.send((Message)str, (EventListener)this);
                                        break block16;
                                    }
                                    finally {
                                        this.setState(ClientAccSessionState.IDLE);
                                    }
                                }
                                break block94;
                            }
                            case RECEIVED_RECORD: {
                                this.processInterimIntervalAvp(event);
                                this.setState(ClientAccSessionState.OPEN);
                                break;
                            }
                            case FAILED_RECEIVE_RECORD: {
                                try {
                                    answer = (AccountAnswer)event.getData();
                                    accRtReq = answer.getMessage().getAvps().getAvp(483);
                                    if (accRtReq != null && accRtReq.getInteger32() == 3) {
                                        this.setState(ClientAccSessionState.OPEN);
                                        break;
                                    }
                                    if (accRtReq == null || accRtReq.getInteger32() == 3) break block16;
                                    try {
                                        if (this.context == null) break block16;
                                        Request str2 = this.createSessionTermRequest();
                                        this.context.disconnectUserOrDev(this, str2);
                                        this.session.send((Message)str2, (EventListener)this);
                                        break block16;
                                    }
                                    finally {
                                        this.setState(ClientAccSessionState.IDLE);
                                    }
                                }
                                catch (Exception e) {
                                    logger.debug("Can not process answer", (Throwable)e);
                                    this.setState(ClientAccSessionState.IDLE);
                                    break;
                                }
                            }
                            case SEND_STOP_RECORD: {
                                if (this.context != null) {
                                    str = this.createSessionTermRequest();
                                    this.context.disconnectUserOrDev(this, str);
                                    this.storeToBuffer(str);
                                } else {
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case OPEN: {
                        switch ((Event.Type)event.getType()) {
                            case SEND_STOP_RECORD: {
                                this.setState(ClientAccSessionState.PENDING_CLOSE);
                                break;
                            }
                            case SEND_INTERIM_RECORD: {
                                this.setState(ClientAccSessionState.PENDING_INTERIM);
                                break;
                            }
                            case RECEIVED_RECORD: {
                                this.processInterimIntervalAvp(event);
                            }
                        }
                        break;
                    }
                    case PENDING_INTERIM: {
                        AccountAnswer answer;
                        Request str;
                        AccountRequest request;
                        switch ((Event.Type)event.getType()) {
                            case RECEIVED_RECORD: {
                                this.processInterimIntervalAvp(event);
                                this.setState(ClientAccSessionState.OPEN);
                                break;
                            }
                            case FAILED_SEND_RECORD: {
                                request = (AccountRequest)event.getData();
                                accRtReq = request.getMessage().getAvps().getAvp(483);
                                if (this.checkBufferSpace() && accRtReq != null && accRtReq.getInteger32() != 1) {
                                    this.storeToBuffer((Request)((AppEventImpl)request).getMessage());
                                    this.setState(ClientAccSessionState.OPEN);
                                    break;
                                }
                                if (!this.checkBufferSpace() && accRtReq != null && accRtReq.getInteger32() == 3) {
                                    this.setState(ClientAccSessionState.OPEN);
                                    break;
                                }
                                if (!this.checkBufferSpace() && accRtReq != null && accRtReq.getInteger32() != 3) {
                                    try {
                                        if (this.context == null) break block16;
                                        str = this.createSessionTermRequest();
                                        this.context.disconnectUserOrDev(this, str);
                                        this.session.send((Message)str, (EventListener)this);
                                        break block16;
                                    }
                                    finally {
                                        this.setState(ClientAccSessionState.IDLE);
                                    }
                                }
                                break block94;
                            }
                            case FAILED_RECEIVE_RECORD: {
                                try {
                                    answer = (AccountAnswer)event.getData();
                                    accRtReq = answer.getMessage().getAvps().getAvp(483);
                                    if (accRtReq != null && accRtReq.getInteger32() == 3) {
                                        this.setState(ClientAccSessionState.OPEN);
                                        break;
                                    }
                                    if (accRtReq == null || accRtReq.getInteger32() == 3) break block16;
                                    try {
                                        if (this.context == null) break block16;
                                        Request str3 = this.createSessionTermRequest();
                                        this.context.disconnectUserOrDev(this, str3);
                                        this.session.send((Message)str3, (EventListener)this);
                                        break block16;
                                    }
                                    finally {
                                        this.setState(ClientAccSessionState.IDLE);
                                    }
                                }
                                catch (Exception e) {
                                    logger.debug("Can not process received request", (Throwable)e);
                                    this.setState(ClientAccSessionState.IDLE);
                                    break;
                                }
                            }
                            case SEND_STOP_RECORD: {
                                if (this.context != null) {
                                    str = this.createSessionTermRequest();
                                    this.context.disconnectUserOrDev(this, str);
                                    this.storeToBuffer(str);
                                } else {
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case PENDING_EVENT: {
                        ClientAccSessionImpl data;
                        switch ((Event.Type)event.getType()) {
                            case RECEIVED_RECORD: {
                                this.setState(ClientAccSessionState.IDLE);
                                break;
                            }
                            case FAILED_SEND_RECORD: {
                                if (this.checkBufferSpace()) {
                                    data = (AccountRequest)event.getData();
                                    this.storeToBuffer((Request)((AppEventImpl)((Object)data)).getMessage());
                                }
                                this.setState(ClientAccSessionState.IDLE);
                                break;
                            }
                            case FAILED_RECEIVE_RECORD: {
                                this.setState(ClientAccSessionState.IDLE);
                            }
                        }
                        break;
                    }
                    case PENDING_BUFFERED: {
                        ClientAccSessionImpl data;
                        switch ((Event.Type)event.getType()) {
                            case RECEIVED_RECORD: {
                                data = this;
                                synchronized (data) {
                                    this.storeToBuffer(null);
                                }
                                this.setState(ClientAccSessionState.IDLE);
                                break;
                            }
                            case FAILED_SEND_RECORD: {
                                this.setState(ClientAccSessionState.IDLE);
                                break;
                            }
                            case FAILED_RECEIVE_RECORD: {
                                data = this;
                                synchronized (data) {
                                    this.storeToBuffer(null);
                                }
                                this.setState(ClientAccSessionState.IDLE);
                            }
                        }
                        break;
                    }
                    case PENDING_CLOSE: {
                        ClientAccSessionImpl data;
                        switch ((Event.Type)event.getType()) {
                            case RECEIVED_RECORD: {
                                this.setState(ClientAccSessionState.IDLE);
                                break block16;
                            }
                            case FAILED_SEND_RECORD: {
                                if (this.checkBufferSpace()) {
                                    data = (AccountRequest)event.getData();
                                    this.storeToBuffer((Request)((AppEventImpl)((Object)data)).getMessage());
                                }
                                this.setState(ClientAccSessionState.IDLE);
                                break block16;
                            }
                            case FAILED_RECEIVE_RECORD: {
                                this.setState(ClientAccSessionState.IDLE);
                            }
                        }
                    }
                }
            }
            ClientAccSessionState state = this.sessionData.getClientAccSessionState();
            if (oldState == state) return true;
            switch (state) {
                case IDLE: {
                    try {
                        accRtReq = this;
                        synchronized (accRtReq) {
                            if (this.checkBufferSpace()) return true;
                            this.session.send((Message)this.sessionData.getBuffer(), (EventListener)this);
                            this.setState(ClientAccSessionState.PENDING_BUFFERED);
                            return true;
                        }
                    }
                    catch (Exception e) {
                        logger.debug("can not send buffered message", (Throwable)e);
                        ClientAccSessionImpl clientAccSessionImpl = this;
                        synchronized (clientAccSessionImpl) {
                            if (this.context == null || this.checkBufferSpace() || this.context.failedSendRecord(this, this.sessionData.getBuffer())) return true;
                            this.storeToBuffer(null);
                            return true;
                        }
                    }
                }
            }
            return true;
        }
        catch (Throwable t) {
            throw new InternalException(t);
        }
    }

    protected void processInterimIntervalAvp(StateEvent event) throws InternalException {
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals("IDLE_SESSION_TIMER")) {
            this.checkIdleAppSession();
        } else if (timerName.equals(TIMER_NAME_INTERIM)) {
            if (this.context != null) {
                try {
                    Request interimRecord = this.createInterimRecord();
                    this.context.interimIntervalElapses(this, interimRecord);
                    this.sendAndStateLock.lock();
                    this.session.send((Message)interimRecord, (EventListener)this);
                    this.setState(ClientAccSessionState.PENDING_INTERIM);
                    this.sessionData.setInterimTimerId(null);
                }
                catch (Exception e) {
                    logger.debug("Can not process Interim Interval AVP", (Throwable)e);
                }
                finally {
                    this.sendAndStateLock.unlock();
                }
            }
        } else {
            logger.warn("Received an unknown timer '{}' for Session-ID '{}'", (Object)timerName, (Object)this.getSessionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable startInterimTimer(long v) {
        try {
            this.sendAndStateLock.lock();
            Serializable interimTimerId = this.timerFacility.schedule(this.sessionData.getSessionId(), TIMER_NAME_INTERIM, v);
            this.sessionData.setInterimTimerId(interimTimerId);
            Serializable serializable = interimTimerId;
            return serializable;
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    private void cancelInterimTimer() {
        try {
            this.sendAndStateLock.lock();
            Serializable interimTimerId = this.sessionData.getInterimTimerId();
            if (interimTimerId != null) {
                this.timerFacility.cancel(interimTimerId);
                this.sessionData.setInterimTimerId(null);
            }
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public <E> E getState(Class<E> eClass) {
        return (E)(eClass == ClientAccSessionState.class ? this.sessionData.getClientAccSessionState() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedSuccessMessage(Request request, Answer answer) {
        if (request.getCommandCode() == 271) {
            try {
                this.sendAndStateLock.lock();
                this.handleEvent(new Event(this.createAccountAnswer(answer)));
            }
            catch (Exception e) {
                logger.debug("Can not process received request", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
            try {
                this.listener.doAccAnswerEvent((ClientAccSession)this, this.createAccountRequest(request), this.createAccountAnswer(answer));
            }
            catch (Exception e) {
                logger.debug("Unable to deliver message to listener.", (Throwable)e);
            }
        } else {
            try {
                this.listener.doOtherEvent((AppSession)this, (AppRequestEvent)this.createAccountRequest(request), (AppAnswerEvent)this.createAccountAnswer(answer));
            }
            catch (Exception e) {
                logger.debug("Can not process received request", (Throwable)e);
            }
        }
    }

    public void timeoutExpired(Request request) {
        try {
            this.sendAndStateLock.lock();
            this.handleEvent(new Event(Event.Type.FAILED_SEND_RECORD, this.createAccountRequest(request)));
        }
        catch (Exception e) {
            logger.debug("Can not handle timeout event", (Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public Answer processRequest(Request request) {
        Answer a = request.createAnswer(5001L);
        return a;
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    protected Request createInterimRecord() {
        Request interimRecord = this.session.createRequest(271, this.sessionData.getApplicationId(), this.sessionData.getDestinationRealm(), this.sessionData.getDestinationHost());
        interimRecord.getAvps().addAvp(480, 3);
        return interimRecord;
    }

    protected Request createSessionTermRequest() {
        return this.session.createRequest(275, this.sessionData.getApplicationId(), this.sessionData.getDestinationRealm(), this.sessionData.getDestinationHost());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientAccSessionImpl other = (ClientAccSessionImpl)obj;
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }

    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
            }
            catch (Exception e) {
                logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }
}

