/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.annotation;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.MetaData;
import org.jdiameter.api.Request;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.annotation.AvpDscr;
import org.jdiameter.api.annotation.AvpFlag;
import org.jdiameter.api.annotation.AvpType;
import org.jdiameter.api.annotation.Child;
import org.jdiameter.api.annotation.CommandDscr;
import org.jdiameter.api.annotation.CommandFlag;
import org.jdiameter.api.annotation.Getter;
import org.jdiameter.api.annotation.Setter;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.annotation.IRecoder;
import org.jdiameter.client.api.annotation.RecoderException;
import org.jdiameter.client.impl.RawSessionImpl;
import org.jdiameter.client.impl.annotation.UnknownAvp;
import org.jdiameter.client.impl.annotation.internal.ClassInfo;
import org.jdiameter.client.impl.annotation.internal.ConstructorInfo;
import org.jdiameter.client.impl.annotation.internal.MethodInfo;
import org.jdiameter.client.impl.annotation.internal.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recoder
implements IRecoder {
    private static final Logger log = LoggerFactory.getLogger(Recoder.class);
    private Storage storage = new Storage();
    private final RawSessionImpl rawSession;
    private final MetaData metaData;

    public Recoder(SessionFactory factory, MetaData metaData) {
        this.metaData = metaData;
        try {
            this.rawSession = (RawSessionImpl)factory.getNewRawSession();
        }
        catch (InternalException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Message encodeToRequest(Object yourDomainMessageObject, Avp ... additionalAvp) throws RecoderException {
        return this.encode(yourDomainMessageObject, null, 0L, additionalAvp);
    }

    @Override
    public Message encodeToAnswer(Object yourDomainMessageObject, Request request, long resultCode) throws RecoderException {
        return this.encode(yourDomainMessageObject, request, resultCode, new Avp[0]);
    }

    public Message encode(Object yourDomainMessageObject, Request request, long resultCode, Avp ... addAvp) throws RecoderException {
        IMessage message = null;
        ClassInfo classInfo = this.storage.getClassInfo(yourDomainMessageObject.getClass());
        CommandDscr commandDscr = (CommandDscr)classInfo.getAnnotation(CommandDscr.class);
        if (commandDscr != null) {
            if (request == null) {
                message = (IMessage)this.rawSession.createMessage(commandDscr.code(), ApplicationId.createByAccAppId((long)0L), new Avp[0]);
                message.setRequest(true);
                message.getAvps().addAvp(addAvp);
                try {
                    if (message.getAvps().getAvp(258) != null) {
                        message.setHeaderApplicationId(message.getAvps().getAvp(258).getUnsigned32());
                    } else if (message.getAvps().getAvp(259) != null) {
                        message.setHeaderApplicationId(message.getAvps().getAvp(259).getUnsigned32());
                    } else if (message.getAvps().getAvp(260) != null) {
                        message.setHeaderApplicationId(message.getAvps().getAvp(260).getGrouped().getAvp(266).getUnsigned32());
                    }
                }
                catch (Exception exc) {
                    throw new RecoderException(exc);
                }
                if (message.getAvps().getAvp(264) == null) {
                    message.getAvps().addAvp(264, this.metaData.getLocalPeer().getUri().getFQDN(), true, false, true);
                }
                if (message.getAvps().getAvp(296) == null) {
                    message.getAvps().addAvp(296, this.metaData.getLocalPeer().getRealmName(), true, false, true);
                }
            } else {
                message = (IMessage)request.createAnswer(resultCode);
            }
            block8: for (CommandFlag f : commandDscr.flags()) {
                switch (f) {
                    case E: {
                        message.setError(true);
                        continue block8;
                    }
                    case P: {
                        message.setProxiable(true);
                        continue block8;
                    }
                    case R: {
                        message.setRequest(true);
                        continue block8;
                    }
                    case T: {
                        message.setReTransmitted(true);
                    }
                }
            }
            Map<String, Object> chMap = this.getChildInstance(yourDomainMessageObject, classInfo, null);
            for (Child ch : commandDscr.childs()) {
                this.fillChild(message.getAvps(), ch, chMap);
            }
        } else {
            log.debug("Can not found annotation for object {}", yourDomainMessageObject);
        }
        return message;
    }

    private Map<String, Object> getChildInstance(Object yourDomainMessageObject, ClassInfo c, Map<String, Object> chMap) throws RecoderException {
        if (chMap == null) {
            chMap = new HashMap<String, Object>();
        }
        for (MethodInfo mi : c.getMethodsInfo()) {
            if (mi.getAnnotation(Getter.class) == null) continue;
            try {
                Object value = mi.getMethod().invoke(yourDomainMessageObject, new Object[0]);
                if (value == null) continue;
                Class<?> mc = value.getClass().isArray() ? value.getClass().getComponentType() : value.getClass();
                chMap.put(mc.getName(), value);
                for (Class<?> i : mc.getInterfaces()) {
                    chMap.put(i.getName(), value);
                }
            }
            catch (IllegalAccessException e) {
                throw new RecoderException(e);
            }
            catch (InvocationTargetException e) {
                throw new RecoderException(e);
            }
        }
        return chMap;
    }

    private void fillChild(AvpSet as, Child ci, Map<String, Object> childs) throws RecoderException {
        ClassInfo cc;
        AvpDscr ad;
        Object c = childs.get(ci.ref().getName());
        if (c != null && (ad = (AvpDscr)(cc = this.storage.getClassInfo(ci.ref())).getAnnotation(AvpDscr.class)) != null) {
            boolean m = false;
            boolean p = false;
            switch (ad.type()) {
                case Integer32: 
                case Enumerated: {
                    for (AvpFlag f : ad.must()) {
                        if (AvpFlag.M.equals((Object)f)) {
                            m = true;
                            continue;
                        }
                        if (!AvpFlag.P.equals((Object)f)) continue;
                        p = true;
                    }
                    Collection<Integer> cv = this.getValue(c, Integer.class);
                    for (Integer v : cv) {
                        as.addAvp(ad.code(), v.intValue(), ad.vendorId(), m, p);
                    }
                    break;
                }
                case Unsigned32: {
                    for (AvpFlag f : ad.must()) {
                        if (AvpFlag.M.equals((Object)f)) {
                            m = true;
                            continue;
                        }
                        if (!AvpFlag.P.equals((Object)f)) continue;
                        p = true;
                    }
                    Collection<Long> cv = this.getValue(c, Long.class);
                    Iterator iterator = cv.iterator();
                    while (iterator.hasNext()) {
                        Long v = (Long)iterator.next();
                        as.addAvp(ad.code(), v.longValue(), ad.vendorId(), m, p, true);
                    }
                    break;
                }
                case Unsigned64: 
                case Integer64: {
                    for (AvpFlag f : ad.must()) {
                        if (AvpFlag.M.equals((Object)f)) {
                            m = true;
                            continue;
                        }
                        if (!AvpFlag.P.equals((Object)f)) continue;
                        p = true;
                    }
                    Collection<Long> cv = this.getValue(c, Long.class);
                    Iterator iterator = cv.iterator();
                    while (iterator.hasNext()) {
                        Long v = (Long)iterator.next();
                        as.addAvp(ad.code(), v.longValue(), ad.vendorId(), m, p);
                    }
                    break;
                }
                case Float32: {
                    for (AvpFlag f : ad.must()) {
                        if (AvpFlag.M.equals((Object)f)) {
                            m = true;
                            continue;
                        }
                        if (!AvpFlag.P.equals((Object)f)) continue;
                        p = true;
                    }
                    Collection<Float> cv = this.getValue(c, Float.class);
                    Iterator iterator = cv.iterator();
                    while (iterator.hasNext()) {
                        Float v = (Float)iterator.next();
                        as.addAvp(ad.code(), v.floatValue(), ad.vendorId(), m, p);
                    }
                    break;
                }
                case Float64: {
                    for (AvpFlag f : ad.must()) {
                        if (AvpFlag.M.equals((Object)f)) {
                            m = true;
                            continue;
                        }
                        if (!AvpFlag.P.equals((Object)f)) continue;
                        p = true;
                    }
                    Collection<Double> cv = this.getValue(c, Double.class);
                    Iterator iterator = cv.iterator();
                    while (iterator.hasNext()) {
                        Double v = (Double)iterator.next();
                        as.addAvp(ad.code(), v.doubleValue(), ad.vendorId(), m, p);
                    }
                    break;
                }
                case OctetString: 
                case Address: 
                case Time: 
                case DiameterIdentity: 
                case DiameterURI: 
                case IPFilterRule: 
                case QoSFilterRule: {
                    for (AvpFlag f : ad.must()) {
                        if (AvpFlag.M.equals((Object)f)) {
                            m = true;
                            continue;
                        }
                        if (!AvpFlag.P.equals((Object)f)) continue;
                        p = true;
                    }
                    Collection<String> cv = this.getValue(c, String.class);
                    Iterator iterator = cv.iterator();
                    while (iterator.hasNext()) {
                        String v = (String)iterator.next();
                        as.addAvp(ad.code(), v, ad.vendorId(), m, p, true);
                    }
                    break;
                }
                case UTF8String: {
                    for (AvpFlag f : ad.must()) {
                        if (AvpFlag.M.equals((Object)f)) {
                            m = true;
                            continue;
                        }
                        if (!AvpFlag.P.equals((Object)f)) continue;
                        p = true;
                    }
                    Collection<String> cv = this.getValue(c, String.class);
                    Iterator iterator = cv.iterator();
                    while (iterator.hasNext()) {
                        String v = (String)iterator.next();
                        as.addAvp(ad.code(), v, ad.vendorId(), m, p, false);
                    }
                    break;
                }
                case Grouped: {
                    for (AvpFlag f : ad.must()) {
                        if (AvpFlag.M.equals((Object)f)) {
                            m = true;
                            continue;
                        }
                        if (!AvpFlag.P.equals((Object)f)) continue;
                        p = true;
                    }
                    Object cv = new ArrayList();
                    if (c.getClass().isArray()) {
                        cv = Arrays.asList((Object[])c);
                    } else {
                        cv.add(c);
                    }
                    Iterator iterator = cv.iterator();
                    while (iterator.hasNext()) {
                        Object cj = iterator.next();
                        AvpSet las = as.addGroupedAvp(ad.code(), ad.vendorId(), m, p);
                        Map<String, Object> lchilds = this.getChildInstance(cj, this.storage.getClassInfo(cj.getClass()), null);
                        for (Child lci : ad.childs()) {
                            this.fillChild(las, lci, lchilds);
                        }
                    }
                    break;
                }
            }
        }
    }

    private <T> Collection<T> getValue(Object ic, Class<T> type) throws RecoderException {
        ArrayList<Object> rc = new ArrayList<Object>();
        Object[] xc = null;
        xc = ic.getClass().isArray() ? (Object[])ic : new Object[]{ic};
        for (Object c : xc) {
            for (MethodInfo lm : this.storage.getClassInfo(c.getClass()).getMethodsInfo()) {
                if (lm.getAnnotation(Getter.class) == null) continue;
                try {
                    rc.add(lm.getMethod().invoke(c, new Object[0]));
                }
                catch (IllegalAccessException e) {
                    throw new RecoderException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RecoderException(e);
                }
            }
        }
        return rc;
    }

    @Override
    public <T> T decode(Message message, Class<T> yourDomainMessageObject) throws RecoderException {
        T rc = null;
        ClassInfo c = this.storage.getClassInfo(yourDomainMessageObject);
        CommandDscr cd = (CommandDscr)c.getAnnotation(CommandDscr.class);
        if (cd != null) {
            try {
                if (message.getCommandCode() != cd.code()) {
                    throw new IllegalArgumentException("Invalid message code " + message.getCommandCode());
                }
                if (message.getApplicationId() != 0L && message.getApplicationId() != cd.appId()) {
                    throw new IllegalArgumentException("Invalid Application-Id " + message.getApplicationId());
                }
                block10: for (CommandFlag f : cd.flags()) {
                    switch (f) {
                        case E: {
                            if (message.isError()) continue block10;
                            throw new IllegalArgumentException("Flag e is not set");
                        }
                        case P: {
                            if (message.isProxiable()) continue block10;
                            throw new IllegalArgumentException("Flag p is not set");
                        }
                        case R: {
                            if (message.isRequest()) continue block10;
                            throw new IllegalArgumentException("Flag m is not set");
                        }
                        case T: {
                            if (message.isReTransmitted()) continue block10;
                            throw new IllegalArgumentException("Flag t is not set");
                        }
                    }
                }
                int cacount = 0;
                Constructor cm = null;
                HashMap cmargs = new HashMap();
                for (ConstructorInfo ci : c.getConstructorsInfo()) {
                    if (ci.getAnnotation(Setter.class) == null) continue;
                    Class<?>[] params = ci.getConstructor().getParameterTypes();
                    int correct = 1;
                    for (Class<?> j : params) {
                        if (j.isArray()) {
                            j = j.getComponentType();
                        }
                        if (this.storage.getClassInfo(j).getAnnotation(AvpDscr.class) != null) continue;
                        correct = 0;
                        break;
                    }
                    if (correct == 0 || cacount >= params.length) continue;
                    cacount = params.length;
                    cm = ci.getConstructor();
                }
                ArrayList<Object> initargs = new ArrayList<Object>();
                if (cm != null) {
                    for (Class<?> ac : cm.getParameterTypes()) {
                        Class<?> lac = ac.isArray() ? ac.getComponentType() : ac;
                        cmargs.put(lac.getName(), ac);
                        initargs.add(this.createChildByAvp(this.findChildDscr(cd.childs(), ac), ac, message.getAvps()));
                    }
                    rc = cm.newInstance(initargs.toArray());
                } else {
                    rc = yourDomainMessageObject.newInstance();
                }
                for (MethodInfo mi : c.getMethodsInfo()) {
                    Class<?> ptc;
                    Class<?>[] pt;
                    if (mi.getAnnotation(Setter.class) == null || (pt = mi.getMethod().getParameterTypes()).length != 1 || this.storage.getClassInfo(pt[0]).getAnnotation(AvpDscr.class) == null || cmargs.containsKey((ptc = pt[0].isArray() ? pt[0].getComponentType() : pt[0]).getName())) continue;
                    cmargs.put(ptc.getName(), ptc);
                    mi.getMethod().invoke(rc, this.createChildByAvp(this.findChildDscr(cd.childs(), pt[0]), pt[0], message.getAvps()));
                }
                this.setUndefinedAvp(message.getAvps(), rc, c, cmargs);
            }
            catch (InstantiationException e) {
                throw new RecoderException(e);
            }
            catch (InvocationTargetException e) {
                throw new RecoderException(e);
            }
            catch (IllegalAccessException e) {
                throw new RecoderException(e);
            }
        }
        return rc;
    }

    private void setUndefinedAvp(AvpSet set, Object rc, ClassInfo c, Map<String, Class<?>> cmargs) throws RecoderException {
        try {
            for (MethodInfo mi : c.getMethodsInfo()) {
                Setter s = (Setter)mi.getAnnotation(Setter.class);
                if (s == null || !Setter.Type.UNDEFINED.equals((Object)s.value())) continue;
                HashMap<Integer, Integer> known = new HashMap<Integer, Integer>();
                for (Class<?> argc : cmargs.values()) {
                    AvpDscr argd = (AvpDscr)this.storage.getClassInfo(argc.isArray() ? argc.getComponentType() : argc).getAnnotation(AvpDscr.class);
                    known.put(argd.code(), argd.code());
                }
                for (Avp a : set) {
                    if (known.containsKey(a.getCode())) continue;
                    mi.getMethod().invoke(rc, new UnknownAvp(a.getCode(), a.isMandatory(), a.isVendorId(), a.isEncrypted(), a.getVendorId(), a.getRaw()));
                }
                break;
            }
        }
        catch (IllegalAccessException e) {
            throw new RecoderException(e);
        }
        catch (InvocationTargetException e) {
            throw new RecoderException(e);
        }
        catch (AvpDataException e) {
            throw new RecoderException(e);
        }
    }

    private Child findChildDscr(Child[] childs, Class<?> m) {
        for (Child c : childs) {
            Class t = c.ref();
            Class<?> clazz = m = m.isArray() ? m.getComponentType() : m;
            if (m == t) {
                return c;
            }
            if (m.getSuperclass() == t) {
                return c;
            }
            for (Class<?> i : m.getInterfaces()) {
                if (i != t) continue;
                return c;
            }
        }
        return null;
    }

    private Object createChildByAvp(Child mInfo, Class<?> m, AvpSet parentSet) throws RecoderException {
        Object[] rc;
        Class<?> arrayClass;
        AvpDscr ad = (AvpDscr)this.storage.getClassInfo(m.isArray() ? m.getComponentType() : m).getAnnotation(AvpDscr.class);
        Avp av = parentSet.getAvp(ad.code());
        if (av != null) {
            block5: for (AvpFlag i : ad.must()) {
                switch (i) {
                    case M: {
                        if (av.isMandatory()) continue block5;
                        throw new IllegalArgumentException("not set flag M");
                    }
                    case V: {
                        if (av.isVendorId()) continue block5;
                        throw new IllegalArgumentException("not set flag V");
                    }
                    case P: {
                        if (av.isEncrypted()) continue block5;
                        throw new IllegalArgumentException("not set flag P");
                    }
                }
            }
        } else if (mInfo.min() > 0) {
            throw new IllegalArgumentException("Avp " + ad.code() + " is mandatory");
        }
        if (AvpType.Grouped.equals((Object)ad.type())) {
            if (m.isArray()) {
                arrayClass = m.getComponentType();
                AvpSet as = parentSet.getAvps(ad.code());
                Object[] array = (Object[])Array.newInstance(arrayClass, as.size());
                for (int ii = 0; ii < array.length; ++ii) {
                    array[ii] = this.newInstanceGroupedAvp(arrayClass, ad, as.getAvpByIndex(ii));
                }
                rc = array;
            } else {
                rc = this.newInstanceGroupedAvp(m, ad, parentSet.getAvp(ad.code()));
            }
        } else if (m.isArray()) {
            arrayClass = m.getComponentType();
            AvpSet as = parentSet.getAvps(ad.code());
            Object[] array = (Object[])Array.newInstance(arrayClass, as.size());
            for (int ii = 0; ii < array.length; ++ii) {
                array[ii] = this.newInstanceSimpleAvp(arrayClass, ad, as.getAvpByIndex(ii));
            }
            rc = array;
        } else {
            rc = this.newInstanceSimpleAvp(m, ad, parentSet.getAvp(ad.code()));
        }
        return rc;
    }

    private Object newInstanceGroupedAvp(Class<?> m, AvpDscr ad, Avp avp) throws RecoderException {
        Object rc;
        int cacount = 0;
        ClassInfo c = this.storage.getClassInfo(m);
        Constructor cm = null;
        HashMap cmargs = new HashMap();
        for (ConstructorInfo ci : c.getConstructorsInfo()) {
            if (ci.getAnnotation(Setter.class) == null) continue;
            Class<?>[] params = ci.getConstructor().getParameterTypes();
            int correct = 1;
            for (Class<?> j : params) {
                if (j.isArray()) {
                    j = j.getComponentType();
                }
                if (this.storage.getClassInfo(j).getAnnotation(AvpDscr.class) != null) continue;
                correct = 0;
                break;
            }
            if (correct == 0 || cacount >= params.length) continue;
            cacount = params.length;
            cm = ci.getConstructor();
        }
        try {
            ArrayList<Object> initargs = new ArrayList<Object>();
            if (cm != null) {
                for (Class<?> ac : cm.getParameterTypes()) {
                    Class<?> lac = ac.isArray() ? ac.getComponentType() : ac;
                    cmargs.put(lac.getName(), ac);
                    initargs.add(this.createChildByAvp(this.findChildDscr(ad.childs(), ac), ac, avp.getGrouped()));
                }
                rc = cm.newInstance(initargs.toArray());
            } else {
                rc = m.newInstance();
            }
            for (MethodInfo mi : c.getMethodsInfo()) {
                Class<?> ptc;
                Class<?>[] pt;
                if (mi.getAnnotation(Setter.class) == null || (pt = mi.getMethod().getParameterTypes()).length != 1 || this.storage.getClassInfo(pt[0]).getAnnotation(AvpDscr.class) == null || cmargs.containsKey((ptc = pt[0].isArray() ? pt[0].getComponentType() : pt[0]).getName())) continue;
                cmargs.put(ptc.getName(), ptc);
                mi.getMethod().invoke(rc, this.createChildByAvp(this.findChildDscr(ad.childs(), pt[0]), pt[0], avp.getGrouped()));
            }
            this.setUndefinedAvp(avp.getGrouped(), rc, c, cmargs);
        }
        catch (InstantiationException e) {
            throw new RecoderException(e);
        }
        catch (InvocationTargetException e) {
            throw new RecoderException(e);
        }
        catch (AvpDataException e) {
            throw new RecoderException(e);
        }
        catch (IllegalAccessException e) {
            throw new RecoderException(e);
        }
        return rc;
    }

    private Object newInstanceSimpleAvp(Class<?> m, AvpDscr ad, Avp avp) {
        Object rc = null;
        if (avp == null) {
            return null;
        }
        ClassInfo c = this.storage.getClassInfo(m);
        try {
            ArrayList<Object> args;
            for (ConstructorInfo ci : c.getConstructorsInfo()) {
                if (ci.getConstructor().getParameterTypes().length != 1 || ci.getAnnotation(Setter.class) == null) continue;
                args = new ArrayList<Object>();
                if (ci.getConstructor().getParameterTypes()[0].isArray()) {
                    args.add(this.getValue(ad.type(), avp));
                } else {
                    args.add(this.getValue(ad.type(), avp));
                }
                rc = ci.getConstructor().newInstance(args.toArray());
            }
            if (rc == null) {
                rc = m.newInstance();
                for (MethodInfo mi : c.getMethodsInfo()) {
                    if (mi.getAnnotation(Setter.class) == null) continue;
                    args = new ArrayList();
                    if (mi.getMethod().getParameterTypes()[0].isArray()) {
                        args.add(this.getValue(ad.type(), avp));
                    } else {
                        args.add(this.getValue(ad.type(), avp));
                    }
                    mi.getMethod().invoke(rc, args);
                }
            }
        }
        catch (InstantiationException e) {
            throw new RecoderException(e);
        }
        catch (InvocationTargetException e) {
            throw new RecoderException(e);
        }
        catch (AvpDataException e) {
            throw new RecoderException(e);
        }
        catch (IllegalAccessException e) {
            throw new RecoderException(e);
        }
        return rc;
    }

    private Object getValue(AvpType type, Avp avp) throws AvpDataException {
        switch (type) {
            case Integer32: 
            case Enumerated: {
                return avp.getInteger32();
            }
            case Unsigned32: {
                return avp.getUnsigned32();
            }
            case Unsigned64: 
            case Integer64: {
                return avp.getInteger64();
            }
            case Float32: {
                return Float.valueOf(avp.getFloat32());
            }
            case Float64: {
                return avp.getFloat64();
            }
            case OctetString: 
            case Address: 
            case Time: 
            case DiameterIdentity: 
            case DiameterURI: 
            case IPFilterRule: 
            case QoSFilterRule: {
                return avp.getOctetString();
            }
            case UTF8String: {
                return avp.getUTF8String();
            }
        }
        return null;
    }
}

