/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.RawSession;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.IRequest;
import org.jdiameter.client.api.ISession;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.BaseSessionImpl;
import org.jdiameter.client.impl.MessageUtility;
import org.jdiameter.client.impl.RawSessionImpl;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.api.timer.ITimerFacility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionImpl
extends BaseSessionImpl
implements ISession {
    private static final Logger logger = LoggerFactory.getLogger(SessionImpl.class);
    private Semaphore lock = new Semaphore(1);

    SessionImpl(IContainer container) {
        this.setContainer(container);
        try {
            this.sessionId = container.getSessionFactory().getSessionId();
        }
        catch (IllegalDiameterStateException idse) {
            throw new IllegalStateException("Unable to generate Session-Id", idse);
        }
    }

    void setContainer(IContainer container) {
        try {
            this.lock.acquire();
            this.container = container;
            this.parser = container.getAssemblerFacility().getComponentInstance(IMessageParser.class);
        }
        catch (InterruptedException e) {
            logger.error("failure getting lock", (Throwable)e);
        }
        finally {
            this.lock.release();
        }
    }

    public void send(Message message, EventListener<Request, Answer> listener) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.genericSend(message, listener);
    }

    public void send(Message message, EventListener<Request, Answer> listener, long timeout, TimeUnit timeUnit) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.genericSend(message, listener, timeout, timeUnit);
    }

    public void setRequestListener(NetworkReqListener listener) {
        if (listener != null) {
            this.reqListener = listener;
            this.container.addSessionListener(this.sessionId, listener);
        }
    }

    @Override
    public NetworkReqListener getReqListener() {
        return this.reqListener;
    }

    public Request createRequest(int commandCode, ApplicationId appId, String destRealm) {
        if (this.isValid) {
            this.setLastAccessTime();
            IRequest m = (IRequest)this.parser.createEmptyMessage(IRequest.class, commandCode, this.getAppId(appId));
            m.setNetworkRequest(false);
            m.setRequest(true);
            m.getAvps().addAvp(263, this.sessionId, true, false, false);
            this.appendAppId(appId, (Message)m);
            if (destRealm != null) {
                m.getAvps().addAvp(283, destRealm, true, false, true);
            }
            MessageUtility.addOriginAvps((Message)m, this.container.getMetaData());
            return m;
        }
        throw new IllegalStateException("Session already released");
    }

    public Request createRequest(int commandCode, ApplicationId appId, String destRealm, String destHost) {
        if (this.isValid) {
            this.setLastAccessTime();
            IRequest m = (IRequest)this.parser.createEmptyMessage(IRequest.class, commandCode, this.getAppId(appId));
            m.setNetworkRequest(false);
            m.setRequest(true);
            m.getAvps().addAvp(263, this.sessionId, true, false, false);
            this.appendAppId(appId, (Message)m);
            if (destRealm != null) {
                m.getAvps().addAvp(283, destRealm, true, false, true);
            }
            if (destHost != null) {
                m.getAvps().addAvp(293, destHost, true, false, true);
            }
            MessageUtility.addOriginAvps((Message)m, this.container.getMetaData());
            return m;
        }
        throw new IllegalStateException("Session already released");
    }

    public Request createRequest(Request prevRequest) {
        if (this.isValid) {
            this.setLastAccessTime();
            IRequest request = (IRequest)this.parser.createEmptyMessage(Request.class, (IMessage)prevRequest);
            request.setRequest(true);
            request.setNetworkRequest(false);
            MessageUtility.addOriginAvps((Message)request, this.container.getMetaData());
            return request;
        }
        throw new IllegalStateException("Session already released");
    }

    public void release() {
        this.isValid = false;
        try {
            this.lock.acquire();
            if (this.container != null) {
                if (this.istTimerId != null) {
                    this.container.getAssemblerFacility().getComponentInstance(ITimerFacility.class).cancel(this.istTimerId);
                }
                this.container.removeSessionListener(this.sessionId);
                this.container.getAssemblerFacility().getComponentInstance(ISessionDatasource.class).removeSession(this.sessionId);
            }
            this.container = null;
            this.parser = null;
            this.reqListener = null;
        }
        catch (InterruptedException e) {
            logger.error("failure getting lock", (Throwable)e);
        }
        finally {
            this.lock.release();
        }
    }

    public boolean isWrapperFor(Class<?> iface) throws InternalException {
        return iface == RawSession.class;
    }

    public <T> T unwrap(Class<T> iface) throws InternalException {
        return (T)(iface == RawSession.class ? new RawSessionImpl(this.container) : null);
    }
}

