/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerState;
import org.jdiameter.api.PeerStateListener;
import org.jdiameter.api.StackType;
import org.jdiameter.api.URI;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.IMetaData;
import org.jdiameter.client.api.controller.IPeer;
import org.jdiameter.client.api.fsm.EventTypes;
import org.jdiameter.client.api.io.IConnectionListener;
import org.jdiameter.client.api.io.TransportException;
import org.jdiameter.client.impl.helpers.IPConverter;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.jdiameter.common.impl.controller.AbstractPeer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataImpl
implements IMetaData {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataImpl.class);
    protected List<MemoryPoolMXBean> beans = ManagementFactory.getMemoryPoolMXBeans();
    protected IContainer stack;
    protected long state;
    protected IPeer peer;
    protected Set<ApplicationId> appIds = new LinkedHashSet<ApplicationId>();
    protected final ISessionDatasource sessionDataSource;

    public MetaDataImpl(IContainer s) {
        this.stack = s;
        this.sessionDataSource = s.getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
    }

    public MetaDataImpl(IContainer s, IStatisticManager statisticFactory) {
        this(s);
        this.peer = this.newLocalPeer(statisticFactory);
        IStatisticRecord heapMemory = statisticFactory.newCounterRecord(IStatisticRecord.Counters.HeapMemory, new IStatisticRecord.LongValueHolder(){

            @Override
            public long getValueAsLong() {
                for (MemoryPoolMXBean bean : MetaDataImpl.this.beans) {
                    MemoryType memoryType = bean.getType();
                    MemoryUsage memoryUsage = bean.getUsage();
                    if (memoryType != MemoryType.HEAP) continue;
                    return memoryUsage.getUsed();
                }
                return 0L;
            }

            @Override
            public String getValueAsString() {
                return String.valueOf(this.getValueAsLong());
            }
        });
        IStatisticRecord noHeapMemory = statisticFactory.newCounterRecord(IStatisticRecord.Counters.NoHeapMemory, new IStatisticRecord.LongValueHolder(){

            @Override
            public long getValueAsLong() {
                for (MemoryPoolMXBean bean : MetaDataImpl.this.beans) {
                    MemoryType memoryType = bean.getType();
                    MemoryUsage memoryUsage = bean.getUsage();
                    if (memoryType == MemoryType.HEAP) continue;
                    return memoryUsage.getUsed();
                }
                return 0L;
            }

            @Override
            public String getValueAsString() {
                return String.valueOf(this.getValueAsLong());
            }
        });
        this.peer.getStatistic().appendCounter(heapMemory, noHeapMemory);
    }

    protected IPeer newLocalPeer(IStatisticManager statisticFactory) {
        return new ClientLocalPeer(statisticFactory);
    }

    public Peer getLocalPeer() {
        return this.peer;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 1;
    }

    public StackType getStackType() {
        return StackType.TYPE_CLIENT;
    }

    public Configuration getConfiguration() {
        return this.stack.getConfiguration();
    }

    @Override
    public void updateLocalHostStateId() {
        this.state = System.currentTimeMillis();
    }

    @Override
    public long getLocalHostStateId() {
        return this.state;
    }

    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        return aClass == IMetaData.class;
    }

    public <T> T unwrap(Class<T> aClass) throws InternalException {
        if (aClass == IMetaData.class) {
            return (T)this;
        }
        return null;
    }

    protected class ClientLocalPeer
    extends AbstractPeer
    implements IPeer {
        protected AtomicLong hopByHopId;
        protected InetAddress[] addresses;

        public void resetAddresses() {
            this.addresses = new InetAddress[0];
        }

        public void connect() throws IllegalDiameterStateException {
            throw new IllegalDiameterStateException("Illegal operation");
        }

        @Override
        public void disconnect(int disconnectCause) throws IllegalDiameterStateException {
            throw new IllegalDiameterStateException("Illegal operation");
        }

        public ClientLocalPeer(IStatisticManager statisticFactory) {
            super(null, statisticFactory);
            this.hopByHopId = new AtomicLong(0L);
            this.addresses = new InetAddress[0];
            this.createPeerStatistics();
        }

        public <E> E getState(Class<E> anEnum) {
            switch (MetaDataImpl.this.stack.getState()) {
                case IDLE: {
                    return (E)PeerState.DOWN;
                }
                case CONFIGURED: {
                    return (E)PeerState.INITIAL;
                }
                case STARTED: {
                    return (E)PeerState.OKAY;
                }
                case STOPPED: {
                    return (E)PeerState.SUSPECT;
                }
            }
            return (E)PeerState.DOWN;
        }

        public URI getUri() {
            try {
                return new URI(MetaDataImpl.this.stack.getConfiguration().getStringValue(Parameters.OwnDiameterURI.ordinal(), (String)Parameters.OwnDiameterURI.defValue()));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            catch (UnknownServiceException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public String getRealmName() {
            return MetaDataImpl.this.stack.getConfiguration().getStringValue(Parameters.OwnRealm.ordinal(), (String)Parameters.OwnRealm.defValue());
        }

        public long getVendorId() {
            return MetaDataImpl.this.stack.getConfiguration().getLongValue(Parameters.OwnVendorID.ordinal(), ((Long)Parameters.OwnVendorID.defValue()).longValue());
        }

        public String getProductName() {
            return MetaDataImpl.this.stack.getConfiguration().getStringValue(Parameters.OwnProductName.ordinal(), (String)Parameters.OwnProductName.defValue());
        }

        public long getFirmware() {
            return MetaDataImpl.this.stack.getConfiguration().getLongValue(Parameters.OwnFirmwareRevision.ordinal(), -1L);
        }

        public Set<ApplicationId> getCommonApplications() {
            if (logger.isDebugEnabled()) {
                logger.debug("In getCommonApplications appIds size is [{}]", (Object)MetaDataImpl.this.appIds.size());
            }
            if (MetaDataImpl.this.appIds.isEmpty()) {
                Configuration[] apps = MetaDataImpl.this.stack.getConfiguration().getChildren(Parameters.ApplicationId.ordinal());
                if (apps != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Stack configuration has apps list size of  [{}]. Looping through them", (Object)apps.length);
                    }
                    for (Configuration a : apps) {
                        long vnd = a.getLongValue(Parameters.VendorId.ordinal(), 0L);
                        long auth = a.getLongValue(Parameters.AuthApplId.ordinal(), 0L);
                        long acc = a.getLongValue(Parameters.AcctApplId.ordinal(), 0L);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Adding app id vendor [{}] auth [{}] acc [{}]", new Object[]{vnd, auth, acc});
                        }
                        if (auth != 0L) {
                            MetaDataImpl.this.appIds.add(ApplicationId.createByAuthAppId((long)vnd, (long)auth));
                        }
                        if (acc == 0L) continue;
                        MetaDataImpl.this.appIds.add(ApplicationId.createByAccAppId((long)vnd, (long)acc));
                    }
                } else {
                    logger.debug("Apps is null - we have no apps in the stack configuration.");
                }
            }
            return MetaDataImpl.this.appIds;
        }

        public InetAddress[] getIPAddresses() {
            if (this.addresses.length == 0) {
                String address = MetaDataImpl.this.stack.getConfiguration().getStringValue(Parameters.OwnIPAddress.ordinal(), null);
                if (address == null || address.length() == 0) {
                    try {
                        this.addresses = new InetAddress[]{InetAddress.getByName(this.getUri().getFQDN())};
                    }
                    catch (UnknownHostException e) {
                        logger.debug("Can not get IP by URI {}", (Throwable)e);
                        try {
                            this.addresses = new InetAddress[]{InetAddress.getLocalHost()};
                        }
                        catch (UnknownHostException e1) {
                            this.addresses = new InetAddress[0];
                        }
                    }
                } else {
                    InetAddress ia = IPConverter.InetAddressByIPv4(address);
                    if (ia == null) {
                        ia = IPConverter.InetAddressByIPv6(address);
                    }
                    if (ia == null) {
                        try {
                            this.addresses = new InetAddress[]{InetAddress.getLocalHost()};
                        }
                        catch (UnknownHostException e) {
                            this.addresses = new InetAddress[0];
                        }
                    } else {
                        this.addresses = new InetAddress[]{ia};
                    }
                }
            }
            return this.addresses;
        }

        @Override
        public IStatistic getStatistic() {
            return this.statistic;
        }

        public String toString() {
            return "Peer{\n\tUri=" + this.getUri() + "; RealmName=" + this.getRealmName() + "; VendorId=" + this.getVendorId() + ";\n\tProductName=" + this.getProductName() + "; FirmWare=" + this.getFirmware() + ";\n\tAppIds=" + this.getCommonApplications() + ";\n\tIPAddresses=" + Arrays.asList(this.getIPAddresses()).toString() + ";\n}";
        }

        @Override
        public int getRating() {
            return 0;
        }

        public void addPeerStateListener(PeerStateListener peerStateListener) {
        }

        public void removePeerStateListener(PeerStateListener peerStateListener) {
        }

        @Override
        public long getHopByHopIdentifier() {
            return this.hopByHopId.incrementAndGet();
        }

        @Override
        public void addMessage(IMessage message) {
        }

        @Override
        public void remMessage(IMessage message) {
        }

        @Override
        public IMessage[] remAllMessage() {
            return new IMessage[0];
        }

        @Override
        public boolean handleMessage(EventTypes type, IMessage message, String key) throws TransportException, OverloadException, InternalException {
            return false;
        }

        @Override
        public boolean sendMessage(IMessage message) throws TransportException, OverloadException {
            return false;
        }

        @Override
        public boolean hasValidConnection() {
            return false;
        }

        @Override
        public void setRealm(String realm) {
        }

        @Override
        public void addStateChangeListener(StateChangeListener listener) {
        }

        @Override
        public void remStateChangeListener(StateChangeListener listener) {
        }

        @Override
        public void addConnectionListener(IConnectionListener listener) {
        }

        @Override
        public void remConnectionListener(IConnectionListener listener) {
        }

        @Override
        public boolean isConnected() {
            return true;
        }
    }
}

