/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.validation;

import java.util.HashMap;
import java.util.Map;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.Message;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.api.validation.AvpRepresentation;
import org.jdiameter.api.validation.MessageRepresentation;
import org.jdiameter.api.validation.ValidatorLevel;
import org.jdiameter.common.impl.validation.AvpRepresentationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageRepresentationImpl
implements MessageRepresentation {
    private static transient Logger logger = LoggerFactory.getLogger(MessageRepresentationImpl.class);
    private int commandCode = -1;
    private long applicationId = 0L;
    private boolean isRequest = false;
    protected Map<AvpRepresentation, AvpRepresentation> unmuttableMessageAvps = new HashMap<AvpRepresentation, AvpRepresentation>();
    private String name = null;

    public MessageRepresentationImpl(int commandCode, long applicationId, boolean isRequest) {
        this.commandCode = commandCode;
        this.applicationId = applicationId;
        this.isRequest = isRequest;
    }

    public MessageRepresentationImpl(int commandCode, boolean isRequest) {
        this(commandCode, 0L, isRequest);
    }

    public MessageRepresentationImpl(int commandCode, long applicationId, boolean isRequest, String name) {
        this.commandCode = commandCode;
        this.applicationId = applicationId;
        this.isRequest = isRequest;
        this.name = name;
    }

    public MessageRepresentationImpl(MessageRepresentationImpl clone) {
        this.applicationId = clone.applicationId;
        this.commandCode = clone.commandCode;
        this.isRequest = clone.isRequest;
        this.name = clone.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.applicationId ^ this.applicationId >>> 32);
        result = 31 * result + this.commandCode;
        result = 31 * result + (this.isRequest ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageRepresentationImpl other = (MessageRepresentationImpl)obj;
        if (this.applicationId != other.applicationId) {
            return false;
        }
        if (this.commandCode != other.commandCode) {
            return false;
        }
        return this.isRequest == other.isRequest;
    }

    public Map<AvpRepresentation, AvpRepresentation> getMessageAvps() {
        return this.unmuttableMessageAvps;
    }

    public void setMessageAvps(Map<AvpRepresentation, AvpRepresentation> messageAvps) {
        this.unmuttableMessageAvps = messageAvps;
    }

    public int getCommandCode() {
        return this.commandCode;
    }

    public long getApplicationId() {
        return this.applicationId;
    }

    public boolean isRequest() {
        return this.isRequest;
    }

    public String getName() {
        return this.name;
    }

    public AvpRepresentation getAvp(int code) {
        return this.getAvp(code, 0L);
    }

    public AvpRepresentation getAvp(int code, long vendorId) {
        AvpRepresentation avp = this.unmuttableMessageAvps.get(new AvpRepresentationImpl(code, vendorId));
        if (avp == null) {
            logger.warn("AVP with code " + code + " and Vendor-Id " + vendorId + " not present in Message Representation!");
        }
        return avp;
    }

    public boolean isAllowed(int code, long vendorId) {
        AvpRepresentationImpl avpRep = new AvpRepresentationImpl(code, vendorId);
        if ((avpRep = this.unmuttableMessageAvps.get(avpRep)) == null) {
            return true;
        }
        return avpRep.isAllowed();
    }

    public boolean isAllowed(int code) {
        return this.isAllowed(code, 0L);
    }

    public boolean isCountValidForMultiplicity(int code, int avpCount) {
        return this.isCountValidForMultiplicity(code, 0L, avpCount);
    }

    public boolean isCountValidForMultiplicity(int code, long vendorId, int avpCount) {
        AvpRepresentation avpRep = this.getAvp(code, vendorId);
        if (avpRep == null) {
            return true;
        }
        return avpRep.isCountValidForMultiplicity(avpCount);
    }

    public boolean isCountValidForMultiplicity(AvpSet destination, int code, long vendorId) {
        return this.isCountValidForMultiplicity(destination, code, vendorId, 0);
    }

    public boolean isCountValidForMultiplicity(AvpSet destination, int code) {
        return this.isCountValidForMultiplicity(destination, code, 0L);
    }

    public boolean isCountValidForMultiplicity(AvpSet destination, int code, long vendorId, int numberToAdd) {
        AvpRepresentation avpRep = this.getAvp(code, vendorId);
        if (avpRep == null) {
            return true;
        }
        return avpRep.isCountValidForMultiplicity(destination, numberToAdd);
    }

    public boolean isCountValidForMultiplicity(AvpSet destination, int code, int numberToAdd) {
        return this.isCountValidForMultiplicity(destination, code, 0L, numberToAdd);
    }

    public int compareTo(MessageRepresentation o) {
        if (o == this) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        return this.hashCode() - o.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        MessageRepresentationImpl clone = (MessageRepresentationImpl)super.clone();
        clone.applicationId = this.applicationId;
        clone.commandCode = this.commandCode;
        clone.isRequest = this.isRequest;
        clone.name = this.name;
        HashMap<AvpRepresentation, AvpRepresentation> map = new HashMap<AvpRepresentation, AvpRepresentation>();
        for (Map.Entry<AvpRepresentation, AvpRepresentation> entry : this.unmuttableMessageAvps.entrySet()) {
            map.put((AvpRepresentation)entry.getKey().clone(), (AvpRepresentation)entry.getValue().clone());
        }
        clone.setMessageAvps(map);
        return clone;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.isRequest ? "Request" : "Answer").append(" code: ").append(this.commandCode).append(" applicationId: ").append(this.applicationId).append(" name: ").append(this.name);
        for (AvpRepresentation childAvp : this.getMessageAvps().values()) {
            sb.append("\n").append(childAvp.toString());
        }
        return sb.toString();
    }

    public void validate(Message msg, ValidatorLevel validatorLevel) throws AvpNotAllowedException {
        if (validatorLevel == ValidatorLevel.OFF) {
            return;
        }
        for (AvpRepresentation ap : this.unmuttableMessageAvps.values()) {
            AvpSet innerSet = msg.getAvps().getAvps(ap.getCode(), ap.getVendorId());
            int count = 0;
            if (innerSet != null) {
                count = innerSet.size();
            }
            if (!ap.isCountValidForMultiplicity(count)) {
                throw new AvpNotAllowedException("AVP: \n" + ap + "\n,has wrong count in message - " + count, ap.getCode(), ap.getVendorId());
            }
            if (validatorLevel != ValidatorLevel.ALL || count == 0 || !ap.isGrouped()) continue;
            this.validateGrouped(ap, innerSet);
        }
    }

    private void validateGrouped(AvpRepresentation ap, AvpSet innerSet) {
        for (int index = 0; index < innerSet.size(); ++index) {
            Avp presumablyGrouped = innerSet.getAvpByIndex(index);
            ap.validate(presumablyGrouped);
        }
    }
}

