/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.acc;

import java.util.concurrent.ScheduledFuture;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.acc.ClientAccSession;
import org.jdiameter.api.acc.ClientAccSessionListener;
import org.jdiameter.api.acc.ServerAccSession;
import org.jdiameter.api.acc.ServerAccSessionListener;
import org.jdiameter.api.acc.events.AccountAnswer;
import org.jdiameter.api.acc.events.AccountRequest;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.acc.ClientAccSessionImpl;
import org.jdiameter.client.impl.app.acc.IClientAccSessionData;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.acc.IAccMessageFactory;
import org.jdiameter.common.api.app.acc.IAccSessionData;
import org.jdiameter.common.api.app.acc.IAccSessionFactory;
import org.jdiameter.common.api.app.acc.IClientAccActionContext;
import org.jdiameter.common.api.app.acc.IServerAccActionContext;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.acc.AccLocalSessionDataFactory;
import org.jdiameter.common.impl.app.acc.AccountAnswerImpl;
import org.jdiameter.common.impl.app.acc.AccountRequestImpl;
import org.jdiameter.common.impl.app.acc.AppAccSessionImpl;
import org.jdiameter.server.impl.app.acc.IServerAccSessionData;
import org.jdiameter.server.impl.app.acc.ServerAccSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccSessionFactoryImpl
implements IAccSessionFactory,
IAccMessageFactory,
ServerAccSessionListener,
ClientAccSessionListener,
IClientAccActionContext,
IServerAccActionContext,
StateChangeListener<AppSession> {
    protected Logger logger = LoggerFactory.getLogger(AccSessionFactoryImpl.class);
    protected ServerAccSessionListener serverSessionListener;
    protected StateChangeListener<AppSession> stateListener;
    protected ClientAccSessionListener clientSessionListener;
    protected IClientAccActionContext clientContextListener;
    protected IServerAccActionContext serverContextListener;
    protected ISessionDatasource iss;
    protected ISessionFactory sessionFactory = null;
    protected ApplicationId applicationId;
    protected IAccMessageFactory messageFactory = this;
    protected IAppSessionDataFactory<IAccSessionData> sessionDataFactory;

    protected AccSessionFactoryImpl() {
    }

    public AccSessionFactoryImpl(SessionFactory sessionFactory) {
        this.setSessionFactory((ISessionFactory)sessionFactory);
    }

    @Override
    public ServerAccSessionListener getServerSessionListener() {
        if (this.serverSessionListener != null) {
            return this.serverSessionListener;
        }
        return this;
    }

    @Override
    public void setServerSessionListener(ServerAccSessionListener serverSessionListener) {
        this.serverSessionListener = serverSessionListener;
    }

    @Override
    public StateChangeListener<AppSession> getStateListener() {
        if (this.stateListener != null) {
            return this.stateListener;
        }
        return this;
    }

    @Override
    public void setStateListener(StateChangeListener<AppSession> stateListener) {
        this.stateListener = stateListener;
    }

    @Override
    public ClientAccSessionListener getClientSessionListener() {
        if (this.clientSessionListener != null) {
            return this.clientSessionListener;
        }
        return this;
    }

    @Override
    public void setClientSessionListener(ClientAccSessionListener clientSessionListener) {
        this.clientSessionListener = clientSessionListener;
    }

    @Override
    public IClientAccActionContext getClientContextListener() {
        if (this.clientContextListener != null) {
            return this.clientContextListener;
        }
        return this;
    }

    @Override
    public void setClientContextListener(IClientAccActionContext clientContextListener) {
        this.clientContextListener = clientContextListener;
    }

    @Override
    public IServerAccActionContext getServerContextListener() {
        if (this.serverContextListener != null) {
            return this.serverContextListener;
        }
        return this;
    }

    @Override
    public void setServerContextListener(IServerAccActionContext serverContextListener) {
        this.serverContextListener = serverContextListener;
    }

    @Override
    public void setMessageFactory(IAccMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public IAccMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public ISessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(ISessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        if (this.iss == null) {
            this.iss = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
            this.sessionDataFactory = this.iss.getDataFactory(IAccSessionData.class);
            if (this.sessionDataFactory == null) {
                this.logger.debug("No factory for Accounting Application data, using default/local.");
                this.sessionDataFactory = new AccLocalSessionDataFactory();
            }
        }
    }

    @Override
    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    @Override
    public void setApplicationId(ApplicationId id) {
        this.applicationId = id;
    }

    @Override
    public AppSession getSession(String sessionId, Class<? extends AppSession> aClass) {
        AppAccSessionImpl appSession;
        block6: {
            if (sessionId == null) {
                throw new IllegalArgumentException("SessionId must not be null");
            }
            if (!this.iss.exists(sessionId)) {
                return null;
            }
            appSession = null;
            try {
                if (aClass == ClientAccSession.class) {
                    IClientAccSessionData data = (IClientAccSessionData)this.sessionDataFactory.getAppSessionData(ClientAccSession.class, sessionId);
                    ClientAccSessionImpl clientSession = new ClientAccSessionImpl(data, this.sessionFactory, this.getClientSessionListener(), this.getClientContextListener(), this.getStateListener());
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block6;
                }
                if (aClass == ServerAccSession.class) {
                    ServerAccSessionImpl serverSession = null;
                    IServerAccSessionData data = (IServerAccSessionData)this.sessionDataFactory.getAppSessionData(ServerAccSession.class, sessionId);
                    serverSession = new ServerAccSessionImpl(data, this.sessionFactory, this.getServerSessionListener(), this.getServerContextListener(), this.getStateListener());
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block6;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ClientAccSession.class + "," + ServerAccSession.class + "]");
            }
            catch (Exception e) {
                this.logger.error("Failure to obtain new Accounting Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    @Override
    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        try {
            if (aClass == ServerAccSession.class) {
                if (sessionId == null) {
                    if (args != null && args.length > 0 && args[0] instanceof Request) {
                        Request request = (Request)args[0];
                        sessionId = request.getSessionId();
                    } else {
                        sessionId = this.sessionFactory.getSessionId();
                    }
                }
                boolean stateless = true;
                if (args != null && args.length > 0) {
                    for (Object o : args) {
                        if (!(o instanceof Boolean)) continue;
                        stateless = (Boolean)o;
                    }
                }
                IServerAccSessionData data = (IServerAccSessionData)this.sessionDataFactory.getAppSessionData(ServerAccSession.class, sessionId);
                data.setApplicationId(applicationId);
                ServerAccSessionImpl session = new ServerAccSessionImpl(data, this.sessionFactory, this.getServerSessionListener(), this.getServerContextListener(), this.getStateListener(), stateless);
                this.iss.addSession((BaseSession)session);
                session.getSessions().get(0).setRequestListener((NetworkReqListener)session);
                return session;
            }
            if (aClass == ClientAccSession.class) {
                if (sessionId == null) {
                    if (args != null && args.length > 0 && args[0] instanceof Request) {
                        Request request = (Request)args[0];
                        sessionId = request.getSessionId();
                    } else {
                        sessionId = this.sessionFactory.getSessionId();
                    }
                }
                IClientAccSessionData data = (IClientAccSessionData)this.sessionDataFactory.getAppSessionData(ClientAccSession.class, sessionId);
                data.setApplicationId(applicationId);
                ClientAccSessionImpl session = new ClientAccSessionImpl(data, this.sessionFactory, this.getClientSessionListener(), this.getClientContextListener(), this.getStateListener());
                this.iss.addSession((BaseSession)session);
                session.getSessions().get(0).setRequestListener((NetworkReqListener)session);
                return session;
            }
        }
        catch (Exception e) {
            this.logger.error("Failure to obtain new Accounting Session.", (Throwable)e);
        }
        return null;
    }

    public void stateChanged(Enum oldState, Enum newState) {
        this.logger.info("Diameter ACC SessionFactory :: stateChanged :: oldState[{}], newState[{}]", (Object)oldState, (Object)newState);
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.logger.info("Diameter ACC SessionFactory :: stateChanged :: source[{}], oldState[{}], newState[{}]", new Object[]{source, oldState, newState});
    }

    public void doAccRequestEvent(ServerAccSession appSession, AccountRequest acr) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.logger.info("Diameter Base AccountingSessionFactory :: doAccRequestEvent :: appSession[" + appSession + "], Request[" + acr + "]");
    }

    public void doAccAnswerEvent(ClientAccSession appSession, AccountRequest acr, AccountAnswer aca) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.logger.info("doAccAnswerEvent :: appSession[" + appSession + "], Request[" + acr + "], Answer[" + aca + "]");
    }

    public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.logger.info("Diameter Base AccountingSessionFactory :: doOtherEvent :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]");
    }

    @Override
    public void disconnectUserOrDev(ClientAccSession appSession, Request sessionTermRequest) throws InternalException {
        this.logger.info("disconnectUserOrDev :: appSession[" + appSession + "], Request[" + sessionTermRequest + "]");
    }

    @Override
    public boolean failedSendRecord(ClientAccSession appSession, Request accRequest) throws InternalException {
        this.logger.info("failedSendRecord :: appSession[" + appSession + "], Request[" + accRequest + "]");
        return false;
    }

    @Override
    public void interimIntervalElapses(ClientAccSession appSession, Request interimRequest) throws InternalException {
        this.logger.info("interimIntervalElapses :: appSession[" + appSession + "], Request[" + interimRequest + "]");
    }

    @Override
    public void sessionTimeoutElapses(ServerAccSession appSession) throws InternalException {
        this.logger.info("sessionTimeoutElapses :: appSession[" + appSession + "]");
    }

    @Override
    public void sessionTimerStarted(ServerAccSession appSession, ScheduledFuture timer) throws InternalException {
        this.logger.info("sessionTimerStarted :: appSession[" + appSession + "]");
    }

    @Override
    public void sessionTimerCanceled(ServerAccSession appSession, ScheduledFuture timer) throws InternalException {
        this.logger.info("sessionTimerCanceled :: appSession[" + appSession + "]");
    }

    @Override
    public int getAccMessageCommandCode() {
        return 271;
    }

    @Override
    public AccountRequest createAccRequest(Request request) {
        return new AccountRequestImpl(request);
    }

    @Override
    public AccountAnswer createAccAnswer(Answer answer) {
        return new AccountAnswerImpl(answer);
    }
}

