/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.OverloadException;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.io.IConnection;
import org.jdiameter.client.api.io.IConnectionListener;
import org.jdiameter.client.api.io.TransportError;
import org.jdiameter.client.api.io.TransportException;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.transport.tcp.TCPTransportClient;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPClientConnection
implements IConnection {
    private static Logger logger = LoggerFactory.getLogger(TCPClientConnection.class);
    private final long createdTime;
    private TCPTransportClient client;
    private LinkedBlockingQueue<Event> buffer = new LinkedBlockingQueue(64);
    private IMessageParser parser;
    private Lock lock = new ReentrantLock();
    private ConcurrentLinkedQueue<IConnectionListener> listeners = new ConcurrentLinkedQueue();
    private String cachedKey = null;

    protected TCPClientConnection(IConcurrentFactory concurrentFactory, IMessageParser parser) {
        this.createdTime = System.currentTimeMillis();
        this.parser = parser;
        this.client = new TCPTransportClient(concurrentFactory, this);
    }

    public TCPClientConnection(Configuration config, IConcurrentFactory concurrentFactory, Socket socket, IMessageParser parser, String ref) throws Exception {
        this(concurrentFactory, parser);
        this.client = new TCPTransportClient(concurrentFactory, this);
        this.client.initialize(socket);
        this.client.start();
    }

    public TCPClientConnection(Configuration config, IConcurrentFactory concurrentFactory, InetAddress remoteAddress, int remotePort, InetAddress localAddress, int localPort, IMessageParser parser, String ref) {
        this(concurrentFactory, parser);
        this.client.setDestAddress(new InetSocketAddress(remoteAddress, remotePort));
        this.client.setOrigAddress(new InetSocketAddress(localAddress, localPort));
    }

    public TCPClientConnection(Configuration config, IConcurrentFactory concurrentFactory, InetAddress remoteAddress, int remotePort, InetAddress localAddress, int localPort, IConnectionListener listener, IMessageParser parser, String ref) {
        this(concurrentFactory, parser);
        this.client.setDestAddress(new InetSocketAddress(remoteAddress, remotePort));
        this.client.setOrigAddress(new InetSocketAddress(localAddress, localPort));
        this.listeners.add(listener);
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public void connect() throws TransportException {
        try {
            this.getClient().initialize();
            this.getClient().start();
        }
        catch (IOException e) {
            throw new TransportException("Cannot init transport: ", TransportError.NetWorkError, e);
        }
        catch (Exception e) {
            throw new TransportException("Cannot init transport: ", TransportError.Internal, e);
        }
    }

    @Override
    public void disconnect() throws InternalError {
        logger.debug("In disconnect for [{}]", (Object)this.getKey());
        try {
            if (this.getClient() != null) {
                this.getClient().stop();
            }
        }
        catch (Exception e) {
            throw new InternalError("Error while stopping transport: " + e.getMessage());
        }
    }

    @Override
    public void release() throws IOException {
        logger.debug("In release for [{}]", (Object)this.getKey());
        try {
            if (this.getClient() != null) {
                this.getClient().release();
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            this.parser = null;
            this.buffer.clear();
            this.remAllConnectionListener();
        }
    }

    @Override
    public void sendMessage(IMessage message) throws TransportException, OverloadException {
        try {
            if (this.getClient() != null) {
                this.getClient().sendMessage(this.parser.encodeMessage(message));
            }
        }
        catch (Exception e) {
            throw new TransportException("Cannot send message: ", TransportError.FailedSendMessage, e);
        }
    }

    protected TCPTransportClient getClient() {
        return this.client;
    }

    @Override
    public boolean isNetworkInitiated() {
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.getClient() != null && this.getClient().isConnected();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.getClient().getDestAddress().getAddress();
    }

    @Override
    public int getRemotePort() {
        return this.getClient().getDestAddress().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionListener(IConnectionListener listener) {
        this.lock.lock();
        try {
            this.listeners.add(listener);
            if (this.buffer.size() != 0) {
                for (Event e : this.buffer) {
                    try {
                        logger.debug("Processing event from buffer");
                        this.onEvent(e);
                    }
                    catch (AvpDataException e1) {}
                }
                this.buffer.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remAllConnectionListener() {
        logger.debug("Waiting to get lock in order to remove all listeners");
        this.lock.lock();
        try {
            logger.debug("Removing all listeners on [{}]", (Object)this.getKey());
            this.listeners.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remConnectionListener(IConnectionListener listener) {
        this.lock.lock();
        try {
            logger.debug("Removing listener [{}] on [{}]", (Object)listener.getClass().getName(), (Object)this.getKey());
            this.listeners.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        return false;
    }

    public <T> T unwrap(Class<T> aClass) throws InternalException {
        return null;
    }

    @Override
    public String getKey() {
        if (this.cachedKey == null) {
            this.cachedKey = new StringBuffer("aaa://").append(this.getRemoteAddress().getHostName()).append(":").append(this.getRemotePort()).toString();
        }
        return this.cachedKey;
    }

    protected void onDisconnect() throws AvpDataException {
        this.onEvent(new Event(EventType.DISCONNECTED));
    }

    protected void onMessageReceived(ByteBuffer message) throws AvpDataException {
        if (logger.isDebugEnabled()) {
            logger.debug("Received message of size [{}]", (Object)message.array().length);
        }
        this.onEvent(new Event(EventType.MESSAGE_RECEIVED, message));
    }

    protected void onAvpDataException(AvpDataException e) {
        try {
            this.onEvent(new Event(EventType.DATA_EXCEPTION, (Exception)((Object)e)));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    protected void onConnected() {
        try {
            this.onEvent(new Event(EventType.CONNECTED));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEvent(Event event) throws AvpDataException {
        logger.debug("In onEvent for connection [{}]. Getting lock", (Object)this.getKey());
        this.lock.lock();
        logger.debug("Got lock");
        try {
            if (this.processBufferedMessages(event)) {
                for (IConnectionListener listener : this.listeners) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Passing event to listener. Event type is [{}]", (Object)event.type.toString());
                    }
                    switch (event.type) {
                        case CONNECTED: {
                            listener.connectionOpened(this.getKey());
                            break;
                        }
                        case DISCONNECTED: {
                            listener.connectionClosed(this.getKey(), null);
                            break;
                        }
                        case MESSAGE_RECEIVED: {
                            IMessage msg = this.parser.createMessage(event.message);
                            listener.messageReceived(this.getKey(), msg);
                            break;
                        }
                        case DATA_EXCEPTION: {
                            listener.internalError(this.getKey(), null, new TransportException("Avp Data Exception:", TransportError.ReceivedBrokenMessage, event.exception));
                        }
                    }
                }
            }
        }
        finally {
            logger.debug("Releasing lock and finished onEvent for connection [{}]", (Object)this.getKey());
            this.lock.unlock();
        }
    }

    protected boolean processBufferedMessages(Event event) throws AvpDataException {
        if (this.listeners.size() == 0) {
            logger.debug("listeners.size() == 0 on connection [{}]", (Object)this.getKey());
            try {
                this.buffer.add(event);
            }
            catch (IllegalStateException e) {
                logger.debug("Got IllegalStateException in processBufferedMessages");
                Event[] tempBuffer = this.buffer.toArray(new Event[this.buffer.size()]);
                this.buffer.remove(tempBuffer[tempBuffer.length - 1]);
                this.buffer.add(event);
            }
            logger.debug("processBufferedMessages is returning false");
            return false;
        }
        logger.debug("processBufferedMessages is returning true on connection [{}] as there are listeners", (Object)this.getKey());
        return true;
    }

    private static class Event {
        EventType type;
        ByteBuffer message;
        Exception exception;

        Event(EventType type) {
            this.type = type;
        }

        Event(EventType type, Exception exception) {
            this(type);
            this.exception = exception;
        }

        Event(EventType type, ByteBuffer message) {
            this(type);
            this.message = message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EventType {
        CONNECTED,
        DISCONNECTED,
        MESSAGE_RECEIVED,
        DATA_EXCEPTION;

    }
}

