/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.client.api.parser.IElementParser;
import org.jdiameter.client.api.parser.ParseException;
import org.jdiameter.client.impl.parser.AvpImpl;
import org.jdiameter.client.impl.parser.AvpSetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementParser
implements IElementParser {
    private static final Logger logger = LoggerFactory.getLogger(ElementParser.class);
    private static final long SECOND_SHIFT = 2208988800L;
    private static final int INT_INET4 = 1;
    private static final int INT_INET6 = 2;
    private static final int INT32_SIZE = 4;
    private static final int INT64_SIZE = 8;
    private static final int FLOAT32_SIZE = 4;
    private static final int FLOAT64_SIZE = 8;

    @Override
    public int bytesToInt(byte[] rawData) throws AvpDataException {
        return this.prepareBuffer(rawData, 4).getInt();
    }

    @Override
    public long bytesToLong(byte[] rawData) throws AvpDataException {
        return this.prepareBuffer(rawData, 8).getLong();
    }

    @Override
    public float bytesToFloat(byte[] rawData) throws AvpDataException {
        return this.prepareBuffer(rawData, 4).getFloat();
    }

    @Override
    public double bytesToDouble(byte[] rawData) throws AvpDataException {
        return this.prepareBuffer(rawData, 8).getDouble();
    }

    protected ByteBuffer prepareBuffer(byte[] bytes, int len) throws AvpDataException {
        if (bytes.length != len) {
            throw new AvpDataException("Incorrect data length");
        }
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public String bytesToOctetString(byte[] rawData) throws AvpDataException {
        try {
            return new String(rawData, "iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new AvpDataException("Invalid data type", (Throwable)e);
        }
    }

    @Override
    public String bytesToUtf8String(byte[] rawData) throws AvpDataException {
        try {
            char[] ca = new String(rawData, "utf8").toCharArray();
            StringBuffer rc = new StringBuffer(ca.length);
            for (char c : ca) {
                if (c == '\u0000') continue;
                rc.append(c);
            }
            return rc.toString();
        }
        catch (Exception e) {
            throw new AvpDataException("Invalid data type", (Throwable)e);
        }
    }

    @Override
    public Date bytesToDate(byte[] rawData) throws AvpDataException {
        try {
            byte[] tmp = new byte[8];
            System.arraycopy(rawData, 0, tmp, 4, 4);
            return new Date((this.bytesToLong(tmp) - 2208988800L) * 1000L);
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e);
        }
    }

    @Override
    public InetAddress bytesToAddress(byte[] rawData) throws AvpDataException {
        InetAddress inetAddress;
        try {
            if (rawData[1] == 1) {
                byte[] address = new byte[4];
                System.arraycopy(rawData, 2, address, 0, address.length);
                inetAddress = Inet4Address.getByAddress(address);
            } else {
                byte[] address = new byte[16];
                System.arraycopy(rawData, 2, address, 0, address.length);
                inetAddress = Inet6Address.getByAddress(address);
            }
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e);
        }
        return inetAddress;
    }

    @Override
    public byte[] int32ToBytes(int value) {
        byte[] bytes = new byte[4];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.putInt(value);
        return bytes;
    }

    @Override
    public byte[] intU32ToBytes(long value) {
        byte[] bytes = new byte[4];
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        buffer.flip();
        buffer.get(bytes);
        buffer.get(bytes);
        return bytes;
    }

    @Override
    public byte[] int64ToBytes(long value) {
        byte[] bytes = new byte[8];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.putLong(value);
        return bytes;
    }

    @Override
    public byte[] float32ToBytes(float value) {
        byte[] bytes = new byte[4];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.putFloat(value);
        return bytes;
    }

    @Override
    public byte[] float64ToBytes(double value) {
        byte[] bytes = new byte[8];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.putDouble(value);
        return bytes;
    }

    @Override
    public byte[] octetStringToBytes(String value) throws ParseException {
        try {
            return value.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public byte[] utf8StringToBytes(String value) throws ParseException {
        try {
            return value.getBytes("utf8");
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public byte[] addressToBytes(InetAddress address) {
        byte[] byteAddrOrig = address.getAddress();
        byte[] data = new byte[byteAddrOrig.length + 2];
        int addrType = address instanceof Inet4Address ? 1 : 2;
        data[0] = (byte)(addrType >> 8 & 0xFF);
        data[1] = (byte)(addrType >> 0 & 0xFF);
        System.arraycopy(byteAddrOrig, 0, data, 2, byteAddrOrig.length);
        return data;
    }

    @Override
    public byte[] dateToBytes(Date date) {
        byte[] data = new byte[4];
        System.arraycopy(this.int64ToBytes(date.getTime() / 1000L + 2208988800L), 4, data, 0, 4);
        return data;
    }

    @Override
    public <T> T bytesToObject(Class<?> iface, byte[] rawdata) throws AvpDataException {
        return null;
    }

    @Override
    public byte[] objectToBytes(Object data) throws ParseException {
        return null;
    }

    public AvpSetImpl decodeAvpSet(byte[] buffer) throws IOException, AvpDataException {
        return this.decodeAvpSet(buffer, 0);
    }

    public AvpSetImpl decodeAvpSet(byte[] buffer, int shift) throws IOException, AvpDataException {
        int length;
        AvpSetImpl avps = new AvpSetImpl();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer, shift, buffer.length));
        for (int counter = shift; counter < buffer.length; counter += length) {
            int code = in.readInt();
            int tmp = in.readInt();
            int flags = tmp >> 24 & 0xFF;
            length = tmp & 0xFFFFFF;
            if (length < 0 || counter + length > buffer.length) {
                throw new AvpDataException("Not enough data in buffer!");
            }
            long vendor = 0L;
            if ((flags & 0x80) != 0) {
                vendor = in.readInt();
            }
            byte[] rawData = new byte[length - (8 + (vendor == 0L ? 0 : 4))];
            in.read(rawData);
            if (length % 4 != 0) {
                while (length % 4 != 0) {
                    int i = (int)in.skip(4 - length % 4);
                    length += i;
                }
            }
            AvpImpl avp = new AvpImpl(code, (short)flags, (int)vendor, rawData);
            avps.addAvp(avp);
        }
        return avps;
    }

    public byte[] encodeAvpSet(AvpSet avps) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            DataOutputStream data = new DataOutputStream(out);
            for (Avp a : avps) {
                if (!(a instanceof AvpImpl)) continue;
                AvpImpl aImpl = (AvpImpl)a;
                if (aImpl.rawData.length == 0 && aImpl.groupedData != null) {
                    aImpl.rawData = this.encodeAvpSet(a.getGrouped());
                }
                data.write(this.encodeAvp(aImpl));
            }
        }
        catch (Exception e) {
            logger.debug("Error during encode avps", (Throwable)e);
        }
        return out.toByteArray();
    }

    public byte[] encodeAvp(AvpImpl avp) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            DataOutputStream data = new DataOutputStream(out);
            data.writeInt(avp.getCode());
            byte flags = (byte)((avp.getVendorId() != 0L ? 128 : 0) | (avp.isMandatory() ? 64 : 0) | (avp.isEncrypted() ? 32 : 0));
            int origLength = avp.getRaw().length + 8 + (avp.getVendorId() != 0L ? 4 : 0);
            data.writeInt((flags << 24 & 0xFF000000) + origLength);
            if (avp.getVendorId() != 0L) {
                data.writeInt((int)avp.getVendorId());
            }
            data.write(avp.getRaw());
            if (avp.getRaw().length % 4 != 0) {
                for (int i = 0; i < 4 - avp.getRaw().length % 4; ++i) {
                    data.write(0);
                }
            }
        }
        catch (Exception e) {
            logger.debug("Error during encode avp", (Throwable)e);
        }
        return out.toByteArray();
    }
}

