/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.cca;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.auth.events.ReAuthAnswer;
import org.jdiameter.api.auth.events.ReAuthRequest;
import org.jdiameter.api.cca.ServerCCASession;
import org.jdiameter.api.cca.ServerCCASessionListener;
import org.jdiameter.api.cca.events.JCreditControlAnswer;
import org.jdiameter.api.cca.events.JCreditControlRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.cca.ICCAMessageFactory;
import org.jdiameter.common.api.app.cca.IServerCCASessionContext;
import org.jdiameter.common.api.app.cca.ServerCCASessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.auth.ReAuthAnswerImpl;
import org.jdiameter.common.impl.app.auth.ReAuthRequestImpl;
import org.jdiameter.common.impl.app.cca.AppCCASessionImpl;
import org.jdiameter.server.impl.app.cca.Event;
import org.jdiameter.server.impl.app.cca.IServerCCASessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerCCASessionImpl
extends AppCCASessionImpl
implements ServerCCASession,
NetworkReqListener,
EventListener<Request, Answer> {
    private static final Logger logger = LoggerFactory.getLogger(ServerCCASessionImpl.class);
    protected IServerCCASessionData sessionData;
    protected Lock sendAndStateLock = new ReentrantLock();
    protected transient ICCAMessageFactory factory = null;
    protected transient IServerCCASessionContext context = null;
    protected transient ServerCCASessionListener listener = null;
    protected static final String TCC_TIMER_NAME = "TCC_CCASERVER_TIMER";
    protected long[] authAppIds = new long[]{4L};

    public ServerCCASessionImpl(IServerCCASessionData data, ICCAMessageFactory fct, ISessionFactory sf, ServerCCASessionListener lst, IServerCCASessionContext ctx, StateChangeListener<AppSession> stLst) {
        super(sf, data);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("IServerCCASessionData can not be null");
        }
        if (fct.getApplicationIds() == null) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.sessionData = data;
        this.context = ctx;
        this.authAppIds = fct.getApplicationIds();
        this.listener = lst;
        this.factory = fct;
        super.addStateChangeNotification(stLst);
    }

    public void sendCreditControlAnswer(JCreditControlAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.handleEvent(new Event(false, null, answer));
    }

    public void sendReAuthRequest(ReAuthRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SENT_RAR, (AppRequestEvent)request, null);
    }

    public boolean isStateless() {
        return this.sessionData.isStateless();
    }

    public <E> E getState(Class<E> stateType) {
        return (E)(stateType == ServerCCASessionState.class ? this.sessionData.getServerCCASessionState() : null);
    }

    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        ServerCCASessionState newState = null;
        try {
            this.sendAndStateLock.lock();
            ServerCCASessionState state = this.sessionData.getServerCCASessionState();
            Event localEvent = (Event)event;
            Event.Type eventType = (Event.Type)localEvent.getType();
            block5 : switch (state) {
                case IDLE: {
                    JCreditControlAnswer answer;
                    switch (eventType) {
                        case RECEIVED_INITIAL: {
                            this.listener.doCreditControlRequest((ServerCCASession)this, (JCreditControlRequest)localEvent.getRequest());
                            break;
                        }
                        case RECEIVED_EVENT: {
                            this.listener.doCreditControlRequest((ServerCCASession)this, (JCreditControlRequest)localEvent.getRequest());
                            break;
                        }
                        case SENT_EVENT_RESPONSE: {
                            newState = ServerCCASessionState.IDLE;
                            this.dispatchEvent(localEvent.getAnswer());
                            this.setState(newState);
                            break;
                        }
                        case SENT_INITIAL_RESPONSE: {
                            answer = (JCreditControlAnswer)localEvent.getAnswer();
                            try {
                                long resultCode = answer.getResultCodeAvp().getUnsigned32();
                                if (this.isSuccess(resultCode)) {
                                    this.startTcc(answer.getValidityTimeAvp());
                                    newState = ServerCCASessionState.OPEN;
                                } else {
                                    newState = ServerCCASessionState.IDLE;
                                }
                                this.dispatchEvent(localEvent.getAnswer());
                                this.setState(newState);
                                break;
                            }
                            catch (AvpDataException e) {
                                throw new InternalException((Throwable)e);
                            }
                        }
                        case RECEIVED_UPDATE: 
                        case RECEIVED_TERMINATE: {
                            Answer errorAnswer = ((Request)localEvent.getRequest().getMessage()).createAnswer(5002L);
                            this.session.send((Message)errorAnswer);
                            logger.debug("Received an UPDATE or TERMINATE for a new session. Answering with 5002 (UNKNOWN_SESSION_ID) and terminating session.");
                        }
                        default: {
                            throw new InternalException("Wrong state: " + ServerCCASessionState.IDLE + " on event: " + (Object)((Object)eventType) + " " + localEvent.getRequest() + " " + localEvent.getAnswer());
                        }
                    }
                }
                case OPEN: {
                    JCreditControlAnswer answer;
                    switch (eventType) {
                        case RECEIVED_UPDATE: {
                            this.listener.doCreditControlRequest((ServerCCASession)this, (JCreditControlRequest)localEvent.getRequest());
                            break block5;
                        }
                        case SENT_UPDATE_RESPONSE: {
                            answer = (JCreditControlAnswer)localEvent.getAnswer();
                            try {
                                if (this.isSuccess(answer.getResultCodeAvp().getUnsigned32())) {
                                    this.startTcc(answer.getValidityTimeAvp());
                                }
                            }
                            catch (AvpDataException e) {
                                throw new InternalException((Throwable)e);
                            }
                            this.dispatchEvent(localEvent.getAnswer());
                            break block5;
                        }
                        case RECEIVED_TERMINATE: {
                            this.listener.doCreditControlRequest((ServerCCASession)this, (JCreditControlRequest)localEvent.getRequest());
                            break block5;
                        }
                        case SENT_TERMINATE_RESPONSE: {
                            answer = (JCreditControlAnswer)localEvent.getAnswer();
                            try {
                                if (this.isSuccess(answer.getResultCodeAvp().getUnsigned32())) {
                                    this.stopTcc(false);
                                }
                            }
                            catch (AvpDataException e) {
                                throw new InternalException((Throwable)e);
                            }
                            newState = ServerCCASessionState.IDLE;
                            this.dispatchEvent(localEvent.getAnswer());
                            this.setState(newState);
                            break block5;
                        }
                        case RECEIVED_RAA: {
                            this.listener.doReAuthAnswer((ServerCCASession)this, (ReAuthRequest)new ReAuthRequestImpl(localEvent.getRequest().getMessage()), (ReAuthAnswer)new ReAuthAnswerImpl((Answer)localEvent.getAnswer().getMessage()));
                            break block5;
                        }
                        case SENT_RAR: {
                            this.dispatchEvent(localEvent.getRequest());
                        }
                    }
                }
            }
            boolean bl = true;
            Object var10_14 = null;
            this.sendAndStateLock.unlock();
            return bl;
        }
        catch (Exception e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        }
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        this.context.timeoutExpired(request);
    }

    private void startTcc(Avp validityAvp) {
        long tccTimeout;
        if (validityAvp != null) {
            try {
                tccTimeout = 2L * validityAvp.getUnsigned32();
            }
            catch (AvpDataException e) {
                logger.debug("Unable to retrieve Validity-Time AVP value, using default.", (Throwable)e);
                tccTimeout = 2L * this.context.getDefaultValidityTime();
            }
        } else {
            tccTimeout = 2L * this.context.getDefaultValidityTime();
        }
        if (this.sessionData.getTccTimerId() != null) {
            this.stopTcc(true);
            this.sessionData.setTccTimerId(this.timerFacility.schedule(this.getSessionId(), TCC_TIMER_NAME, tccTimeout * 1000L));
            this.context.sessionSupervisionTimerReStarted(this, null);
        } else {
            this.sessionData.setTccTimerId(this.timerFacility.schedule(this.getSessionId(), TCC_TIMER_NAME, tccTimeout * 1000L));
            this.context.sessionSupervisionTimerStarted(this, null);
        }
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals(TCC_TIMER_NAME)) {
            new TccScheduledTask(this).run();
        }
    }

    private void stopTcc(boolean willRestart) {
        Serializable tccTimerId = this.sessionData.getTccTimerId();
        if (tccTimerId != null) {
            this.timerFacility.cancel(tccTimerId);
            this.sessionData.setTccTimerId(null);
            if (!willRestart) {
                this.context.sessionSupervisionTimerStopped(this, null);
            }
        }
    }

    protected boolean isProvisional(long resultCode) {
        return resultCode >= 1000L && resultCode < 2000L;
    }

    protected boolean isSuccess(long resultCode) {
        return resultCode >= 2000L && resultCode < 3000L;
    }

    protected void setState(ServerCCASessionState newState) {
        this.setState(newState, true);
    }

    protected void setState(ServerCCASessionState newState, boolean release) {
        ServerCCASessionState oldState = this.sessionData.getServerCCASessionState();
        this.sessionData.setServerCCASessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
        if (newState == ServerCCASessionState.IDLE) {
            this.stopTcc(false);
            if (release) {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                this.stopTcc(false);
                super.release();
                Object var2_1 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    protected void send(Event.Type type, AppRequestEvent request, AppAnswerEvent answer) throws InternalException {
        try {
            if (type != null) {
                this.handleEvent(new Event(type, request, answer));
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    protected void dispatchEvent(AppEvent event) throws InternalException {
        try {
            this.session.send(event.getMessage(), (EventListener)this);
        }
        catch (Exception e) {
            logger.debug("Failure trying to dispatch event", (Throwable)e);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerCCASessionImpl other = (ServerCCASessionImpl)obj;
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }

    public String toString() {
        return "ServerCCASessionImpl [sessionData=" + this.sessionData + "]";
    }

    private class AnswerDelivery
    implements Runnable {
        ServerCCASession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 258: {
                        ServerCCASessionImpl.this.handleEvent(new Event(Event.Type.RECEIVED_RAA, (AppRequestEvent)ServerCCASessionImpl.this.factory.createReAuthRequest(this.request), (AppAnswerEvent)ServerCCASessionImpl.this.factory.createReAuthAnswer(this.answer)));
                        break;
                    }
                    default: {
                        ServerCCASessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ServerCCASession session;
        Request request;

        private RequestDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 272: {
                        ServerCCASessionImpl.this.handleEvent(new Event(true, ServerCCASessionImpl.this.factory.createCreditControlRequest(this.request), null));
                        break;
                    }
                    default: {
                        ServerCCASessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }

    private class TccScheduledTask
    implements Runnable {
        ServerCCASession session = null;

        private TccScheduledTask(ServerCCASession session) {
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ServerCCASessionImpl.this.context.sessionSupervisionTimerExpired(this.session);
            try {
                ServerCCASessionImpl.this.sendAndStateLock.lock();
                ServerCCASessionImpl.this.sessionData.setTccTimerId(null);
                ServerCCASessionImpl.this.setState(ServerCCASessionState.IDLE);
                Object var2_1 = null;
                ServerCCASessionImpl.this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                ServerCCASessionImpl.this.sendAndStateLock.unlock();
                throw throwable;
            }
        }
    }
}

