/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.statistic;

import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.jdiameter.api.StatisticRecord;
import org.jdiameter.common.api.statistic.IStatisticRecord;

class StatisticRecordImpl
implements IStatisticRecord {
    protected boolean enable = true;
    protected String name;
    protected String description;
    protected IStatisticRecord.Counters counter;
    protected AtomicLong value;
    protected ConcurrentLinkedQueue<StatisticRecord> childs = new ConcurrentLinkedQueue();
    protected IStatisticRecord.ValueHolder valueHolder;

    public StatisticRecordImpl(String name) {
        this.name = name;
        this.value = new AtomicLong(0L);
    }

    public StatisticRecordImpl(String name, String description) {
        this(name);
        this.description = description;
    }

    public StatisticRecordImpl(String name, IStatisticRecord.Counters counter) {
        this(counter.name() + "." + name);
        this.counter = counter;
        this.description = counter.getDescription();
    }

    public StatisticRecordImpl(String name, String description, IStatisticRecord ... childs) {
        this(name, description);
        this.childs.addAll(Arrays.asList(childs));
    }

    public StatisticRecordImpl(String name, String description, IStatisticRecord.ValueHolder valueHolder) {
        this(name, description);
        this.valueHolder = valueHolder;
    }

    public StatisticRecordImpl(String name, String description, IStatisticRecord.ValueHolder valueHolder, IStatisticRecord ... childs) {
        this(name, description, valueHolder);
        this.childs.addAll(Arrays.asList(childs));
    }

    public StatisticRecordImpl(String name, String description, long value) {
        this(name, description);
        this.value = new AtomicLong(value);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValueAsInt() {
        return this.valueHolder != null ? ((IStatisticRecord.IntegerValueHolder)this.valueHolder).getValueAsInt() : (int)this.value.get();
    }

    public double getValueAsDouble() {
        return this.valueHolder != null ? ((IStatisticRecord.DoubleValueHolder)this.valueHolder).getValueAsDouble() : Double.longBitsToDouble(this.value.get());
    }

    public long getValueAsLong() {
        return this.valueHolder != null ? ((IStatisticRecord.LongValueHolder)this.valueHolder).getValueAsLong() : this.value.get();
    }

    public void inc() {
        if (this.enable) {
            this.value.incrementAndGet();
        }
    }

    public void inc(long delta) {
        if (this.enable) {
            this.value.addAndGet(delta);
        }
    }

    public void setDoubleValue(double value) {
        if (this.enable) {
            this.value.set(Double.doubleToLongBits(value));
        }
    }

    public void setLongValue(long value) {
        if (this.enable) {
            this.value.set(value);
        }
    }

    public void dec() {
        if (this.enable) {
            this.value.decrementAndGet();
        }
    }

    public StatisticRecord[] getChilds() {
        return this.childs.toArray(new StatisticRecord[0]);
    }

    public void reset() {
        this.value.set(0L);
    }

    public void enable(boolean e) {
        for (StatisticRecord r : this.childs) {
            r.enable(e);
        }
        this.enable = e;
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public String toString() {
        return String.valueOf(this.valueHolder != null ? this.valueHolder.getValueAsString() : Long.valueOf(this.value.get()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.counter == null ? 0 : this.counter.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatisticRecordImpl other = (StatisticRecordImpl)obj;
        if (this.counter != other.counter) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

