/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.jdiameter.api.Configuration;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.concurrent.IConcurrentEntityFactory;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.jdiameter.common.impl.concurrent.BaseThreadFactory;
import org.jdiameter.common.impl.concurrent.CommonScheduledExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentFactory
implements IConcurrentFactory {
    private BaseThreadFactory threadFactory;
    private Map<String, CommonScheduledExecutorService> scheduledExecutorServices;
    private Configuration[] config;
    private IStatisticManager statisticFactory;
    private IStatistic statistic;
    private IConcurrentEntityFactory entityFactory;

    public ConcurrentFactory(Configuration config, IStatisticManager statisticFactory, IConcurrentEntityFactory entityFactory) {
        this.config = config.getChildren(Parameters.Concurrent.ordinal());
        this.entityFactory = entityFactory;
        Configuration dgConfig = this.getConfigByName("ThreadGroup");
        String defThreadGroupName = dgConfig != null ? dgConfig.getStringValue(Parameters.ConcurrentEntityDescription.ordinal(), (String)Parameters.ConcurrentEntityDescription.defValue()) : (String)Parameters.ConcurrentEntityDescription.defValue();
        this.threadFactory = (BaseThreadFactory)entityFactory.newThreadFactory(defThreadGroupName);
        this.scheduledExecutorServices = new ConcurrentHashMap<String, CommonScheduledExecutorService>();
        IStatisticRecord threadCount = statisticFactory.newCounterRecord(IStatisticRecord.Counters.ConcurrentThread, new IStatisticRecord.IntegerValueHolder(){

            public String getValueAsString() {
                return this.getValueAsInt() + "";
            }

            public int getValueAsInt() {
                return ConcurrentFactory.this.getThreadGroup().activeCount();
            }
        });
        IStatisticRecord schedExeServiceCount = statisticFactory.newCounterRecord(IStatisticRecord.Counters.ConcurrentScheduledExecutedServices, new IStatisticRecord.IntegerValueHolder(){

            public String getValueAsString() {
                return this.getValueAsInt() + "";
            }

            public int getValueAsInt() {
                return ConcurrentFactory.this.scheduledExecutorServices.size();
            }
        });
        this.statistic = statisticFactory.newStatistic("scheduled", IStatistic.Groups.Concurrent, threadCount, schedExeServiceCount);
        this.statisticFactory = statisticFactory;
    }

    private Configuration getConfigByName(String name) {
        if (this.config != null) {
            for (Configuration c : this.config) {
                if (c == null || !c.getStringValue(Parameters.ConcurrentEntityName.ordinal(), "").equals(name)) continue;
                return c;
            }
        }
        return null;
    }

    @Override
    public Thread getThread(Runnable runnable) {
        return this.threadFactory.newThread(runnable);
    }

    @Override
    public Thread getThread(String namePrefix, Runnable runnuble) {
        return this.threadFactory.newThread(namePrefix, runnuble);
    }

    @Override
    public List<Thread> getThreads() {
        Thread[] threads = new Thread[this.threadFactory.getThreadGroup().activeCount()];
        this.threadFactory.getThreadGroup().enumerate(threads);
        return Arrays.asList(threads);
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.threadFactory.getThreadGroup();
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService(String name) {
        CommonScheduledExecutorService service = null;
        if (!this.scheduledExecutorServices.containsKey(name)) {
            service = new CommonScheduledExecutorService(name, this.getConfigByName(name), this.entityFactory, this.statisticFactory);
            this.scheduledExecutorServices.put(name, service);
        } else {
            service = this.scheduledExecutorServices.get(name);
        }
        return service;
    }

    @Override
    public Collection<ScheduledExecutorService> getScheduledExecutorServices() {
        ArrayList<ScheduledExecutorService> external = new ArrayList<ScheduledExecutorService>(this.scheduledExecutorServices.values());
        return external;
    }

    @Override
    public void shutdownNow(ScheduledExecutorService service) {
        for (String name : this.scheduledExecutorServices.keySet()) {
            ExecutorService e = this.scheduledExecutorServices.get(name);
            if (e != service) continue;
            e.shutdownNow();
            this.scheduledExecutorServices.remove(name);
            break;
        }
    }

    @Override
    public IStatistic getStatistic() {
        return this.statistic;
    }

    @Override
    public List<IStatistic> getStatistics() {
        ArrayList<IStatistic> statistics = new ArrayList<IStatistic>();
        for (CommonScheduledExecutorService e : this.scheduledExecutorServices.values()) {
            statistics.add(e.getStatistic());
        }
        return statistics;
    }

    @Override
    public void shutdownAllNow() {
        for (String name : this.scheduledExecutorServices.keySet()) {
            ExecutorService e = this.scheduledExecutorServices.remove(name);
            e.shutdownNow();
        }
    }
}

