/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.ro;

import java.util.concurrent.ScheduledFuture;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.auth.events.ReAuthAnswer;
import org.jdiameter.api.auth.events.ReAuthRequest;
import org.jdiameter.api.ro.ClientRoSession;
import org.jdiameter.api.ro.ClientRoSessionListener;
import org.jdiameter.api.ro.ServerRoSession;
import org.jdiameter.api.ro.ServerRoSessionListener;
import org.jdiameter.api.ro.events.RoCreditControlAnswer;
import org.jdiameter.api.ro.events.RoCreditControlRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.ro.ClientRoSessionImpl;
import org.jdiameter.client.impl.app.ro.IClientRoSessionData;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.ro.IClientRoSessionContext;
import org.jdiameter.common.api.app.ro.IRoMessageFactory;
import org.jdiameter.common.api.app.ro.IRoSessionData;
import org.jdiameter.common.api.app.ro.IRoSessionFactory;
import org.jdiameter.common.api.app.ro.IServerRoSessionContext;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.auth.ReAuthAnswerImpl;
import org.jdiameter.common.impl.app.auth.ReAuthRequestImpl;
import org.jdiameter.common.impl.app.ro.AppRoSessionImpl;
import org.jdiameter.common.impl.app.ro.RoCreditControlAnswerImpl;
import org.jdiameter.common.impl.app.ro.RoCreditControlRequestImpl;
import org.jdiameter.server.impl.app.ro.IServerRoSessionData;
import org.jdiameter.server.impl.app.ro.ServerRoSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoSessionFactoryImpl
implements IRoSessionFactory,
ClientRoSessionListener,
ServerRoSessionListener,
StateChangeListener<AppSession>,
IRoMessageFactory,
IServerRoSessionContext,
IClientRoSessionContext {
    protected int defaultDirectDebitingFailureHandling = 0;
    protected int defaultCreditControlFailureHandling = 0;
    protected long defaultValidityTime = 60L;
    protected long defaultTxTimerValue = 30L;
    protected ClientRoSessionListener clientSessionListener;
    protected ServerRoSessionListener serverSessionListener;
    protected StateChangeListener<AppSession> stateListener;
    protected IServerRoSessionContext serverContextListener;
    protected IClientRoSessionContext clientContextListener;
    protected IRoMessageFactory messageFactory;
    protected Logger logger = LoggerFactory.getLogger(RoSessionFactoryImpl.class);
    protected ISessionDatasource iss;
    protected IAppSessionDataFactory<IRoSessionData> sessionDataFactory;
    protected ISessionFactory sessionFactory = null;

    public RoSessionFactoryImpl(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
        this.iss = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        this.sessionDataFactory = this.iss.getDataFactory(IRoSessionData.class);
    }

    public RoSessionFactoryImpl(SessionFactory sessionFactory, int defaultDirectDebitingFailureHandling, int defaultCreditControlFailureHandling, long defaultValidityTime, long defaultTxTimerValue) {
        this(sessionFactory);
        this.defaultDirectDebitingFailureHandling = defaultDirectDebitingFailureHandling;
        this.defaultCreditControlFailureHandling = defaultCreditControlFailureHandling;
        this.defaultValidityTime = defaultValidityTime;
        this.defaultTxTimerValue = defaultTxTimerValue;
    }

    @Override
    public ClientRoSessionListener getClientSessionListener() {
        if (this.clientSessionListener != null) {
            return this.clientSessionListener;
        }
        return this;
    }

    @Override
    public void setClientSessionListener(ClientRoSessionListener clientSessionListener) {
        this.clientSessionListener = clientSessionListener;
    }

    @Override
    public ServerRoSessionListener getServerSessionListener() {
        if (this.serverSessionListener != null) {
            return this.serverSessionListener;
        }
        return this;
    }

    @Override
    public void setServerSessionListener(ServerRoSessionListener serverSessionListener) {
        this.serverSessionListener = serverSessionListener;
    }

    @Override
    public IServerRoSessionContext getServerContextListener() {
        if (this.serverContextListener != null) {
            return this.serverContextListener;
        }
        return this;
    }

    @Override
    public void setServerContextListener(IServerRoSessionContext serverContextListener) {
        this.serverContextListener = serverContextListener;
    }

    @Override
    public IClientRoSessionContext getClientContextListener() {
        if (this.clientContextListener != null) {
            return this.clientContextListener;
        }
        return this;
    }

    @Override
    public IRoMessageFactory getMessageFactory() {
        if (this.messageFactory != null) {
            return this.messageFactory;
        }
        return this;
    }

    @Override
    public void setMessageFactory(IRoMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public void setClientContextListener(IClientRoSessionContext clientContextListener) {
        this.clientContextListener = clientContextListener;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
    }

    @Override
    public StateChangeListener<AppSession> getStateListener() {
        if (this.stateListener != null) {
            return this.stateListener;
        }
        return this;
    }

    @Override
    public void setStateListener(StateChangeListener<AppSession> stateListener) {
        this.stateListener = stateListener;
    }

    @Override
    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        AppRoSessionImpl appSession;
        block10: {
            appSession = null;
            try {
                if (aClass == ClientRoSession.class) {
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    ClientRoSessionImpl clientSession = null;
                    IClientRoSessionData sessionData = (IClientRoSessionData)this.sessionDataFactory.getAppSessionData(ClientRoSession.class, sessionId);
                    sessionData.setApplicationId(applicationId);
                    clientSession = new ClientRoSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener(), this.getClientContextListener(), this.getStateListener());
                    this.iss.addSession((BaseSession)clientSession);
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block10;
                }
                if (aClass == ServerRoSession.class) {
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    IServerRoSessionData sessionData = (IServerRoSessionData)this.sessionDataFactory.getAppSessionData(ServerRoSession.class, sessionId);
                    sessionData.setApplicationId(applicationId);
                    ServerRoSessionImpl serverSession = new ServerRoSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener(), this.getServerContextListener(), this.getStateListener());
                    this.iss.addSession((BaseSession)serverSession);
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block10;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ClientRoSession.class + "," + ServerRoSession.class + "]");
            }
            catch (Exception e) {
                this.logger.error("Failure to obtain new Ro Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    @Override
    public AppSession getSession(String sessionId, Class<? extends AppSession> aClass) {
        AppRoSessionImpl appSession;
        block6: {
            appSession = null;
            if (sessionId == null) {
                throw new IllegalArgumentException("Session-Id must not be null");
            }
            if (!this.iss.exists(sessionId)) {
                return null;
            }
            try {
                if (aClass == ClientRoSession.class) {
                    IClientRoSessionData sessionData = (IClientRoSessionData)this.sessionDataFactory.getAppSessionData(ClientRoSession.class, sessionId);
                    ClientRoSessionImpl clientSession = new ClientRoSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener(), this.getClientContextListener(), this.getStateListener());
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block6;
                }
                if (aClass == ServerRoSession.class) {
                    IServerRoSessionData sessionData = (IServerRoSessionData)this.sessionDataFactory.getAppSessionData(ServerRoSession.class, sessionId);
                    ServerRoSessionImpl serverSession = new ServerRoSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener(), this.getServerContextListener(), this.getStateListener());
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block6;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ClientRoSession.class + "," + ServerRoSession.class + "]");
            }
            catch (Exception e) {
                this.logger.error("Failure to obtain new Credit-Control Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    public void doCreditControlRequest(ServerRoSession session, RoCreditControlRequest request) throws InternalException {
    }

    public void doCreditControlAnswer(ClientRoSession session, RoCreditControlRequest request, RoCreditControlAnswer answer) throws InternalException {
    }

    public void doReAuthRequest(ClientRoSession session, ReAuthRequest request) throws InternalException {
    }

    public void doReAuthAnswer(ServerRoSession session, ReAuthRequest request, ReAuthAnswer answer) throws InternalException {
    }

    public void doOtherEvent(AppSession session, AppRequestEvent request, AppAnswerEvent answer) throws InternalException {
    }

    @Override
    public RoCreditControlAnswer createCreditControlAnswer(Answer answer) {
        return new RoCreditControlAnswerImpl(answer);
    }

    @Override
    public RoCreditControlRequest createCreditControlRequest(Request req) {
        return new RoCreditControlRequestImpl(req);
    }

    @Override
    public ReAuthAnswer createReAuthAnswer(Answer answer) {
        return new ReAuthAnswerImpl(answer);
    }

    @Override
    public ReAuthRequest createReAuthRequest(Request req) {
        return new ReAuthRequestImpl((Message)req);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        this.logger.info("Diameter Ro SessionFactory :: stateChanged :: oldState[{}], newState[{}]", (Object)oldState, (Object)newState);
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.logger.info("Diameter Ro SessionFactory :: stateChanged :: source[{}], oldState[{}], newState[{}]", new Object[]{source, oldState, newState});
    }

    @Override
    public void sessionSupervisionTimerExpired(ServerRoSession session) {
        session.release();
    }

    @Override
    public void sessionSupervisionTimerReStarted(ServerRoSession session, ScheduledFuture future) {
    }

    @Override
    public void sessionSupervisionTimerStarted(ServerRoSession session, ScheduledFuture future) {
    }

    @Override
    public void sessionSupervisionTimerStopped(ServerRoSession session, ScheduledFuture future) {
    }

    @Override
    public void timeoutExpired(Request request) {
    }

    @Override
    public void denyAccessOnDeliverFailure(ClientRoSession clientRoSessionImpl, Message request) {
    }

    @Override
    public void denyAccessOnFailureMessage(ClientRoSession clientRoSessionImpl) {
    }

    @Override
    public void denyAccessOnTxExpire(ClientRoSession clientRoSessionImpl) {
        clientRoSessionImpl.release();
    }

    @Override
    public int getDefaultCCFHValue() {
        return this.defaultCreditControlFailureHandling;
    }

    @Override
    public int getDefaultDDFHValue() {
        return this.defaultDirectDebitingFailureHandling;
    }

    @Override
    public long getDefaultTxTimerValue() {
        return this.defaultTxTimerValue;
    }

    @Override
    public void grantAccessOnDeliverFailure(ClientRoSession clientRoSessionImpl, Message request) {
    }

    @Override
    public void grantAccessOnFailureMessage(ClientRoSession clientRoSessionImpl) {
    }

    @Override
    public void grantAccessOnTxExpire(ClientRoSession clientRoSessionImpl) {
    }

    @Override
    public void indicateServiceError(ClientRoSession clientRoSessionImpl) {
    }

    @Override
    public void txTimerExpired(ClientRoSession session) {
        session.release();
    }

    @Override
    public long[] getApplicationIds() {
        return new long[]{4L};
    }

    @Override
    public long getDefaultValidityTime() {
        return this.defaultValidityTime;
    }
}

