/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.cca;

import java.util.concurrent.ScheduledFuture;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.auth.events.ReAuthAnswer;
import org.jdiameter.api.auth.events.ReAuthRequest;
import org.jdiameter.api.cca.ClientCCASession;
import org.jdiameter.api.cca.ClientCCASessionListener;
import org.jdiameter.api.cca.ServerCCASession;
import org.jdiameter.api.cca.ServerCCASessionListener;
import org.jdiameter.api.cca.events.JCreditControlAnswer;
import org.jdiameter.api.cca.events.JCreditControlRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.cca.ClientCCASessionImpl;
import org.jdiameter.client.impl.app.cca.IClientCCASessionData;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.cca.ICCAMessageFactory;
import org.jdiameter.common.api.app.cca.ICCASessionData;
import org.jdiameter.common.api.app.cca.ICCASessionFactory;
import org.jdiameter.common.api.app.cca.IClientCCASessionContext;
import org.jdiameter.common.api.app.cca.IServerCCASessionContext;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.auth.ReAuthAnswerImpl;
import org.jdiameter.common.impl.app.auth.ReAuthRequestImpl;
import org.jdiameter.common.impl.app.cca.AppCCASessionImpl;
import org.jdiameter.common.impl.app.cca.CCALocalSessionDataFactory;
import org.jdiameter.common.impl.app.cca.JCreditControlAnswerImpl;
import org.jdiameter.common.impl.app.cca.JCreditControlRequestImpl;
import org.jdiameter.server.impl.app.cca.IServerCCASessionData;
import org.jdiameter.server.impl.app.cca.ServerCCASessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCASessionFactoryImpl
implements ICCASessionFactory,
ClientCCASessionListener,
ServerCCASessionListener,
StateChangeListener<AppSession>,
ICCAMessageFactory,
IServerCCASessionContext,
IClientCCASessionContext {
    protected int defaultDirectDebitingFailureHandling = 0;
    protected int defaultCreditControlFailureHandling = 0;
    protected long defaultValidityTime = 60L;
    protected long defaultTxTimerValue = 30L;
    protected ClientCCASessionListener clientSessionListener;
    protected ServerCCASessionListener serverSessionListener;
    protected StateChangeListener<AppSession> stateListener;
    protected IServerCCASessionContext serverContextListener;
    protected IClientCCASessionContext clientContextListener;
    protected ICCAMessageFactory messageFactory;
    protected Logger logger = LoggerFactory.getLogger(CCASessionFactoryImpl.class);
    protected ISessionDatasource iss;
    protected ISessionFactory sessionFactory = null;
    protected IAppSessionDataFactory<ICCASessionData> sessionDataFactory;

    public CCASessionFactoryImpl() {
    }

    public CCASessionFactoryImpl(SessionFactory sessionFactory) {
        this.init(sessionFactory);
    }

    public void init(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
        this.iss = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        this.sessionDataFactory = this.iss.getDataFactory(ICCASessionData.class);
        if (this.sessionDataFactory == null) {
            this.logger.debug("No factory for CCA Application data, using default/local.");
            this.sessionDataFactory = new CCALocalSessionDataFactory();
        }
    }

    public CCASessionFactoryImpl(SessionFactory sessionFactory, int defaultDirectDebitingFailureHandling, int defaultCreditControlFailureHandling, long defaultValidityTime, long defaultTxTimerValue) {
        this(sessionFactory);
        this.defaultDirectDebitingFailureHandling = defaultDirectDebitingFailureHandling;
        this.defaultCreditControlFailureHandling = defaultCreditControlFailureHandling;
        this.defaultValidityTime = defaultValidityTime;
        this.defaultTxTimerValue = defaultTxTimerValue;
    }

    @Override
    public ClientCCASessionListener getClientSessionListener() {
        if (this.clientSessionListener != null) {
            return this.clientSessionListener;
        }
        return this;
    }

    @Override
    public void setClientSessionListener(ClientCCASessionListener clientSessionListener) {
        this.clientSessionListener = clientSessionListener;
    }

    @Override
    public ServerCCASessionListener getServerSessionListener() {
        if (this.serverSessionListener != null) {
            return this.serverSessionListener;
        }
        return this;
    }

    @Override
    public void setServerSessionListener(ServerCCASessionListener serverSessionListener) {
        this.serverSessionListener = serverSessionListener;
    }

    @Override
    public IServerCCASessionContext getServerContextListener() {
        if (this.serverContextListener != null) {
            return this.serverContextListener;
        }
        return this;
    }

    @Override
    public void setServerContextListener(IServerCCASessionContext serverContextListener) {
        this.serverContextListener = serverContextListener;
    }

    @Override
    public IClientCCASessionContext getClientContextListener() {
        if (this.clientContextListener != null) {
            return this.clientContextListener;
        }
        return this;
    }

    @Override
    public ICCAMessageFactory getMessageFactory() {
        if (this.messageFactory != null) {
            return this.messageFactory;
        }
        return this;
    }

    @Override
    public void setMessageFactory(ICCAMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public void setClientContextListener(IClientCCASessionContext clientContextListener) {
        this.clientContextListener = clientContextListener;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
    }

    @Override
    public StateChangeListener<AppSession> getStateListener() {
        if (this.stateListener != null) {
            return this.stateListener;
        }
        return this;
    }

    @Override
    public void setStateListener(StateChangeListener<AppSession> stateListener) {
        this.stateListener = stateListener;
    }

    @Override
    public AppSession getSession(String sessionId, Class<? extends AppSession> aClass) {
        AppCCASessionImpl appSession;
        block6: {
            if (sessionId == null) {
                throw new IllegalArgumentException("SessionId must not be null");
            }
            if (!this.iss.exists(sessionId)) {
                return null;
            }
            appSession = null;
            try {
                if (aClass == ClientCCASession.class) {
                    ClientCCASessionImpl clientSession = null;
                    IClientCCASessionData data = (IClientCCASessionData)this.sessionDataFactory.getAppSessionData(ClientCCASession.class, sessionId);
                    clientSession = new ClientCCASessionImpl(data, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener(), this.getClientContextListener(), this.getStateListener());
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block6;
                }
                if (aClass == ServerCCASession.class) {
                    ServerCCASessionImpl serverSession = null;
                    IServerCCASessionData data = (IServerCCASessionData)this.sessionDataFactory.getAppSessionData(ServerCCASession.class, sessionId);
                    serverSession = new ServerCCASessionImpl(data, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener(), this.getServerContextListener(), this.getStateListener());
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block6;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ClientCCASession.class + "," + ServerCCASession.class + "]");
            }
            catch (Exception e) {
                this.logger.error("Failure to obtain new Credit-Control Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    @Override
    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        AppCCASessionImpl appSession;
        block10: {
            appSession = null;
            try {
                if (aClass == ClientCCASession.class) {
                    ClientCCASessionImpl clientSession = null;
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    IClientCCASessionData data = (IClientCCASessionData)this.sessionDataFactory.getAppSessionData(ClientCCASession.class, sessionId);
                    data.setApplicationId(applicationId);
                    clientSession = new ClientCCASessionImpl(data, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener(), this.getClientContextListener(), this.getStateListener());
                    this.iss.addSession((BaseSession)clientSession);
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block10;
                }
                if (aClass == ServerCCASession.class) {
                    ServerCCASessionImpl serverSession = null;
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    IServerCCASessionData data = (IServerCCASessionData)this.sessionDataFactory.getAppSessionData(ServerCCASession.class, sessionId);
                    data.setApplicationId(applicationId);
                    serverSession = new ServerCCASessionImpl(data, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener(), this.getServerContextListener(), this.getStateListener());
                    this.iss.addSession((BaseSession)serverSession);
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block10;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ClientCCASession.class + "," + ServerCCASession.class + "]");
            }
            catch (Exception e) {
                this.logger.error("Failure to obtain new Credit-Control Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    public void doCreditControlRequest(ServerCCASession session, JCreditControlRequest request) throws InternalException {
    }

    public void doCreditControlAnswer(ClientCCASession session, JCreditControlRequest request, JCreditControlAnswer answer) throws InternalException {
    }

    public void doReAuthRequest(ClientCCASession session, ReAuthRequest request) throws InternalException {
    }

    public void doReAuthAnswer(ServerCCASession session, ReAuthRequest request, ReAuthAnswer answer) throws InternalException {
    }

    public void doOtherEvent(AppSession session, AppRequestEvent request, AppAnswerEvent answer) throws InternalException {
    }

    @Override
    public JCreditControlAnswer createCreditControlAnswer(Answer answer) {
        return new JCreditControlAnswerImpl(answer);
    }

    @Override
    public JCreditControlRequest createCreditControlRequest(Request req) {
        return new JCreditControlRequestImpl(req);
    }

    @Override
    public ReAuthAnswer createReAuthAnswer(Answer answer) {
        return new ReAuthAnswerImpl(answer);
    }

    @Override
    public ReAuthRequest createReAuthRequest(Request req) {
        return new ReAuthRequestImpl((Message)req);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        this.logger.info("Diameter CCA SessionFactory :: stateChanged :: oldState[{}], newState[{}]", (Object)oldState, (Object)newState);
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.logger.info("Diameter CCA SessionFactory :: stateChanged :: source[{}], oldState[{}], newState[{}]", new Object[]{source, oldState, newState});
    }

    @Override
    public void sessionSupervisionTimerExpired(ServerCCASession session) {
        session.release();
    }

    @Override
    public void sessionSupervisionTimerReStarted(ServerCCASession session, ScheduledFuture future) {
    }

    @Override
    public void sessionSupervisionTimerStarted(ServerCCASession session, ScheduledFuture future) {
    }

    @Override
    public void sessionSupervisionTimerStopped(ServerCCASession session, ScheduledFuture future) {
    }

    @Override
    public void timeoutExpired(Request request) {
    }

    @Override
    public void denyAccessOnDeliverFailure(ClientCCASession clientCCASessionImpl, Message request) {
    }

    @Override
    public void denyAccessOnFailureMessage(ClientCCASession clientCCASessionImpl) {
    }

    @Override
    public void denyAccessOnTxExpire(ClientCCASession clientCCASessionImpl) {
        clientCCASessionImpl.release();
    }

    @Override
    public int getDefaultCCFHValue() {
        return this.defaultCreditControlFailureHandling;
    }

    @Override
    public int getDefaultDDFHValue() {
        return this.defaultDirectDebitingFailureHandling;
    }

    @Override
    public long getDefaultTxTimerValue() {
        return this.defaultTxTimerValue;
    }

    @Override
    public void grantAccessOnDeliverFailure(ClientCCASession clientCCASessionImpl, Message request) {
    }

    @Override
    public void grantAccessOnFailureMessage(ClientCCASession clientCCASessionImpl) {
    }

    @Override
    public void grantAccessOnTxExpire(ClientCCASession clientCCASessionImpl) {
    }

    @Override
    public void indicateServiceError(ClientCCASession clientCCASessionImpl) {
    }

    @Override
    public void txTimerExpired(ClientCCASession session) {
        session.release();
    }

    @Override
    public long[] getApplicationIds() {
        return new long[]{4L};
    }

    @Override
    public long getDefaultValidityTime() {
        return this.defaultValidityTime;
    }
}

