/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.sh;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.sh.ServerShSession;
import org.jdiameter.api.sh.ServerShSessionListener;
import org.jdiameter.api.sh.events.ProfileUpdateAnswer;
import org.jdiameter.api.sh.events.ProfileUpdateRequest;
import org.jdiameter.api.sh.events.PushNotificationAnswer;
import org.jdiameter.api.sh.events.PushNotificationRequest;
import org.jdiameter.api.sh.events.SubscribeNotificationsAnswer;
import org.jdiameter.api.sh.events.SubscribeNotificationsRequest;
import org.jdiameter.api.sh.events.UserDataAnswer;
import org.jdiameter.api.sh.events.UserDataRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.sh.IShMessageFactory;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.sh.ShSession;
import org.jdiameter.server.impl.app.sh.Event;
import org.jdiameter.server.impl.app.sh.IShServerSessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShServerSessionImpl
extends ShSession
implements ServerShSession,
EventListener<Request, Answer>,
NetworkReqListener {
    private Logger logger = LoggerFactory.getLogger(ShServerSessionImpl.class);
    protected Lock sendAndStateLock = new ReentrantLock();
    protected transient IShMessageFactory factory = null;
    protected transient ServerShSessionListener listener;
    protected IShServerSessionData sessionData;
    protected long appId;

    public ShServerSessionImpl(IShServerSessionData sessionData, IShMessageFactory fct, ISessionFactory sf, ServerShSessionListener lst) {
        super(sf, sessionData);
        if (sessionData == null) {
            throw new NullPointerException("SessionData must not be null");
        }
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationId() < 0L) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.sessionData = sessionData;
        this.appId = fct.getApplicationId();
        this.listener = lst;
        this.factory = fct;
    }

    public void sendProfileUpdateAnswer(ProfileUpdateAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_PROFILE_UPDATE_ANSWER, null, (AppEvent)answer);
    }

    public void sendPushNotificationRequest(PushNotificationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_PUSH_NOTIFICATION_REQUEST, (AppEvent)request, null);
    }

    public void sendSubscribeNotificationsAnswer(SubscribeNotificationsAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_SUBSCRIBE_NOTIFICATIONS_ANSWER, null, (AppEvent)answer);
    }

    public void sendUserDataAnswer(UserDataAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_USER_DATA_ANSWER, null, (AppEvent)answer);
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeoutExpired(Request request) {
        try {
            this.sendAndStateLock.lock();
            if (request.getApplicationId() == this.appId && request.getCommandCode() == 309) {
                this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, (AppEvent)this.factory.createPushNotificationRequest(request), null));
                return;
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to process timeout message", (Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public <E> E getState(Class<E> stateType) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            Event localEvent = (Event)event;
            switch ((Event.Type)localEvent.getType()) {
                case RECEIVE_PROFILE_UPDATE_REQUEST: {
                    this.listener.doProfileUpdateRequestEvent((ServerShSession)this, (ProfileUpdateRequest)localEvent.getRequest());
                    return true;
                }
                case RECEIVE_PUSH_NOTIFICATION_ANSWER: {
                    this.listener.doPushNotificationAnswerEvent((ServerShSession)this, (PushNotificationRequest)localEvent.getRequest(), (PushNotificationAnswer)localEvent.getAnswer());
                    return true;
                }
                case RECEIVE_SUBSCRIBE_NOTIFICATIONS_REQUEST: {
                    this.listener.doSubscribeNotificationsRequestEvent((ServerShSession)this, (SubscribeNotificationsRequest)localEvent.getRequest());
                    return true;
                }
                case RECEIVE_USER_DATA_REQUEST: {
                    this.listener.doUserDataRequestEvent((ServerShSession)this, (UserDataRequest)localEvent.getRequest());
                    return true;
                }
                case SEND_PROFILE_UPDATE_ANSWER: {
                    this.dispatchEvent(localEvent.getAnswer());
                    return true;
                }
                case SEND_PUSH_NOTIFICATION_REQUEST: {
                    this.dispatchEvent(localEvent.getRequest());
                    return true;
                }
                case SEND_SUBSCRIBE_NOTIFICATIONS_ANSWER: {
                    this.dispatchEvent(localEvent.getAnswer());
                    return true;
                }
                case SEND_USER_DATA_ANSWER: {
                    this.dispatchEvent(localEvent.getAnswer());
                    return true;
                }
                case TIMEOUT_EXPIRES: {
                    return true;
                }
                default: {
                    this.logger.error("Wrong message type = {} req = {} ans = {}", new Object[]{localEvent.getType(), localEvent.getRequest(), localEvent.getAnswer()});
                    return true;
                }
            }
        }
        catch (IllegalDiameterStateException idse) {
            throw new InternalException((Throwable)idse);
        }
        catch (RouteException re) {
            throw new InternalException((Throwable)re);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public boolean isStateless() {
        return true;
    }

    protected void send(Event.Type type, AppEvent request, AppEvent answer) throws InternalException {
        try {
            this.sendAndStateLock.lock();
            if (type != null) {
                this.handleEvent(new Event(type, request, answer));
            }
        }
        catch (Exception exc) {
            throw new InternalException((Throwable)exc);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    protected void dispatchEvent(AppEvent event) throws InternalException {
        try {
            this.session.send(event.getMessage(), (EventListener)this);
        }
        catch (Exception e) {
            this.logger.debug("Failed to dispatch event", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
            }
            catch (Exception e) {
                this.logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            this.logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    protected long extractExpiryTime(Message answer) {
        try {
            Avp expiryTimeAvp = answer.getAvps().getAvp(709);
            return expiryTimeAvp != null ? expiryTimeAvp.getTime().getTime() : -1L;
        }
        catch (AvpDataException ade) {
            this.logger.debug("Failure trying to extract Expiry-Time AVP value", (Throwable)ade);
            return -1L;
        }
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.appId ^ this.appId >>> 32);
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShServerSessionImpl other = (ShServerSessionImpl)obj;
        if (this.appId != other.appId) {
            return false;
        }
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }

    @Override
    public void onTimer(String timerName) {
        this.logger.trace("onTimer({})", (Object)timerName);
    }

    private class AnswerDelivery
    implements Runnable {
        ServerShSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ShServerSessionImpl.this.sendAndStateLock.lock();
                if (this.request.getApplicationId() == ShServerSessionImpl.this.appId) {
                    if (this.request.getCommandCode() == 309) {
                        ShServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_PUSH_NOTIFICATION_ANSWER, (AppEvent)ShServerSessionImpl.this.factory.createPushNotificationRequest(this.request), (AppEvent)ShServerSessionImpl.this.factory.createPushNotificationAnswer(this.answer)));
                        return;
                    }
                    ShServerSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                } else {
                    ShServerSessionImpl.this.logger.warn("Message with Application-Id {} reached Application Session with Application-Id {}. Skipping.", (Object)this.request.getApplicationId(), (Object)ShServerSessionImpl.this.appId);
                }
            }
            catch (Exception e) {
                ShServerSessionImpl.this.logger.debug("Failed to process success message", (Throwable)e);
            }
            finally {
                ShServerSessionImpl.this.sendAndStateLock.unlock();
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ServerShSession session;
        Request request;

        private RequestDelivery() {
        }

        @Override
        public void run() {
            try {
                if (this.request.getApplicationId() == ShServerSessionImpl.this.appId) {
                    if (this.request.getCommandCode() == 308) {
                        ShServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_SUBSCRIBE_NOTIFICATIONS_REQUEST, (AppEvent)ShServerSessionImpl.this.factory.createSubscribeNotificationsRequest(this.request), null));
                    } else if (this.request.getCommandCode() == 306) {
                        ShServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_USER_DATA_REQUEST, (AppEvent)ShServerSessionImpl.this.factory.createUserDataRequest(this.request), null));
                    } else if (this.request.getCommandCode() == 307) {
                        ShServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_PROFILE_UPDATE_REQUEST, (AppEvent)ShServerSessionImpl.this.factory.createProfileUpdateRequest(this.request), null));
                    } else {
                        ShServerSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                    }
                }
            }
            catch (Exception e) {
                ShServerSessionImpl.this.logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }
}

