/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.rx;

import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.StateEvent;

public class Event
implements StateEvent {
    Type type;
    AppRequestEvent request;
    AppAnswerEvent answer;

    Event(Type type) {
        this.type = type;
    }

    Event(Type type, AppRequestEvent request, AppAnswerEvent answer) {
        this.type = type;
        this.answer = answer;
        this.request = request;
    }

    Event(boolean isRequest, AppRequestEvent request, AppAnswerEvent answer) {
        block15: {
            block14: {
                this.answer = answer;
                this.request = request;
                if (!isRequest) break block14;
                switch (request.getCommandCode()) {
                    case 258: {
                        this.type = Type.SEND_RAR;
                        break block15;
                    }
                    case 274: {
                        this.type = Type.SEND_ASR;
                        break block15;
                    }
                    case 265: {
                        this.type = Type.RECEIVE_AAR;
                        break block15;
                    }
                    case 275: {
                        this.type = Type.RECEIVE_STR;
                        break block15;
                    }
                    case 5: {
                        this.type = Type.RECEIVE_EVENT_REQUEST;
                        break block15;
                    }
                    default: {
                        throw new RuntimeException("Wrong command code value: " + request.getCommandCode());
                    }
                }
            }
            switch (answer.getCommandCode()) {
                case 274: {
                    this.type = Type.RECEIVE_ASA;
                    break;
                }
                case 258: {
                    this.type = Type.RECEIVE_RAA;
                    break;
                }
                case 265: {
                    this.type = Type.SEND_AAA;
                    break;
                }
                case 275: {
                    this.type = Type.SEND_STA;
                    break;
                }
                case 6: {
                    this.type = Type.SEND_EVENT_ANSWER;
                    break;
                }
                default: {
                    throw new RuntimeException("Wrong CC-Request-Type value: " + answer.getCommandCode());
                }
            }
        }
    }

    public <E> E encodeType(Class<E> eClass) {
        return (E)((Object)(eClass == Type.class ? this.type : null));
    }

    public Enum getType() {
        return this.type;
    }

    public int compareTo(Object o) {
        return 0;
    }

    public Object getData() {
        return this.request != null ? this.request : this.answer;
    }

    public void setData(Object data) {
    }

    public AppEvent getRequest() {
        return this.request;
    }

    public AppEvent getAnswer() {
        return this.answer;
    }

    public static enum Type {
        SEND_AAA,
        RECEIVE_AAR,
        SEND_STA,
        RECEIVE_STR,
        SEND_RAR,
        RECEIVE_RAA,
        SEND_ASR,
        RECEIVE_ASA,
        SEND_EVENT_ANSWER,
        RECEIVE_EVENT_REQUEST;

    }
}

