/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.rf;

import java.io.Serializable;
import org.jdiameter.api.Answer;
import org.jdiameter.api.Avp;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.rf.ServerRfSession;
import org.jdiameter.api.rf.ServerRfSessionListener;
import org.jdiameter.api.rf.events.RfAccountingAnswer;
import org.jdiameter.api.rf.events.RfAccountingRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.IAppSessionState;
import org.jdiameter.common.api.app.rf.IServerRfActionContext;
import org.jdiameter.common.api.app.rf.ServerRfSessionState;
import org.jdiameter.common.impl.app.rf.AppRfSessionImpl;
import org.jdiameter.server.impl.app.rf.Event;
import org.jdiameter.server.impl.app.rf.IServerRfSessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRfSessionImpl
extends AppRfSessionImpl
implements EventListener<Request, Answer>,
ServerRfSession,
NetworkReqListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ServerRfSessionImpl.class);
    protected transient IServerRfActionContext context;
    protected transient ServerRfSessionListener listener;
    protected static final String TIMER_NAME_TS = "TS";
    protected IServerRfSessionData sessionData;

    public ServerRfSessionImpl(IServerRfSessionData sessionData, ISessionFactory sessionFactory, ServerRfSessionListener serverSessionListener, IServerRfActionContext serverContextListener, StateChangeListener<AppSession> stLst, long tsTimeout, boolean stateless) {
        super(sessionFactory, sessionData);
        this.listener = serverSessionListener;
        this.context = serverContextListener;
        this.sessionData = sessionData;
        this.sessionData.setTsTimeout(tsTimeout);
        this.sessionData.setStateless(stateless);
        super.addStateChangeNotification(stLst);
    }

    public void sendAccountAnswer(RfAccountingAnswer accountAnswer) throws InternalException, IllegalStateException, RouteException, OverloadException {
        try {
            this.session.send(accountAnswer.getMessage());
        }
        catch (IllegalDiameterStateException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isStateless() {
        return this.sessionData.isStateless();
    }

    protected void setState(IAppSessionState newState) {
        ServerRfSessionState oldState = this.sessionData.getServerRfSessionState();
        this.sessionData.setServerRfSessionState((ServerRfSessionState)newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)((Object)newState));
        }
    }

    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        return this.isStateless() ? this.handleEventForStatelessMode(event) : this.handleEventForStatefulMode(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEventForStatelessMode(StateEvent event) throws InternalException, OverloadException {
        try {
            ServerRfSessionState state = this.sessionData.getServerRfSessionState();
            block6 : switch (state) {
                case IDLE: {
                    switch ((Event.Type)event.getType()) {
                        case RECEIVED_START_RECORD: {
                            if (this.listener == null) break block6;
                            try {
                                this.listener.doRfAccountingRequestEvent((ServerRfSession)this, (RfAccountingRequest)event.getData());
                            }
                            catch (Exception e) {
                                logger.debug("Can not handle event", (Throwable)e);
                            }
                            break block6;
                        }
                        case RECEIVED_EVENT_RECORD: {
                            if (this.listener != null) {
                                try {
                                    this.listener.doRfAccountingRequestEvent((ServerRfSession)this, (RfAccountingRequest)event.getData());
                                }
                                catch (Exception e) {
                                    logger.debug("Can not handle event", (Throwable)e);
                                }
                            }
                            this.setState(ServerRfSessionState.IDLE);
                            break block6;
                        }
                        case RECEIVED_INTERIM_RECORD: {
                            if (this.listener == null) break block6;
                            try {
                                this.listener.doRfAccountingRequestEvent((ServerRfSession)this, (RfAccountingRequest)event.getData());
                            }
                            catch (Exception e) {
                                logger.debug("Can not handle event", (Throwable)e);
                            }
                            break block6;
                        }
                        case RECEIVED_STOP_RECORD: {
                            if (this.listener == null) break block6;
                            try {
                                this.listener.doRfAccountingRequestEvent((ServerRfSession)this, (RfAccountingRequest)event.getData());
                            }
                            catch (Exception e) {
                                logger.debug("Can not handle event", (Throwable)e);
                            }
                            break block6;
                        }
                    }
                    throw new IllegalStateException("Current state " + state + " action " + event.getType());
                }
            }
        }
        catch (Exception e) {
            logger.debug("Can not process event", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public boolean handleEventForStatefulMode(StateEvent event) throws InternalException, OverloadException {
        block31: {
            try {
                if (((RfAccountingRequest)event.getData()).getMessage().isReTransmitted()) {
                    try {
                        this.setState(ServerRfSessionState.OPEN);
                        this.listener.doRfAccountingRequestEvent((ServerRfSession)this, (RfAccountingRequest)event.getData());
                        this.cancelTsTimer();
                        this.startTsTimer();
                        if (this.context != null) {
                            this.context.sessionTimerStarted(this, null);
                        }
                    }
                    catch (Exception e) {
                        logger.debug("Can not handle event", (Throwable)e);
                        this.setState(ServerRfSessionState.IDLE);
                    }
                    return true;
                }
                ServerRfSessionState state = this.sessionData.getServerRfSessionState();
                block6 : switch (state) {
                    case IDLE: {
                        switch ((Event.Type)event.getType()) {
                            case RECEIVED_START_RECORD: {
                                this.setState(ServerRfSessionState.OPEN);
                                if (this.listener != null) {
                                    try {
                                        this.listener.doRfAccountingRequestEvent((ServerRfSession)this, (RfAccountingRequest)event.getData());
                                        this.cancelTsTimer();
                                        this.startTsTimer();
                                        if (this.context != null) {
                                            this.context.sessionTimerStarted(this, null);
                                        }
                                        break block31;
                                    }
                                    catch (Exception e) {
                                        logger.debug("Can not handle event", (Throwable)e);
                                        this.setState(ServerRfSessionState.IDLE);
                                    }
                                    break;
                                }
                                break block31;
                            }
                            case RECEIVED_EVENT_RECORD: {
                                if (this.listener != null) {
                                    try {
                                        this.listener.doRfAccountingRequestEvent((ServerRfSession)this, (RfAccountingRequest)event.getData());
                                        break;
                                    }
                                    catch (Exception e) {
                                        logger.debug("Can not handle event", (Throwable)e);
                                    }
                                } else {
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case OPEN: {
                        switch ((Event.Type)event.getType()) {
                            case RECEIVED_INTERIM_RECORD: {
                                try {
                                    this.listener.doRfAccountingRequestEvent((ServerRfSession)this, (RfAccountingRequest)event.getData());
                                    this.cancelTsTimer();
                                    this.startTsTimer();
                                    if (this.context != null) {
                                        this.context.sessionTimerStarted(this, null);
                                    }
                                    break block31;
                                }
                                catch (Exception e) {
                                    logger.debug("Can not handle event", (Throwable)e);
                                    this.setState(ServerRfSessionState.IDLE);
                                }
                                break block31;
                            }
                            case RECEIVED_STOP_RECORD: {
                                this.setState(ServerRfSessionState.IDLE);
                                try {
                                    this.listener.doRfAccountingRequestEvent((ServerRfSession)this, (RfAccountingRequest)event.getData());
                                    this.cancelTsTimer();
                                    if (this.context != null) {
                                        this.context.sessionTimerCanceled(this, null);
                                        break block6;
                                    }
                                }
                                catch (Exception e) {
                                    logger.debug("Can not handle event", (Throwable)e);
                                    this.setState(ServerRfSessionState.IDLE);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Can not process event", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTsTimer() {
        try {
            this.sendAndStateLock.lock();
            if (this.sessionData.getTsTimeout() > 0L) {
                this.sessionData.setTsTimerId(this.timerFacility.schedule(this.getSessionId(), TIMER_NAME_TS, this.sessionData.getTsTimeout()));
            }
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTsTimer() {
        try {
            this.sendAndStateLock.lock();
            Serializable tsTimerId = this.sessionData.getTsTimerId();
            if (tsTimerId != null) {
                this.timerFacility.cancel(tsTimerId);
                this.sessionData.setTsTimerId(null);
            }
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals(TIMER_NAME_TS)) {
            if (this.context != null) {
                try {
                    this.context.sessionTimeoutElapses(this);
                }
                catch (InternalException e) {
                    logger.debug("Failure on processing expired Ts", (Throwable)e);
                }
            }
            this.setState(ServerRfSessionState.IDLE);
        }
    }

    protected Answer createStopAnswer(Request request) {
        Answer answer = request.createAnswer(2001L);
        answer.getAvps().addAvp(480, 4);
        answer.getAvps().addAvp(new Avp[]{request.getAvps().getAvp(485)});
        return answer;
    }

    protected Answer createInterimAnswer(Request request) {
        Answer answer = request.createAnswer(2001L);
        answer.getAvps().addAvp(480, 3);
        answer.getAvps().addAvp(new Avp[]{request.getAvps().getAvp(485)});
        return answer;
    }

    protected Answer createEventAnswer(Request request) {
        Answer answer = request.createAnswer(2001L);
        answer.getAvps().addAvp(480, 2);
        answer.getAvps().addAvp(new Avp[]{request.getAvps().getAvp(485)});
        return answer;
    }

    protected Answer createStartAnswer(Request request) {
        Answer answer = request.createAnswer(2001L);
        answer.getAvps().addAvp(480, 1);
        answer.getAvps().addAvp(new Avp[]{request.getAvps().getAvp(485)});
        return answer;
    }

    public <E> E getState(Class<E> eClass) {
        return (E)(eClass == ServerRfSessionState.class ? this.sessionData.getServerRfSessionState() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Answer processRequest(Request request) {
        if (request.getCommandCode() == 271) {
            try {
                this.sendAndStateLock.lock();
                this.handleEvent(new Event(this.createAccountRequest(request)));
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            try {
                this.listener.doOtherEvent((AppSession)this, (AppRequestEvent)this.createAccountRequest(request), null);
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedSuccessMessage(Request request, Answer answer) {
        if (request.getCommandCode() == 271) {
            try {
                this.sendAndStateLock.lock();
                this.handleEvent(new Event(this.createAccountRequest(request)));
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
            try {
                this.listener.doRfAccountingRequestEvent((ServerRfSession)this, this.createAccountRequest(request));
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
        } else {
            try {
                this.listener.doOtherEvent((AppSession)this, (AppRequestEvent)this.createAccountRequest(request), (AppAnswerEvent)this.createAccountAnswer(answer));
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
        }
    }

    public void timeoutExpired(Request request) {
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
            }
            catch (Exception e) {
                logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }
}

