/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.agent;

import java.io.IOException;
import java.util.Properties;
import org.jdiameter.api.Answer;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.IRequest;
import org.jdiameter.client.api.controller.IRealm;
import org.jdiameter.client.api.controller.IRealmTable;
import org.jdiameter.server.api.agent.IAgentConfiguration;
import org.jdiameter.server.api.agent.IRedirect;
import org.jdiameter.server.impl.agent.AgentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectAgentImpl
extends AgentImpl
implements IRedirect {
    private static final Logger logger = LoggerFactory.getLogger(RedirectAgentImpl.class);
    public static final int RESULT_REDIRECT_INDICATION = 3006;
    public static final int RESULT_INVALID_AVP_VALUE = 5004;

    public RedirectAgentImpl(IContainer container, IRealmTable realmTable) {
        super(container, realmTable);
    }

    @Override
    public Answer processRequest(IRequest request, IRealm matchedRealm) {
        block17: {
            try {
                int rhuValue;
                AvpSet set;
                Answer ans;
                block16: {
                    String[] destHosts;
                    ans = request.createAnswer(3006L);
                    set = ans.getAvps();
                    for (String host : destHosts = matchedRealm.getPeerNames()) {
                        set.addAvp(292, host, false);
                    }
                    IAgentConfiguration agentConfiguration = matchedRealm.getAgentConfiguration();
                    rhuValue = 3;
                    if (agentConfiguration != null) {
                        Properties p = agentConfiguration.getProperties();
                        try {
                            rhuValue = Integer.parseInt(p.getProperty("rdr.host.usage", "" + rhuValue));
                        }
                        catch (Exception e) {
                            if (!logger.isWarnEnabled()) break block16;
                            logger.warn("Failed to parse configuration value. ", (Throwable)e);
                        }
                    }
                }
                set.addAvp(261, rhuValue);
                ans.setError(true);
                this.container.sendMessage((IMessage)ans);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failure when trying to send Answer", (Throwable)e);
                }
                Answer ans = request.createAnswer(5004L);
                if (e instanceof AvpDataException && ((AvpDataException)((Object)e)).getAvp() != null) {
                    AvpSet failedAvp = ans.getAvps().addGroupedAvp(279);
                    failedAvp.addAvp(new Avp[]{((AvpDataException)((Object)e)).getAvp()});
                }
                try {
                    this.container.sendMessage((IMessage)ans);
                }
                catch (RouteException re) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failure when trying to send failure answer", (Throwable)re);
                    }
                }
                catch (AvpDataException ade) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failure when trying to send failure answer", (Throwable)ade);
                    }
                }
                catch (IllegalDiameterStateException idse) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failure when trying to send failure answer", (Throwable)idse);
                    }
                }
                catch (IOException ioe) {
                    if (!logger.isDebugEnabled()) break block17;
                    logger.debug("Failure when trying to send failure answer", (Throwable)ioe);
                }
            }
        }
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
    }

    public void timeoutExpired(Request request) {
    }
}

