/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.jdiameter.api.ApplicationAlreadyUseException;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.LocalAction;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.Peer;
import org.jdiameter.api.Realm;
import org.jdiameter.api.Selector;
import org.jdiameter.api.Statistic;
import org.jdiameter.api.URI;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.jdiameter.server.api.IMetaData;
import org.jdiameter.server.api.IMutablePeerTable;
import org.jdiameter.server.api.INetwork;
import org.jdiameter.server.api.IRouter;
import org.jdiameter.server.api.agent.IAgentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkImpl
implements INetwork {
    private static final Logger logger = LoggerFactory.getLogger(NetworkImpl.class);
    protected IMutablePeerTable manager;
    protected IRouter router;
    protected IMetaData metaData;
    private final ApplicationId commonAuthAppId = ApplicationId.createByAuthAppId((long)0L, (long)-1L);
    private final ApplicationId commonAccAppId = ApplicationId.createByAccAppId((long)0L, (long)-1L);
    private final ConcurrentHashMap<ApplicationId, NetworkReqListener> appIdToNetListener = new ConcurrentHashMap();
    private final ConcurrentHashMap<Selector, NetworkReqListener> selectorToNetListener = new ConcurrentHashMap();
    protected IStatistic statistic;

    public NetworkImpl(IStatisticManager statisticFactory, IMetaData metaData, IRouter router) {
        this.router = router;
        this.metaData = metaData;
        IStatisticRecord nrlStat = statisticFactory.newCounterRecord(IStatisticRecord.Counters.RequestListenerCount, new IStatisticRecord.IntegerValueHolder(){

            @Override
            public int getValueAsInt() {
                return NetworkImpl.this.appIdToNetListener.size();
            }

            @Override
            public String getValueAsString() {
                return String.valueOf(this.getValueAsInt());
            }
        });
        IStatisticRecord nslStat = statisticFactory.newCounterRecord(IStatisticRecord.Counters.SelectorCount, new IStatisticRecord.IntegerValueHolder(){

            @Override
            public int getValueAsInt() {
                return NetworkImpl.this.selectorToNetListener.size();
            }

            @Override
            public String getValueAsString() {
                return String.valueOf(this.getValueAsInt());
            }
        });
        this.statistic = statisticFactory.newStatistic("network", IStatistic.Groups.Network, nrlStat, nslStat);
    }

    public void addNetworkReqListener(NetworkReqListener networkReqListener, ApplicationId ... applicationId) throws ApplicationAlreadyUseException {
        for (ApplicationId a : applicationId) {
            if (this.appIdToNetListener.containsKey(this.commonAuthAppId) || this.appIdToNetListener.containsKey(this.commonAccAppId)) {
                throw new ApplicationAlreadyUseException(a + " already use by common application id");
            }
            if (this.appIdToNetListener.containsKey(applicationId)) {
                throw new ApplicationAlreadyUseException(a + " already use");
            }
            this.appIdToNetListener.put(a, networkReqListener);
            this.metaData.addApplicationId(a);
            this.router.getRealmTable().addLocalApplicationId(a);
        }
    }

    public void addNetworkReqListener(NetworkReqListener listener, Selector<Message, ApplicationId> ... selectors) {
        for (Selector<Message, ApplicationId> s : selectors) {
            this.selectorToNetListener.put(s, listener);
            ApplicationId ap = (ApplicationId)s.getMetaData();
            this.metaData.addApplicationId(ap);
            this.router.getRealmTable().addLocalApplicationId(ap);
        }
    }

    public void removeNetworkReqListener(ApplicationId ... applicationId) {
        for (ApplicationId a : applicationId) {
            this.appIdToNetListener.remove(a);
            for (Selector s : this.selectorToNetListener.keySet()) {
                if (!((ApplicationId)s.getMetaData()).equals((Object)a)) continue;
                return;
            }
            this.metaData.remApplicationId(a);
            this.router.getRealmTable().removeLocalApplicationId(a);
        }
    }

    public void removeNetworkReqListener(Selector<Message, ApplicationId> ... selectors) {
        for (Selector<Message, ApplicationId> s : selectors) {
            this.selectorToNetListener.remove(s);
            if (this.appIdToNetListener.containsKey(s.getMetaData())) {
                return;
            }
            for (Selector i : this.selectorToNetListener.keySet()) {
                if (!((ApplicationId)i.getMetaData()).equals(s.getMetaData())) continue;
                return;
            }
            this.metaData.remApplicationId((ApplicationId)s.getMetaData());
            this.router.getRealmTable().removeLocalApplicationId((ApplicationId)s.getMetaData());
        }
    }

    public Peer addPeer(String name, String realm, boolean connecting) {
        if (this.manager != null) {
            try {
                return this.manager.addPeer(new URI(name), realm, connecting);
            }
            catch (Exception e) {
                logger.error("Failed to add peer with name[" + name + "] and realm[" + realm + "] (connecting=" + connecting + ")", (Throwable)e);
                return null;
            }
        }
        logger.debug("Failed to add peer with name[{}] and realm[{}] (connecting={}) as peer manager is null.", new Object[]{name, realm, connecting});
        return null;
    }

    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        return false;
    }

    public <T> T unwrap(Class<T> aClass) throws InternalException {
        return null;
    }

    public Realm addRealm(String name, ApplicationId applicationId, LocalAction localAction, String agentConfiguration, boolean dynamic, long expirationTime) {
        try {
            return this.router.getRealmTable().addRealm(name, applicationId, localAction, agentConfiguration, dynamic, expirationTime, new String[0]);
        }
        catch (InternalException e) {
            logger.error("Failure on add realm operation.", (Throwable)e);
            return null;
        }
    }

    public Realm addRealm(String name, ApplicationId applicationId, LocalAction localAction, IAgentConfiguration agentConfiguration, boolean dynamic, long expirationTime) {
        try {
            return this.router.getRealmTable().addRealm(name, applicationId, localAction, agentConfiguration, dynamic, expirationTime, new String[0]);
        }
        catch (InternalException e) {
            logger.error("Failure on add realm operation.", (Throwable)e);
            return null;
        }
    }

    public Collection<Realm> remRealm(String name) {
        return this.router.getRealmTable().removeRealm(name);
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    @Override
    public NetworkReqListener getListener(IMessage message) {
        if (message == null) {
            return null;
        }
        for (Selector s : this.selectorToNetListener.keySet()) {
            boolean r = s.checkRule((Object)message);
            if (!r) continue;
            return this.selectorToNetListener.get(s);
        }
        ApplicationId appId = message.getSingleApplicationId();
        if (appId == null) {
            return null;
        }
        if (this.appIdToNetListener.containsKey(this.commonAuthAppId)) {
            return this.appIdToNetListener.get(this.commonAuthAppId);
        }
        if (this.appIdToNetListener.containsKey(this.commonAccAppId)) {
            return this.appIdToNetListener.get(this.commonAccAppId);
        }
        return this.appIdToNetListener.get(appId);
    }

    @Override
    public void setPeerManager(IMutablePeerTable manager) {
        this.manager = manager;
    }
}

