/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.data;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.ISession;
import org.jdiameter.common.api.app.IAppSessionData;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.acc.IAccSessionData;
import org.jdiameter.common.api.app.auth.IAuthSessionData;
import org.jdiameter.common.api.app.cca.ICCASessionData;
import org.jdiameter.common.api.app.cxdx.ICxDxSessionData;
import org.jdiameter.common.api.app.gx.IGxSessionData;
import org.jdiameter.common.api.app.rf.IRfSessionData;
import org.jdiameter.common.api.app.ro.IRoSessionData;
import org.jdiameter.common.api.app.rx.IRxSessionData;
import org.jdiameter.common.api.app.s13.IS13SessionData;
import org.jdiameter.common.api.app.s6a.IS6aSessionData;
import org.jdiameter.common.api.app.sh.IShSessionData;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.acc.AccLocalSessionDataFactory;
import org.jdiameter.common.impl.app.auth.AuthLocalSessionDataFactory;
import org.jdiameter.common.impl.app.cca.CCALocalSessionDataFactory;
import org.jdiameter.common.impl.app.cxdx.CxDxLocalSessionDataFactory;
import org.jdiameter.common.impl.app.gx.GxLocalSessionDataFactory;
import org.jdiameter.common.impl.app.rf.RfLocalSessionDataFactory;
import org.jdiameter.common.impl.app.ro.RoLocalSessionDataFactory;
import org.jdiameter.common.impl.app.rx.RxLocalSessionDataFactory;
import org.jdiameter.common.impl.app.s13.S13LocalSessionDataFactory;
import org.jdiameter.common.impl.app.s6a.S6aLocalSessionDataFactory;
import org.jdiameter.common.impl.app.sh.ShLocalSessionDataFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDataSource
implements ISessionDatasource {
    protected HashMap<Class<? extends IAppSessionData>, IAppSessionDataFactory<? extends IAppSessionData>> appSessionDataFactories = new HashMap();
    private ConcurrentHashMap<String, SessionEntry> sessionIdToEntry = new ConcurrentHashMap();
    private static final Logger logger = LoggerFactory.getLogger(LocalDataSource.class);

    public LocalDataSource() {
        this.appSessionDataFactories.put(ICCASessionData.class, new CCALocalSessionDataFactory());
        this.appSessionDataFactories.put(IRoSessionData.class, new RoLocalSessionDataFactory());
        this.appSessionDataFactories.put(IRfSessionData.class, new RfLocalSessionDataFactory());
        this.appSessionDataFactories.put(IGxSessionData.class, new GxLocalSessionDataFactory());
        this.appSessionDataFactories.put(IAccSessionData.class, new AccLocalSessionDataFactory());
        this.appSessionDataFactories.put(IAuthSessionData.class, new AuthLocalSessionDataFactory());
        this.appSessionDataFactories.put(IShSessionData.class, new ShLocalSessionDataFactory());
        this.appSessionDataFactories.put(ICxDxSessionData.class, new CxDxLocalSessionDataFactory());
        this.appSessionDataFactories.put(IRxSessionData.class, new RxLocalSessionDataFactory());
        this.appSessionDataFactories.put(IS6aSessionData.class, new S6aLocalSessionDataFactory());
        this.appSessionDataFactories.put(IS13SessionData.class, new S13LocalSessionDataFactory());
    }

    public LocalDataSource(IContainer container) {
        this();
    }

    @Override
    public boolean exists(String sessionId) {
        return this.sessionIdToEntry.containsKey(sessionId);
    }

    @Override
    public void setSessionListener(String sessionId, NetworkReqListener data) {
        logger.debug("setSessionListener({}, {})", (Object)sessionId, (Object)data);
        SessionEntry se = this.sessionIdToEntry.get(sessionId);
        if (se == null) {
            throw new IllegalArgumentException("No Session entry for id: " + sessionId);
        }
        se.listener = data;
    }

    @Override
    public NetworkReqListener getSessionListener(String sessionId) {
        SessionEntry se = this.sessionIdToEntry.get(sessionId);
        logger.debug("getSessionListener({}) => {}", (Object)sessionId, (Object)se);
        return se != null ? se.listener : null;
    }

    @Override
    public NetworkReqListener removeSessionListener(String sessionId) {
        SessionEntry se = this.sessionIdToEntry.get(sessionId);
        logger.debug("removeSessionListener({}) => {}", (Object)sessionId, (Object)se);
        if (se != null) {
            NetworkReqListener lst = se.listener;
            se.listener = null;
            return lst;
        }
        return null;
    }

    @Override
    public void addSession(BaseSession session) {
        logger.debug("addSession({})", (Object)session);
        SessionEntry se = null;
        String sessionId = session.getSessionId();
        if (this.sessionIdToEntry.containsKey(sessionId)) {
            se = this.sessionIdToEntry.get(sessionId);
            if (!(se.session instanceof ISession) || se.session.isReplicable()) {
                throw new IllegalArgumentException("Sessin with id: " + sessionId + ", already exists!");
            }
            this.sessionIdToEntry.put(sessionId, se);
        } else {
            se = new SessionEntry();
        }
        se.session = session;
        this.sessionIdToEntry.put(session.getSessionId(), se);
    }

    @Override
    public BaseSession getSession(String sessionId) {
        SessionEntry se = this.sessionIdToEntry.get(sessionId);
        logger.debug("getSession({}) => {}", (Object)sessionId, (Object)se);
        return se != null ? se.session : null;
    }

    @Override
    public void removeSession(String sessionId) {
        SessionEntry se = this.sessionIdToEntry.remove(sessionId);
        logger.debug("removeSession({}) => {}", (Object)sessionId, (Object)se);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    public String toString() {
        return "LocalDataSource [sessionIdToEntry=" + this.sessionIdToEntry + "]";
    }

    @Override
    public IAppSessionDataFactory<? extends IAppSessionData> getDataFactory(Class<? extends IAppSessionData> x) {
        return this.appSessionDataFactories.get(x);
    }

    private class SessionEntry {
        BaseSession session;
        NetworkReqListener listener;

        private SessionEntry() {
        }

        public String toString() {
            return "SessionEntry [session=" + this.session + ", listener=" + this.listener + "]";
        }
    }
}

