/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.s13;

import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Message;
import org.jdiameter.api.s13.events.JMEIdentityCheckRequest;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMEIdentityCheckRequestImpl
extends AppRequestEventImpl
implements JMEIdentityCheckRequest {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = LoggerFactory.getLogger(JMEIdentityCheckRequestImpl.class);

    public JMEIdentityCheckRequestImpl(Message message) {
        super(message);
        message.setRequest(true);
    }

    public Avp getTerminalInformationAvp() {
        return this.message.getAvps().getAvp(1401);
    }

    public boolean hasIMEI() {
        Avp terminalInfoAvp = this.message.getAvps().getAvp(1401);
        if (terminalInfoAvp != null) {
            try {
                return terminalInfoAvp.getGrouped().getAvp(1402) != null;
            }
            catch (AvpDataException ex) {
                logger.debug("Failure trying to obtain (Terminal-Information) IMEI AVP value", (Throwable)ex);
            }
        }
        return false;
    }

    public String getIMEI() {
        Avp terminalInfoAvp = this.message.getAvps().getAvp(1401);
        if (terminalInfoAvp != null) {
            try {
                Avp imei = terminalInfoAvp.getGrouped().getAvp(1402);
                if (imei != null) {
                    return imei.getUTF8String();
                }
            }
            catch (AvpDataException ex) {
                logger.debug("Failure trying to obtain (Terminal-Information) IMEI AVP value", (Throwable)ex);
            }
        }
        return null;
    }

    public boolean hasTgpp2MEID() {
        Avp terminalInfoAvp = this.message.getAvps().getAvp(1401);
        if (terminalInfoAvp != null) {
            try {
                return terminalInfoAvp.getGrouped().getAvp(1471) != null;
            }
            catch (AvpDataException ex) {
                logger.debug("Failure trying to obtain (Terminal-Information) MEID AVP value", (Throwable)ex);
            }
        }
        return false;
    }

    public byte[] getTgpp2MEID() {
        Avp terminalInfoAvp = this.message.getAvps().getAvp(1401);
        if (terminalInfoAvp != null) {
            try {
                Avp meid = terminalInfoAvp.getGrouped().getAvp(1471);
                if (meid != null) {
                    return meid.getOctetString();
                }
            }
            catch (AvpDataException ex) {
                logger.debug("Failure trying to obtain (Terminal-Information) MEID AVP value", (Throwable)ex);
            }
        }
        return null;
    }

    public boolean hasSoftwareVersion() {
        Avp terminalInfoAvp = this.message.getAvps().getAvp(1401);
        if (terminalInfoAvp != null) {
            try {
                return terminalInfoAvp.getGrouped().getAvp(1403) != null;
            }
            catch (AvpDataException ex) {
                logger.debug("Failure trying to obtain (Terminal-Information) Software-Version AVP value", (Throwable)ex);
            }
        }
        return false;
    }

    public String getSoftwareVersion() {
        Avp terminalInfoAvp = this.message.getAvps().getAvp(1401);
        if (terminalInfoAvp != null) {
            try {
                Avp softwareVersion = terminalInfoAvp.getGrouped().getAvp(1403);
                if (softwareVersion != null) {
                    return softwareVersion.getUTF8String();
                }
            }
            catch (AvpDataException ex) {
                logger.debug("Failure trying to obtain (Terminal-Information) Software-Version AVP value", (Throwable)ex);
            }
        }
        return null;
    }

    public boolean isUserNameAVPPresent() {
        return this.message.getAvps().getAvp(1) != null;
    }

    public String getUserName() {
        Avp userNameAvp = this.message.getAvps().getAvp(1);
        if (userNameAvp != null) {
            try {
                return userNameAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                logger.debug("Failure trying to obtain User-Name AVP value", (Throwable)e);
            }
        }
        return null;
    }
}

