/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tls.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.Configuration;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.impl.transport.tls.netty.StartTlsClientHandler;
import org.jdiameter.client.impl.transport.tls.netty.TLSTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartTlsInitiator
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(StartTlsInitiator.class);
    private final Configuration config;
    private final TLSTransportClient tlsTransportClient;

    public StartTlsInitiator(Configuration config, TLSTransportClient tlsTransportClient) {
        this.config = config;
        this.tlsTransportClient = tlsTransportClient;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof IMessage) {
            AvpSet set;
            Avp inbandAvp;
            IMessage m = (IMessage)msg;
            logger.debug("StartTlsInitiator");
            if (m.getCommandCode() == 257 && this.tlsTransportClient.getTlsHandshakingState() == TLSTransportClient.TlsHandshakingState.INIT && (inbandAvp = (set = m.getAvps()).getAvp(299)) != null && inbandAvp.getUnsigned32() == 1L) {
                this.tlsTransportClient.setTlsHandshakingState(TLSTransportClient.TlsHandshakingState.SHAKING);
                ChannelPipeline pipeline = ctx.pipeline();
                pipeline.remove("decoder");
                pipeline.remove("msgHandler");
                pipeline.remove((ChannelHandler)this);
                pipeline.remove("encoder");
                pipeline.remove("inbandWriter");
                pipeline.addLast("startTlsClientHandler", (ChannelHandler)new StartTlsClientHandler(this.tlsTransportClient));
                logger.debug("Sending StartTlsRequest");
                ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"StartTlsRequest".getBytes())).addListener(new GenericFutureListener(){

                    public void operationComplete(Future f) throws Exception {
                        if (!f.isSuccess()) {
                            logger.error(f.cause().getMessage(), f.cause());
                        }
                    }
                });
            }
        }
        ReferenceCountUtil.release((Object)msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error(cause.getMessage(), cause);
    }
}

