/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tls.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import javax.net.ssl.SSLEngine;
import org.jdiameter.client.impl.transport.tls.netty.DiameterMessageDecoder;
import org.jdiameter.client.impl.transport.tls.netty.DiameterMessageEncoder;
import org.jdiameter.client.impl.transport.tls.netty.DiameterMessageHandler;
import org.jdiameter.client.impl.transport.tls.netty.InbandSecurityHandler;
import org.jdiameter.client.impl.transport.tls.netty.SslContextFactory;
import org.jdiameter.client.impl.transport.tls.netty.TLSTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartTlsClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(StartTlsClientHandler.class);
    private final TLSTransportClient tlsTransportClient;

    public StartTlsClientHandler(TLSTransportClient tlsTransportClient) {
        this.tlsTransportClient = tlsTransportClient;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        logger.debug("StartTlsClientHandler");
        ByteBuf buf = (ByteBuf)msg;
        byte[] bytes = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), bytes);
        if ("StartTlsResponse".equals(new String(bytes))) {
            logger.debug("received StartTlsResponse");
            SslContext sslContext = SslContextFactory.getSslContextForClient(this.tlsTransportClient.getConfig());
            SSLEngine sslEngine = sslContext.newEngine(ctx.alloc());
            sslEngine.setUseClientMode(true);
            SslHandler sslHandler = new SslHandler(sslEngine, false);
            final ChannelPipeline pipeline = ctx.pipeline();
            pipeline.remove("startTlsClientHandler");
            pipeline.addLast("sslHandler", (ChannelHandler)sslHandler);
            logger.debug("StartTls starting handshake");
            sslHandler.handshakeFuture().addListener(new GenericFutureListener(){

                public void operationComplete(Future future) throws Exception {
                    if (future.isSuccess()) {
                        logger.debug("StartTls handshake succesfull");
                        StartTlsClientHandler.this.tlsTransportClient.setTlsHandshakingState(TLSTransportClient.TlsHandshakingState.SHAKEN);
                        logger.debug("restoring all handlers");
                        pipeline.addLast("decoder", (ChannelHandler)new DiameterMessageDecoder(StartTlsClientHandler.this.tlsTransportClient.getParent(), StartTlsClientHandler.this.tlsTransportClient.getParser()));
                        pipeline.addLast("msgHandler", (ChannelHandler)new DiameterMessageHandler(StartTlsClientHandler.this.tlsTransportClient.getParent(), true));
                        pipeline.addLast("encoder", (ChannelHandler)new DiameterMessageEncoder(StartTlsClientHandler.this.tlsTransportClient.getParser()));
                        pipeline.addLast("inbandWriter", (ChannelHandler)new InbandSecurityHandler());
                    }
                }
            });
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error(cause.getMessage(), cause);
    }
}

