/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.router;

import java.util.Arrays;
import java.util.List;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.MetaData;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.controller.IPeer;
import org.jdiameter.client.api.controller.IRealmTable;
import org.jdiameter.client.impl.router.RouterImpl;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightedLeastConnectionsRouter
extends RouterImpl {
    private static final Logger logger = LoggerFactory.getLogger(WeightedLeastConnectionsRouter.class);

    protected WeightedLeastConnectionsRouter(IRealmTable table, Configuration config) {
        super(null, null, table, config, null);
    }

    public WeightedLeastConnectionsRouter(IContainer container, IConcurrentFactory concurrentFactory, IRealmTable realmTable, Configuration config, MetaData aMetaData) {
        super(container, concurrentFactory, realmTable, config, aMetaData);
    }

    @Override
    public IPeer selectPeer(List<IPeer> availablePeers) {
        int peerSize;
        int n = peerSize = availablePeers != null ? availablePeers.size() : 0;
        if (peerSize <= 0) {
            return null;
        }
        if (peerSize == 1) {
            return availablePeers.iterator().next();
        }
        int m = 0;
        while (m < peerSize) {
            IPeer peerM = availablePeers.get(m);
            if (peerM.getRating() > 0) {
                for (int i = m + 1; i < peerSize; ++i) {
                    IPeer peerI = availablePeers.get(i);
                    if (this.getNumConnections(peerM) * (long)peerI.getRating() <= this.getNumConnections(peerI) * (long)peerM.getRating()) continue;
                    m = i;
                }
                return availablePeers.get(m);
            }
            ++peerSize;
        }
        return availablePeers.iterator().next();
    }

    protected long getNumConnections(IPeer peer) {
        if (peer == null) {
            return 0L;
        }
        IStatistic stats = peer.getStatistic();
        if (!stats.isEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Statistics for peer are disabled. Please enable statistics in client config");
            }
            return 0L;
        }
        String uri = peer.getUri() == null ? "local" : peer.getUri().toString();
        long requests = this.getRecord(IStatisticRecord.Counters.AppGenRequestPerSecond.name() + '.' + uri, stats) + this.getRecord(IStatisticRecord.Counters.NetGenRequestPerSecond.name() + '.' + uri, stats);
        long connections = Math.max(0L, requests);
        if (logger.isTraceEnabled()) {
            logger.trace("Active connections for {}: {}", (Object)peer, (Object)connections);
        }
        return connections;
    }

    protected long getRecord(String record, IStatistic stats) {
        if (record == null || stats == null) {
            return 0L;
        }
        IStatisticRecord statsRecord = stats.getRecordByName(record);
        if (statsRecord == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Warning: no record for {}, available: {}", (Object)record, (Object)Arrays.toString(stats.getRecords()));
            }
            return 0L;
        }
        return statsRecord.getValueAsLong();
    }
}

