/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.LocalAction;
import org.jdiameter.api.Realm;
import org.jdiameter.api.Statistic;
import org.jdiameter.client.api.IAnswer;
import org.jdiameter.client.api.IAssembler;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.IRequest;
import org.jdiameter.client.api.controller.IRealm;
import org.jdiameter.client.api.controller.IRealmTable;
import org.jdiameter.client.impl.controller.RealmImpl;
import org.jdiameter.server.api.agent.IAgent;
import org.jdiameter.server.api.agent.IAgentConfiguration;
import org.jdiameter.server.api.agent.IProxy;
import org.jdiameter.server.api.agent.IRedirect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmTableImpl
implements IRealmTable {
    private static final Logger logger = LoggerFactory.getLogger(RealmTableImpl.class);
    protected Map<String, RealmSet> realmNameToRealmSet = new HashMap<String, RealmSet>();
    protected List<String> allRealmsSet = new ArrayList<String>();
    protected String localRealmName;
    protected String localHost;
    protected IAssembler assembler;

    public RealmTableImpl(IContainer con) {
        this.assembler = con.getAssemblerFacility();
    }

    public boolean realmExists(String realmName) {
        return this.realmNameToRealmSet.containsKey(realmName) && this.realmNameToRealmSet.get(realmName).size() > 0;
    }

    public Realm addRealm(String realmName, ApplicationId applicationId, LocalAction action, String agentConfiguration, boolean dynamic, long expirationTime, String[] hosts) throws InternalException {
        logger.debug("Adding realm [{}] into network map", (Object)realmName);
        IAgentConfiguration agentConf = this.assembler.getComponentInstance(IAgentConfiguration.class);
        if (agentConf != null) {
            agentConf = agentConf.parse(agentConfiguration);
        }
        return this.addRealm(realmName, applicationId, action, agentConf, dynamic, expirationTime, hosts);
    }

    @Override
    public Realm addRealm(String realmName, ApplicationId applicationId, LocalAction action, IAgentConfiguration agentConf, boolean dynamic, long expirationTime, String[] hosts) throws InternalException {
        IAgent agent = null;
        switch (action) {
            case LOCAL: 
            case RELAY: {
                break;
            }
            case PROXY: {
                agent = this.assembler.getComponentInstance(IProxy.class);
                break;
            }
            case REDIRECT: {
                agent = this.assembler.getComponentInstance(IRedirect.class);
            }
        }
        RealmImpl realmImpl = new RealmImpl(realmName, applicationId, action, agent, agentConf, dynamic, expirationTime, hosts);
        this.addRealm(realmImpl);
        return realmImpl;
    }

    @Override
    public Realm getRealm(String realmName, ApplicationId applicationId) {
        RealmSet rs = this.realmNameToRealmSet.get(realmName);
        return rs == null ? null : rs.getRealm(applicationId);
    }

    @Override
    public Realm removeRealmApplicationId(String realmName, ApplicationId appId) {
        RealmSet set = this.realmNameToRealmSet.get(realmName);
        if (set != null) {
            Realm r = set.getRealm(appId);
            set.removeRealm(appId);
            if (set.size() == 0 && !realmName.equals(this.localRealmName)) {
                this.realmNameToRealmSet.remove(realmName);
                this.allRealmsSet.remove(realmName);
            }
            return r;
        }
        return null;
    }

    @Override
    public Collection<Realm> removeRealm(String realmName) {
        RealmSet set = null;
        if (realmName.equals(this.localRealmName)) {
            set = this.realmNameToRealmSet.get(realmName);
        } else {
            set = this.realmNameToRealmSet.remove(realmName);
            if (set != null) {
                Collection<Realm> present = set.values();
                this.allRealmsSet.remove(realmName);
                return new ArrayList<Realm>(present);
            }
        }
        return null;
    }

    @Override
    public Collection<Realm> getRealms(String realmName) {
        RealmSet set = this.realmNameToRealmSet.get(realmName);
        if (set != null) {
            Collection<Realm> present = set.values();
            return new ArrayList<Realm>(present);
        }
        return null;
    }

    @Override
    public Collection<Realm> getRealms() {
        ArrayList<Realm> rss = new ArrayList<Realm>();
        HashSet<String> keys = new HashSet<String>(this.realmNameToRealmSet.keySet());
        for (String key : keys) {
            RealmSet rs = this.realmNameToRealmSet.get(key);
            rss.addAll(rs.values());
        }
        return rss;
    }

    @Override
    public Realm matchRealm(IRequest request) {
        try {
            IMessage req = (IMessage)request;
            String destinationRealm = req.getAvps().getAvp(283).getDiameterIdentity();
            return this.matchRealm(req, destinationRealm);
        }
        catch (Exception e) {
            logger.error("Unable to read Destination-Realm AVP to match realm to request", (Throwable)e);
            return null;
        }
    }

    @Override
    public Realm matchRealm(IAnswer message, String destRealm) {
        return this.matchRealm((IMessage)message, destRealm);
    }

    @Override
    public String getRealmForPeer(String fqdn) {
        Collection<Realm> realms = this.getRealms();
        for (Realm r : realms) {
            IRealm ir = (IRealm)r;
            if (!ir.hasPeerName(fqdn)) continue;
            return ir.getName();
        }
        return null;
    }

    @Override
    public void addLocalApplicationId(ApplicationId appId) {
        RealmSet rs = this.getRealmSet(this.localRealmName, false);
        rs.addRealm(new RealmImpl(this.localRealmName, appId, LocalAction.LOCAL, null, null, true, -1L, new String[]{this.localHost}){

            @Override
            public boolean isLocal() {
                return true;
            }
        });
    }

    @Override
    public void removeLocalApplicationId(ApplicationId appId) {
        RealmSet rs = this.getRealmSet(this.localRealmName, false);
        Realm realm = rs.getRealm(appId);
        if (realm.isDynamic()) {
            rs.removeRealm(appId);
        }
    }

    @Override
    public void addLocalRealm(String localRealm, String fqdn) {
        this.localRealmName = localRealm;
        this.localHost = fqdn;
        this.getRealmSet(localRealm, true);
    }

    protected Realm matchRealm(IMessage message, String realm) {
        if (this.realmExists(realm)) {
            ApplicationId singleId = message.getSingleApplicationId();
            Realm r = this.getRealm(realm, singleId);
            if (r == null) {
                List appIds = message.getApplicationIdAvps();
                for (int index = 0; index < appIds.size() && (r = this.getRealm(realm, (ApplicationId)appIds.get(index))) == null; ++index) {
                }
            }
            return r;
        }
        return null;
    }

    protected void addRealm(Realm realm) throws InternalException {
        RealmSet rs = this.getRealmSet(realm.getName(), true);
        rs.addRealm(realm);
        this.allRealmsSet.add(realm.getName());
    }

    protected RealmSet getRealmSet(String pKey, boolean create) {
        RealmSet rs = this.realmNameToRealmSet.get(pKey);
        if (rs == null && create) {
            rs = new RealmSet();
            this.realmNameToRealmSet.put(pKey, rs);
        }
        return rs;
    }

    public Statistic getStatistic(String realmName) {
        return null;
    }

    public boolean isWrapperFor(Class<?> iface) throws InternalException {
        return false;
    }

    public <T> T unwrap(Class<T> iface) throws InternalException {
        return null;
    }

    private class RealmSet {
        protected Map<ApplicationId, Realm> appIdToRealm = new HashMap<ApplicationId, Realm>();

        private RealmSet() {
        }

        public void addRealm(Realm realm) {
            if (this.appIdToRealm.containsKey(realm.getApplicationId())) {
                Realm presentRealm = this.appIdToRealm.get(realm.getApplicationId());
                if (realm.getName().equals(RealmTableImpl.this.localRealmName)) {
                    RealmImpl realmImpl = (RealmImpl)presentRealm;
                    realmImpl.dynamic = false;
                    for (String peerName : ((RealmImpl)realm).getPeerNames()) {
                        realmImpl.addPeerName(peerName);
                    }
                } else if (presentRealm.isDynamic() || !realm.isDynamic()) {
                    if (presentRealm.isDynamic() && !realm.isDynamic()) {
                        RealmImpl realmImpl = (RealmImpl)presentRealm;
                        realmImpl.dynamic = false;
                        for (String peerName : ((RealmImpl)realm).getPeerNames()) {
                            realmImpl.addPeerName(peerName);
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Entry for realm '{}', already exists: {}", (Object)realm, (Object)this);
                    }
                }
            } else {
                this.appIdToRealm.put(realm.getApplicationId(), realm);
            }
        }

        public Collection<Realm> values() {
            return this.appIdToRealm.values();
        }

        public int size() {
            return this.appIdToRealm.size();
        }

        public Realm getRealm(ApplicationId appId) {
            return this.appIdToRealm.get(appId);
        }

        public Realm removeRealm(ApplicationId appId) {
            return this.appIdToRealm.remove(appId);
        }
    }
}

