/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.LocalAction;
import org.jdiameter.client.api.controller.IRealm;
import org.jdiameter.server.api.agent.IAgent;
import org.jdiameter.server.api.agent.IAgentConfiguration;

public class RealmImpl
implements IRealm {
    protected String name;
    protected ApplicationId appId;
    protected LocalAction action;
    protected boolean dynamic;
    protected long expirationTime;
    protected Collection<String> hosts = new ConcurrentLinkedQueue<String>();
    protected IAgent agent;
    protected IAgentConfiguration agentConfiguration;

    public RealmImpl(String name, ApplicationId applicationId, LocalAction localAction, IAgent agent, IAgentConfiguration agentConfiguration, boolean dynamic, long expirationTime, String ... hosts) {
        this.hosts.addAll(Arrays.asList(hosts));
        this.name = name;
        this.appId = applicationId;
        this.action = localAction;
        this.dynamic = dynamic;
        this.expirationTime = expirationTime;
        this.agent = agent;
        this.agentConfiguration = agentConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public ApplicationId getApplicationId() {
        return this.appId;
    }

    public LocalAction getLocalAction() {
        return this.action;
    }

    @Override
    public String[] getPeerNames() {
        return this.hosts.toArray(new String[this.hosts.size()]);
    }

    @Override
    public void addPeerName(String name) {
        if (!this.hasPeerName(name)) {
            this.hosts.add(name);
        }
    }

    @Override
    public void removePeerName(String s) {
        this.hosts.remove(this.name);
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public boolean hasPeerName(String name) {
        return this.hosts.contains(name);
    }

    @Override
    public IAgent getAgent() {
        return this.agent;
    }

    @Override
    public IAgentConfiguration getAgentConfiguration() {
        return this.agentConfiguration;
    }

    public boolean isLocal() {
        return false;
    }

    public String toString() {
        return "RealmImpl [name=" + this.name + ", appId=" + this.appId + ", action=" + this.action + ", dynamic=" + this.dynamic + ", expirationTime=" + this.expirationTime + ", hosts=" + this.hosts + ", agent=" + this.agent + "]";
    }
}

