/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.sh;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.sh.ClientShSession;
import org.jdiameter.api.sh.ClientShSessionListener;
import org.jdiameter.api.sh.events.ProfileUpdateAnswer;
import org.jdiameter.api.sh.events.ProfileUpdateRequest;
import org.jdiameter.api.sh.events.PushNotificationAnswer;
import org.jdiameter.api.sh.events.PushNotificationRequest;
import org.jdiameter.api.sh.events.SubscribeNotificationsAnswer;
import org.jdiameter.api.sh.events.SubscribeNotificationsRequest;
import org.jdiameter.api.sh.events.UserDataAnswer;
import org.jdiameter.api.sh.events.UserDataRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.sh.Event;
import org.jdiameter.client.impl.app.sh.IShClientSessionData;
import org.jdiameter.common.api.app.sh.IShMessageFactory;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.sh.ProfileUpdateAnswerImpl;
import org.jdiameter.common.impl.app.sh.PushNotificationRequestImpl;
import org.jdiameter.common.impl.app.sh.ShSession;
import org.jdiameter.common.impl.app.sh.SubscribeNotificationsAnswerImpl;
import org.jdiameter.common.impl.app.sh.UserDataAnswerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShClientSessionImpl
extends ShSession
implements ClientShSession,
EventListener<Request, Answer>,
NetworkReqListener {
    private Logger logger = LoggerFactory.getLogger(ShClientSessionImpl.class);
    protected Lock sendAndStateLock = new ReentrantLock();
    protected transient IShMessageFactory factory = null;
    protected transient ClientShSessionListener listener;
    protected IShClientSessionData sessionData;

    public ShClientSessionImpl(IShClientSessionData sessionData, IShMessageFactory fct, ISessionFactory sf, ClientShSessionListener lst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationId() < 0L) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.listener = lst;
        this.factory = fct;
        this.sessionData = sessionData;
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public <E> E getState(Class<E> stateType) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            Event localEvent = (Event)event;
            switch ((Event.Type)localEvent.getType()) {
                case RECEIVE_PUSH_NOTIFICATION_REQUEST: {
                    this.listener.doPushNotificationRequestEvent((ClientShSession)this, (PushNotificationRequest)new PushNotificationRequestImpl((Request)localEvent.getRequest().getMessage()));
                    return true;
                }
                case RECEIVE_PROFILE_UPDATE_ANSWER: {
                    this.listener.doProfileUpdateAnswerEvent((ClientShSession)this, (ProfileUpdateRequest)localEvent.getRequest(), (ProfileUpdateAnswer)new ProfileUpdateAnswerImpl((Answer)localEvent.getAnswer().getMessage()));
                    return true;
                }
                case RECEIVE_USER_DATA_ANSWER: {
                    this.listener.doUserDataAnswerEvent((ClientShSession)this, (UserDataRequest)localEvent.getRequest(), (UserDataAnswer)new UserDataAnswerImpl((Answer)localEvent.getAnswer().getMessage()));
                    return true;
                }
                case RECEIVE_SUBSCRIBE_NOTIFICATIONS_ANSWER: {
                    this.listener.doSubscribeNotificationsAnswerEvent((ClientShSession)this, (SubscribeNotificationsRequest)localEvent.getRequest(), (SubscribeNotificationsAnswer)new SubscribeNotificationsAnswerImpl((Answer)localEvent.getAnswer().getMessage()));
                    return true;
                }
                case SEND_PROFILE_UPDATE_REQUEST: 
                case SEND_PUSH_NOTIFICATION_ANSWER: 
                case SEND_SUBSCRIBE_NOTIFICATIONS_REQUEST: 
                case SEND_USER_DATA_REQUEST: {
                    Message m = null;
                    Object data = event.getData();
                    m = data instanceof AppEvent ? ((AppEvent)data).getMessage() : (Message)event.getData();
                    this.session.send(m, (EventListener)this);
                    return true;
                }
                case TIMEOUT_EXPIRES: {
                    return true;
                }
                default: {
                    this.logger.error("Wrong message type={} req={} ans={}", new Object[]{localEvent.getType(), localEvent.getRequest(), localEvent.getAnswer()});
                    return true;
                }
            }
        }
        catch (IllegalDiameterStateException idse) {
            throw new InternalException((Throwable)idse);
        }
        catch (RouteException re) {
            throw new InternalException((Throwable)re);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public void sendProfileUpdateRequest(ProfileUpdateRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_PROFILE_UPDATE_REQUEST, (AppEvent)request, null);
    }

    public void sendPushNotificationAnswer(PushNotificationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_PUSH_NOTIFICATION_ANSWER, null, (AppEvent)answer);
    }

    public void sendSubscribeNotificationsRequest(SubscribeNotificationsRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_SUBSCRIBE_NOTIFICATIONS_REQUEST, (AppEvent)request, null);
    }

    public void sendUserDataRequest(UserDataRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_USER_DATA_REQUEST, (AppEvent)request, null);
    }

    protected void send(Event.Type type, AppEvent request, AppEvent answer) throws InternalException {
        try {
            this.sendAndStateLock.lock();
            if (type != null) {
                this.handleEvent(new Event(type, request, answer));
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        try {
            if (request.getApplicationId() == this.factory.getApplicationId()) {
                if (request.getCommandCode() == 307) {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, (AppEvent)this.factory.createProfileUpdateRequest(request), null));
                    return;
                }
                if (request.getCommandCode() == 306) {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, (AppEvent)this.factory.createUserDataRequest(request), null));
                    return;
                }
                if (request.getCommandCode() == 308) {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, (AppEvent)this.factory.createSubscribeNotificationsRequest(request), null));
                    return;
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to process timeout message", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
            }
            catch (Exception e) {
                this.logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            this.logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    public boolean isStateless() {
        return true;
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    @Override
    public void onTimer(String timerName) {
    }

    private class AnswerDelivery
    implements Runnable {
        ClientShSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ShClientSessionImpl.this.sendAndStateLock.lock();
                if (this.request.getApplicationId() == ShClientSessionImpl.this.factory.getApplicationId()) {
                    if (this.request.getCommandCode() == 307) {
                        ShClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_PROFILE_UPDATE_ANSWER, (AppEvent)ShClientSessionImpl.this.factory.createProfileUpdateRequest(this.request), (AppEvent)ShClientSessionImpl.this.factory.createProfileUpdateAnswer(this.answer)));
                        return;
                    }
                    if (this.request.getCommandCode() == 306) {
                        ShClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_USER_DATA_ANSWER, (AppEvent)ShClientSessionImpl.this.factory.createUserDataRequest(this.request), (AppEvent)ShClientSessionImpl.this.factory.createUserDataAnswer(this.answer)));
                        return;
                    }
                    if (this.request.getCommandCode() == 308) {
                        ShClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_SUBSCRIBE_NOTIFICATIONS_ANSWER, (AppEvent)ShClientSessionImpl.this.factory.createSubscribeNotificationsRequest(this.request), (AppEvent)ShClientSessionImpl.this.factory.createSubscribeNotificationsAnswer(this.answer)));
                        return;
                    }
                }
                ShClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
            }
            catch (Exception e) {
                ShClientSessionImpl.this.logger.debug("Failed to process success message", (Throwable)e);
            }
            finally {
                ShClientSessionImpl.this.sendAndStateLock.unlock();
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ClientShSession session;
        Request request;

        private RequestDelivery() {
        }

        @Override
        public void run() {
            try {
                if (this.request.getApplicationId() == ShClientSessionImpl.this.factory.getApplicationId() && this.request.getCommandCode() == 309) {
                    ShClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_PUSH_NOTIFICATION_REQUEST, (AppEvent)ShClientSessionImpl.this.factory.createPushNotificationRequest(this.request), null));
                    return;
                }
                ShClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
            }
            catch (Exception e) {
                ShClientSessionImpl.this.logger.debug("Failed to process request {}", (Object)this.request, (Object)e);
            }
        }
    }
}

