/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.gq;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.auth.ClientAuthSession;
import org.jdiameter.api.auth.ClientAuthSessionListener;
import org.jdiameter.api.auth.events.AbortSessionAnswer;
import org.jdiameter.api.auth.events.AbortSessionRequest;
import org.jdiameter.api.auth.events.ReAuthAnswer;
import org.jdiameter.api.auth.events.ReAuthRequest;
import org.jdiameter.api.auth.events.SessionTermAnswer;
import org.jdiameter.api.auth.events.SessionTermRequest;
import org.jdiameter.api.gq.GqClientSession;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.auth.IClientAuthSessionData;
import org.jdiameter.client.impl.app.gq.Event;
import org.jdiameter.common.api.app.auth.ClientAuthSessionState;
import org.jdiameter.common.api.app.auth.IAuthMessageFactory;
import org.jdiameter.common.api.app.auth.IClientAuthActionContext;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.auth.AbortSessionAnswerImpl;
import org.jdiameter.common.impl.app.auth.AbortSessionRequestImpl;
import org.jdiameter.common.impl.app.auth.AppAuthSessionImpl;
import org.jdiameter.common.impl.app.auth.ReAuthAnswerImpl;
import org.jdiameter.common.impl.app.auth.ReAuthRequestImpl;
import org.jdiameter.common.impl.app.auth.SessionTermAnswerImpl;
import org.jdiameter.common.impl.app.auth.SessionTermRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GqClientSessionImpl
extends AppAuthSessionImpl
implements GqClientSession,
EventListener<Request, Answer>,
NetworkReqListener {
    protected static final Logger logger = LoggerFactory.getLogger(GqClientSessionImpl.class);
    protected Lock sendAndStateLock = new ReentrantLock();
    protected transient IAuthMessageFactory factory;
    protected transient IClientAuthActionContext context;
    protected transient ClientAuthSessionListener listener;
    protected static final String TIMER_NAME_TS = "GQ_TS";
    protected IClientAuthSessionData sessionData;

    public GqClientSessionImpl(IClientAuthSessionData sessionData, ISessionFactory sf, ClientAuthSessionListener lst, IAuthMessageFactory fct, StateChangeListener<AppSession> scListener, IClientAuthActionContext context, boolean stateless) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationId() == null) {
            throw new IllegalArgumentException("ApplicationId can not be null");
        }
        this.appId = fct.getApplicationId();
        this.listener = lst;
        this.factory = fct;
        this.context = context;
        this.sessionData = sessionData;
        this.sessionData.setStateless(stateless);
        super.addStateChangeNotification(scListener);
    }

    public void sendAbortSessionAnswer(AbortSessionAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_SESSION_ABORT_ANSWER, (AppEvent)answer);
    }

    public void sendAuthRequest(AppRequestEvent request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_AUTH_REQUEST, (AppEvent)request);
    }

    public void sendReAuthAnswer(ReAuthAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_AUTH_ANSWER, (AppEvent)answer);
    }

    public void sendSessionTerminationRequest(SessionTermRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_SESSION_TERMINATION_REQUEST, (AppEvent)request);
    }

    protected void send(Event.Type type, AppEvent event) throws InternalException {
        try {
            Avp destHostAvp;
            this.sendAndStateLock.lock();
            if (type != null) {
                this.handleEvent(new Event(type, event));
            }
            this.session.send(event.getMessage(), (EventListener)this);
            AvpSet avps = event.getMessage().getAvps();
            Avp destRealmAvp = avps.getAvp(283);
            if (destRealmAvp != null) {
                this.sessionData.setDestinationRealm(destRealmAvp.getDiameterIdentity());
            }
            if ((destHostAvp = avps.getAvp(293)) != null) {
                this.sessionData.setDestinationHost(destHostAvp.getDiameterIdentity());
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public boolean isStateless() {
        return this.sessionData.isStateless();
    }

    protected void setState(ClientAuthSessionState newState) {
        ClientAuthSessionState oldState = this.sessionData.getClientAuthSessionState();
        this.sessionData.setClientAuthSessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
    }

    public <E> E getState(Class<E> eClass) {
        return (E)(eClass == ClientAuthSessionState.class ? this.sessionData.getClientAuthSessionState() : null);
    }

    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        return this.sessionData.isStateless() ? this.handleEventForStatelessSession(event) : this.handleEventForStatefulSession(event);
    }

    public boolean handleEventForStatelessSession(StateEvent event) throws InternalException, OverloadException {
        try {
            ClientAuthSessionState state;
            ClientAuthSessionState oldState = state = this.sessionData.getClientAuthSessionState();
            block2 : switch (state) {
                case IDLE: {
                    switch ((Event.Type)event.getType()) {
                        case SEND_AUTH_REQUEST: {
                            this.setState(ClientAuthSessionState.PENDING);
                            break block2;
                        }
                    }
                    logger.debug("Unknown event [{}]", (Object)event.getType());
                    break;
                }
                case PENDING: {
                    switch ((Event.Type)event.getType()) {
                        case RECEIVE_AUTH_ANSWER: {
                            try {
                                this.listener.doAuthAnswerEvent((ClientAuthSession)this, null, (AppAnswerEvent)event.getData());
                                this.setState(ClientAuthSessionState.OPEN);
                            }
                            catch (Exception e) {
                                this.setState(ClientAuthSessionState.IDLE);
                            }
                            break block2;
                        }
                        case SEND_SESSION_TERMINATION_REQUEST: {
                            this.setState(ClientAuthSessionState.IDLE);
                            break block2;
                        }
                    }
                    logger.debug("Unknown event [{}]", (Object)event.getType());
                    break;
                }
                case OPEN: {
                    switch ((Event.Type)event.getType()) {
                        case SEND_SESSION_TERMINATION_REQUEST: 
                        case SEND_SESSION_ABORT_ANSWER: {
                            this.setState(ClientAuthSessionState.IDLE);
                            break block2;
                        }
                        case TIMEOUT_EXPIRES: {
                            if (this.context != null) {
                                this.context.accessTimeoutElapses((ClientAuthSession)this);
                                Request str = this.createSessionTermRequest();
                                this.context.disconnectUserOrDev((ClientAuthSession)this, (Message)str);
                                this.session.send((Message)str, (EventListener)this);
                            }
                            this.setState(ClientAuthSessionState.IDLE);
                            break block2;
                        }
                    }
                    logger.debug("Unknown event [{}]", (Object)event.getType());
                }
            }
            if (oldState != state) {
                if (ClientAuthSessionState.DISCONNECTED.equals(state) || ClientAuthSessionState.IDLE.equals(state)) {
                    this.cancelTsTimer();
                } else if (ClientAuthSessionState.OPEN.equals(state) && this.context != null && this.context.getAccessTimeout() > 0L) {
                    this.cancelTsTimer();
                    this.startTsTimer();
                }
            }
        }
        catch (Throwable t) {
            throw new InternalException(t);
        }
        return true;
    }

    public boolean handleEventForStatefulSession(StateEvent event) throws InternalException, OverloadException {
        ClientAuthSessionState state;
        ClientAuthSessionState oldState = state = this.sessionData.getClientAuthSessionState();
        try {
            block3 : switch (state) {
                case IDLE: {
                    switch ((Event.Type)event.getType()) {
                        case SEND_AUTH_REQUEST: {
                            this.setState(ClientAuthSessionState.PENDING);
                            break block3;
                        }
                        case RECEIVE_ABORT_SESSION_REQUEST: {
                            this.listener.doAbortSessionRequestEvent((ClientAuthSession)this, (AbortSessionRequest)event.getData());
                            break block3;
                        }
                    }
                    logger.debug("Unknown event [{}]", (Object)event.getType());
                    break;
                }
                case PENDING: {
                    switch ((Event.Type)event.getType()) {
                        case RECEIVE_AUTH_ANSWER: {
                            try {
                                this.listener.doAuthAnswerEvent((ClientAuthSession)this, null, (AppAnswerEvent)event.getData());
                                this.setState(ClientAuthSessionState.OPEN);
                            }
                            catch (InternalException e) {
                                this.setState(ClientAuthSessionState.DISCONNECTED);
                            }
                            catch (Exception e) {
                                this.setState(ClientAuthSessionState.IDLE);
                            }
                            break block3;
                        }
                        case SEND_SESSION_TERMINATION_REQUEST: {
                            this.setState(ClientAuthSessionState.DISCONNECTED);
                            break block3;
                        }
                    }
                    logger.debug("Unknown event [{}]", (Object)event.getType());
                    break;
                }
                case OPEN: {
                    switch ((Event.Type)event.getType()) {
                        case SEND_AUTH_REQUEST: {
                            break;
                        }
                        case RECEIVE_AUTH_ANSWER: {
                            try {
                                this.listener.doAuthAnswerEvent((ClientAuthSession)this, null, (AppAnswerEvent)event.getData());
                            }
                            catch (Exception e) {
                                this.setState(ClientAuthSessionState.DISCONNECTED);
                            }
                            break;
                        }
                        case RECEIVE_FAILED_AUTH_ANSWER: {
                            if (this.context != null) {
                                Request str = this.createSessionTermRequest();
                                this.context.disconnectUserOrDev((ClientAuthSession)this, (Message)str);
                                this.session.send((Message)str, (EventListener)this);
                            }
                            this.setState(ClientAuthSessionState.IDLE);
                            break;
                        }
                        case RECEIVE_ABORT_SESSION_REQUEST: {
                            this.listener.doAbortSessionRequestEvent((ClientAuthSession)this, (AbortSessionRequest)((AbortSessionRequestImpl)event.getData()));
                            break;
                        }
                        case SEND_SESSION_TERMINATION_REQUEST: {
                            this.setState(ClientAuthSessionState.DISCONNECTED);
                            break;
                        }
                        case TIMEOUT_EXPIRES: {
                            if (this.context != null) {
                                this.context.accessTimeoutElapses((ClientAuthSession)this);
                                Request str = this.createSessionTermRequest();
                                this.context.disconnectUserOrDev((ClientAuthSession)this, (Message)str);
                                this.session.send((Message)str, (EventListener)this);
                            }
                            this.setState(ClientAuthSessionState.DISCONNECTED);
                        }
                    }
                    break;
                }
                case DISCONNECTED: {
                    switch ((Event.Type)event.getType()) {
                        case RECEIVE_ABORT_SESSION_REQUEST: {
                            this.listener.doAbortSessionRequestEvent((ClientAuthSession)this, (AbortSessionRequest)event.getData());
                            break block3;
                        }
                        case RECEIVE_SESSION_TERINATION_ANSWER: {
                            this.listener.doSessionTerminationAnswerEvent((ClientAuthSession)this, (SessionTermAnswer)((SessionTermAnswerImpl)event.getData()));
                            this.setState(ClientAuthSessionState.IDLE);
                            break block3;
                        }
                    }
                    logger.debug("Unknown event [{}]", (Object)event.getType());
                    break;
                }
                default: {
                    logger.debug("Unknown state [{}]", (Object)state);
                }
            }
            if (oldState != state && ClientAuthSessionState.OPEN.equals(state) && this.context != null && this.context.getAccessTimeout() > 0L) {
                this.cancelTsTimer();
                this.startTsTimer();
            }
        }
        catch (Throwable t) {
            throw new InternalException(t);
        }
        return true;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery ad = new AnswerDelivery();
        ad.session = this;
        ad.request = request;
        ad.answer = answer;
        this.scheduler.execute(ad);
    }

    public void timeoutExpired(Request request) {
        try {
            this.handleEvent(new Event(Event.Type.RECEIVE_FAILED_AUTH_ANSWER, new AppRequestEventImpl((Message)request)));
        }
        catch (Exception e) {
            logger.debug("Can not handle timeout event", (Throwable)e);
        }
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTsTimer() throws IllegalArgumentException, InternalException {
        try {
            this.sendAndStateLock.lock();
            this.sessionData.setTsTimerId(this.timerFacility.schedule(this.sessionData.getSessionId(), TIMER_NAME_TS, this.context.getAccessTimeout()));
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTsTimer() {
        try {
            this.sendAndStateLock.lock();
            Serializable timerId = this.sessionData.getTsTimerId();
            if (timerId != null) {
                this.timerFacility.cancel(timerId);
                this.sessionData.setTsTimerId(null);
            }
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTimer(String timerName) {
        if (timerName.equals(TIMER_NAME_TS)) {
            try {
                this.sendAndStateLock.lock();
                this.sessionData.setTsTimerId(null);
                if (this.context != null) {
                    try {
                        this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, null));
                    }
                    catch (Exception e) {
                        logger.debug("Can not handle event", (Throwable)e);
                    }
                }
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        }
    }

    protected AbortSessionAnswer createAbortSessionAnswer(Answer answer) {
        return new AbortSessionAnswerImpl(answer);
    }

    protected AbortSessionRequest createAbortSessionRequest(Request request) {
        return new AbortSessionRequestImpl((Message)request);
    }

    protected ReAuthAnswer createReAuthAnswer(Answer answer) {
        return new ReAuthAnswerImpl(answer);
    }

    protected ReAuthRequest createReAuthRequest(Request request) {
        return new ReAuthRequestImpl((Message)request);
    }

    protected SessionTermAnswer createSessionTermAnswer(Answer answer) {
        return new SessionTermAnswerImpl(answer);
    }

    protected SessionTermRequest createSessionTermRequest(Request request) {
        return new SessionTermRequestImpl((Message)request);
    }

    protected Request createSessionTermRequest() {
        return this.session.createRequest(275, this.appId, this.sessionData.getDestinationRealm(), this.sessionData.getDestinationHost());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GqClientSessionImpl other = (GqClientSessionImpl)obj;
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }

    private class AnswerDelivery
    implements Runnable {
        GqClientSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                GqClientSessionImpl.this.sendAndStateLock.lock();
                if (this.answer.getCommandCode() == GqClientSessionImpl.this.factory.getAuthMessageCommandCode()) {
                    GqClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_AUTH_ANSWER, (AppEvent)GqClientSessionImpl.this.factory.createAuthAnswer(this.answer)));
                } else if (this.answer.getCommandCode() == 275) {
                    GqClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_SESSION_TERINATION_ANSWER, (AppEvent)GqClientSessionImpl.this.createSessionTermAnswer(this.answer)));
                } else {
                    GqClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, GqClientSessionImpl.this.factory.createAuthRequest(this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                }
            }
            catch (Exception e) {
                logger.debug("Can not process received message", (Throwable)e);
            }
            finally {
                GqClientSessionImpl.this.sendAndStateLock.unlock();
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        GqClientSession session;
        Request request;

        private RequestDelivery() {
        }

        @Override
        public void run() {
            try {
                if (this.request.getCommandCode() == 274) {
                    GqClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_ABORT_SESSION_REQUEST, (AppEvent)GqClientSessionImpl.this.createAbortSessionRequest(this.request)));
                } else if (this.request.getCommandCode() == 258) {
                    GqClientSessionImpl.this.listener.doReAuthRequestEvent((ClientAuthSession)this.session, GqClientSessionImpl.this.createReAuthRequest(this.request));
                } else {
                    GqClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, GqClientSessionImpl.this.factory.createAuthRequest(this.request), null);
                }
            }
            catch (Exception e) {
                logger.debug("Can not process received request", (Throwable)e);
            }
        }
    }
}

