/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.annotation.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdiameter.client.impl.annotation.internal.ClassInfo;
import org.jdiameter.client.impl.annotation.internal.Storage;

public class MethodInfo {
    private Storage storage;
    private Method method;
    private ClassInfo classInfo;
    private Collection<Annotation> annotationsCache;
    private Map<Class<?>, Annotation> annotationStorage;

    public MethodInfo(Storage storage, ClassInfo classInfo, Method method) {
        this.storage = storage;
        this.classInfo = classInfo;
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotationsCache == null ? (this.annotationsCache = this.getAnnotationStorage().values()) : this.annotationsCache;
    }

    public <T> T getAnnotation(Class<?> annotation) {
        for (Annotation a : this.getAnnotations()) {
            if (a.annotationType() != annotation) continue;
            return (T)a;
        }
        return null;
    }

    private Map<Class<?>, Annotation> getAnnotationStorage() {
        if (this.annotationStorage == null) {
            this.annotationStorage = new ConcurrentHashMap();
            Class<?> parent = this.getClassInfo().getAttachedClass().getSuperclass();
            if (parent != null) {
                this.addAnnotations(this.storage.getClassInfo(parent).getMethodInfo(this.getMethod().getName(), this.getMethod().getParameterTypes()));
            }
            for (Class<?> i : this.getClassInfo().getAttachedClass().getInterfaces()) {
                this.addAnnotations(this.storage.getClassInfo(i).getMethodInfo(this.getMethod().getName(), this.getMethod().getParameterTypes()));
            }
            for (Annotation a : this.getMethod().getDeclaredAnnotations()) {
                this.annotationStorage.put(a.getClass().getInterfaces()[0], a);
            }
        }
        return this.annotationStorage;
    }

    private void addAnnotations(MethodInfo method) {
        if (method != null) {
            for (Annotation annotation : method.getAnnotations()) {
                if (annotation == null) continue;
                for (Class<?> _interface : annotation.getClass().getInterfaces()) {
                    this.annotationStorage.put(_interface, annotation);
                }
            }
        }
    }
}

