/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.annotation.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdiameter.client.impl.annotation.internal.ClassInfo;
import org.jdiameter.client.impl.annotation.internal.Storage;

public class ConstructorInfo {
    private Storage storage;
    private Constructor constr;
    private ClassInfo classInfo;
    private Collection<Annotation> annotationsCache;
    private Map<Class<?>, Annotation> annotationStorage;

    public ConstructorInfo(Storage storage, ClassInfo classInfo, Constructor constr) {
        this.storage = storage;
        this.classInfo = classInfo;
        this.constr = constr;
    }

    public Constructor getConstructor() {
        return this.constr;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotationsCache == null ? (this.annotationsCache = this.getAnnotationStorage().values()) : this.annotationsCache;
    }

    private Map<Class<?>, Annotation> getAnnotationStorage() {
        if (this.annotationStorage == null) {
            this.annotationStorage = new ConcurrentHashMap();
            Class<?> parent = this.getClassInfo().getAttachedClass().getSuperclass();
            if (parent != null) {
                this.addAnnotations(this.storage.getClassInfo(parent).getConstructorInfo(this.getConstructor().getParameterTypes()));
            }
            for (Class<?> i : this.getClassInfo().getAttachedClass().getInterfaces()) {
                this.addAnnotations(this.storage.getClassInfo(i).getConstructorInfo(this.getConstructor().getParameterTypes()));
            }
            for (Annotation a : this.getConstructor().getDeclaredAnnotations()) {
                this.annotationStorage.put(a.getClass().getInterfaces()[0], a);
            }
        }
        return this.annotationStorage;
    }

    private void addAnnotations(ConstructorInfo constr) {
        if (constr != null) {
            for (Annotation annotation : constr.getAnnotations()) {
                if (annotation == null) continue;
                for (Class<?> _interface : annotation.getClass().getInterfaces()) {
                    this.annotationStorage.put(_interface, annotation);
                }
            }
        }
    }

    public <T> T getAnnotation(Class<?> annotation) {
        for (Annotation a : this.getAnnotations()) {
            if (a.annotationType() != annotation) continue;
            return (T)a;
        }
        return null;
    }
}

