/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.annotation.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdiameter.client.impl.annotation.internal.ConstructorInfo;
import org.jdiameter.client.impl.annotation.internal.MethodInfo;
import org.jdiameter.client.impl.annotation.internal.Storage;

public class ClassInfo {
    private Storage storage;
    private Class<?> _class;
    private Map<Class<?>, Annotation> annotations;
    private Map<Method, MethodInfo> methods;
    private Map<Constructor, ConstructorInfo> constructors;
    private Collection<Annotation> classCache;
    private Collection<MethodInfo> methodCache;
    private Collection<ConstructorInfo> constructorCache;

    public ClassInfo(Storage storage, Class<?> _class) {
        this.storage = storage;
        this._class = _class;
    }

    public Class<?> getAttachedClass() {
        return this._class;
    }

    public Collection<Annotation> getAnnotations() {
        if (this.classCache == null) {
            if (this.annotations == null) {
                this.annotations = new ConcurrentHashMap();
                Class<?> parent = this.getAttachedClass().getSuperclass();
                if (parent != null) {
                    this.addAnnotations(parent);
                }
                for (Class<?> i : this.getAttachedClass().getInterfaces()) {
                    this.addAnnotations(i);
                }
                for (Annotation a : this.getAttachedClass().getDeclaredAnnotations()) {
                    this.annotations.put(a.getClass().getInterfaces()[0], a);
                }
            }
            this.classCache = this.annotations.values();
        }
        return this.classCache;
    }

    public <T> T getAnnotation(Class<?> annotation) {
        for (Annotation a : this.getAnnotations()) {
            if (a.annotationType() != annotation) continue;
            return (T)a;
        }
        return null;
    }

    private void addAnnotations(Class<?> _class) {
        for (Annotation annotation : this.storage.getClassInfo(_class).getAnnotations()) {
            if (annotation == null) continue;
            for (Class<?> _interface : annotation.getClass().getInterfaces()) {
                this.annotations.put(_interface, annotation);
            }
        }
    }

    public MethodInfo getMethodInfo(String methodName, Class<?> ... args) {
        try {
            return this.getMethodInfo(this.getAttachedClass().getMethod(methodName, args));
        }
        catch (Exception e) {
            return null;
        }
    }

    public ConstructorInfo getConstructorInfo(Class<?> ... args) {
        try {
            return this.getConstructorInfo(this.getAttachedClass().getConstructor(args));
        }
        catch (Exception e1) {
            try {
                return this.getConstructorInfo(this.getAttachedClass().getConstructor(Object.class));
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public MethodInfo getMethodInfo(Method method) {
        return this.getMethodMap().get(method);
    }

    public ConstructorInfo getConstructorInfo(Constructor constr) {
        return this.getConstructorMap().get(constr);
    }

    public Collection<MethodInfo> getMethodsInfo() {
        return this.methodCache == null ? (this.methodCache = this.getMethodMap().values()) : this.methodCache;
    }

    public Collection<ConstructorInfo> getConstructorsInfo() {
        return this.constructorCache == null ? (this.constructorCache = this.getConstructorMap().values()) : this.constructorCache;
    }

    private Map<Method, MethodInfo> getMethodMap() {
        if (this.methods == null) {
            this.methods = new ConcurrentHashMap<Method, MethodInfo>();
            for (Method method : this.getAttachedClass().getMethods()) {
                this.methods.put(method, new MethodInfo(this.storage, this, method));
            }
        }
        return this.methods;
    }

    private Map<Constructor, ConstructorInfo> getConstructorMap() {
        if (this.constructors == null) {
            this.constructors = new ConcurrentHashMap<Constructor, ConstructorInfo>();
            for (Constructor<?> constr : this.getAttachedClass().getConstructors()) {
                this.constructors.put(constr, new ConstructorInfo(this.storage, this, constr));
            }
        }
        return this.constructors;
    }
}

