/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.RawSession;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.api.StackState;
import org.jdiameter.client.impl.RawSessionImpl;
import org.jdiameter.client.impl.SessionImpl;
import org.jdiameter.client.impl.helpers.UIDGenerator;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.common.api.data.ISessionDatasource;

public class SessionFactoryImpl
implements ISessionFactory {
    private IContainer stack;
    private Map<Class, IAppSessionFactory> appFactories = new ConcurrentHashMap<Class, IAppSessionFactory>();
    private ISessionDatasource dataSource;
    protected static UIDGenerator uid = new UIDGenerator();

    public SessionFactoryImpl(IContainer stack) {
        this.stack = stack;
        this.dataSource = this.stack.getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
    }

    public String getSessionId(String custom) {
        long id = uid.nextLong();
        long high32 = (id & 0xFFFFFFFF00000000L) >> 32;
        long low32 = id & 0xFFFFFFFFL;
        StringBuilder sb = new StringBuilder();
        sb.append(this.stack.getMetaData().getLocalPeer().getUri().getFQDN()).append(";").append(high32).append(";").append(low32);
        if (custom != null) {
            sb.append(";").append(custom);
        }
        return sb.toString();
    }

    public String getSessionId() {
        return this.getSessionId(null);
    }

    public RawSession getNewRawSession() throws InternalException {
        if (this.stack.getState() == StackState.IDLE) {
            throw new InternalException("Illegal state of stack");
        }
        return new RawSessionImpl(this.stack);
    }

    public Session getNewSession() throws InternalException {
        if (this.stack.getState() == StackState.IDLE) {
            throw new InternalException("Illegal state of stack");
        }
        SessionImpl session = new SessionImpl(this.stack);
        this.dataSource.addSession(session);
        return session;
    }

    public Session getNewSession(String sessionId) throws InternalException {
        if (this.stack.getState() == StackState.IDLE) {
            throw new InternalException("Illegal state of stack");
        }
        SessionImpl session = new SessionImpl(this.stack);
        if (sessionId != null && sessionId.length() > 0) {
            session.sessionId = sessionId;
        }
        this.dataSource.addSession(session);
        return session;
    }

    public <T extends AppSession> T getNewAppSession(ApplicationId applicationId, Class<? extends AppSession> aClass) throws InternalException {
        return this.getNewAppSession(null, applicationId, aClass, new Object[0]);
    }

    public <T extends AppSession> T getNewAppSession(String sessionId, ApplicationId applicationId, Class<? extends AppSession> aClass) throws InternalException {
        return this.getNewAppSession(sessionId, applicationId, aClass, new Object[0]);
    }

    @Override
    public <T extends AppSession> T getNewAppSession(String sessionId, ApplicationId applicationId, Class<? extends AppSession> aClass, Object ... args) throws InternalException {
        AppSession session = null;
        if (this.stack.getState() == StackState.IDLE) {
            throw new InternalException("Illegal state of stack");
        }
        if (this.appFactories.containsKey(aClass)) {
            session = this.appFactories.get(aClass).getNewSession(sessionId, aClass, applicationId, args);
        }
        return (T)session;
    }

    @Override
    public void registerAppFacory(Class<? extends AppSession> sessionClass, IAppSessionFactory factory) {
        this.appFactories.put(sessionClass, factory);
    }

    @Override
    public void unRegisterAppFacory(Class<? extends AppSession> sessionClass) {
        this.appFactories.remove(sessionClass);
    }

    @Override
    public IAppSessionFactory getAppSessionFactory(Class<? extends AppSession> sessionClass) {
        return this.appFactories.get(sessionClass);
    }

    @Override
    public IContainer getContainer() {
        return this.stack;
    }
}

