/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.fsm;

import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.ConfigurationListener;
import org.jdiameter.api.Message;
import org.jdiameter.api.MutableConfiguration;
import org.jdiameter.api.app.State;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.fsm.IContext;
import org.jdiameter.client.impl.fsm.FsmState;
import org.jdiameter.client.impl.fsm.PeerFSMImpl;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.server.api.IStateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerFSMImpl
extends org.jdiameter.client.impl.fsm.PeerFSMImpl
implements IStateMachine,
ConfigurationListener {
    private static final Logger logger = LoggerFactory.getLogger(PeerFSMImpl.class);

    public PeerFSMImpl(IContext context, IConcurrentFactory concurrentFactory, Configuration config, IStatisticManager statisticFactory) {
        super(context, concurrentFactory, config, statisticFactory);
    }

    protected void loadTimeOuts(Configuration config) {
        super.loadTimeOuts(config);
        if (config instanceof MutableConfiguration) {
            ((MutableConfiguration)config).addChangeListener((ConfigurationListener)this, new int[]{0});
        }
    }

    public boolean elementChanged(int i, Object data) {
        Configuration newConfig = (Configuration)data;
        super.loadTimeOuts(newConfig);
        return true;
    }

    protected State[] getStates() {
        if (this.states == null) {
            this.states = new State[]{new PeerFSMImpl.MyState(){

                public void entryAction() {
                    PeerFSMImpl.this.setInActiveTimer();
                    PeerFSMImpl.this.watchdogSent = false;
                }

                public boolean processEvent(StateEvent event) {
                    switch (this.type(event)) {
                        case DISCONNECT_EVENT: {
                            this.doEndConnection();
                            break;
                        }
                        case TIMEOUT_EVENT: {
                            try {
                                PeerFSMImpl.this.context.sendDwrMessage();
                                this.setTimer(PeerFSMImpl.this.DWA_TIMEOUT);
                                if (PeerFSMImpl.this.watchdogSent) {
                                    PeerFSMImpl.this.switchToNextState(FsmState.SUSPECT);
                                    break;
                                }
                                PeerFSMImpl.this.watchdogSent = true;
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DWR", e);
                                this.doDisconnect();
                                this.doEndConnection();
                            }
                            break;
                        }
                        case STOP_EVENT: {
                            try {
                                if (event.getData() == null) {
                                    PeerFSMImpl.this.context.sendDprMessage(1);
                                } else {
                                    Integer disconnectCause = (Integer)event.getData();
                                    PeerFSMImpl.this.context.sendDprMessage(disconnectCause);
                                }
                                this.setTimer(PeerFSMImpl.this.DPA_TIMEOUT);
                                PeerFSMImpl.this.switchToNextState(FsmState.STOPPING);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DPR", e);
                                this.doDisconnect();
                                PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            }
                            break;
                        }
                        case RECEIVE_MSG_EVENT: {
                            PeerFSMImpl.this.setInActiveTimer();
                            PeerFSMImpl.this.context.receiveMessage(this.message(event));
                            break;
                        }
                        case CEA_EVENT: {
                            PeerFSMImpl.this.setInActiveTimer();
                            if (!PeerFSMImpl.this.context.processCeaMessage(this.key(event), this.message(event))) break;
                            this.doDisconnect();
                            this.doEndConnection();
                            break;
                        }
                        case CER_EVENT: {
                            logger.debug("Rejecting CER in OKAY state. Answering with UNABLE_TO_COMPLY (5012)");
                            try {
                                PeerFSMImpl.this.context.sendCeaMessage(5012, (Message)this.message(event), "Unable to receive CER in OPEN state.");
                            }
                            catch (Exception e) {
                                logger.debug("Failed to send CEA.", (Throwable)e);
                                this.doDisconnect();
                                this.doEndConnection();
                            }
                            break;
                        }
                        case DPR_EVENT: {
                            try {
                                int code = PeerFSMImpl.this.context.processDprMessage((IMessage)event.getData());
                                PeerFSMImpl.this.context.sendDpaMessage(this.message(event), code, null);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DPA", e);
                            }
                            IMessage message = (IMessage)event.getData();
                            try {
                                boolean willReconnect;
                                Avp discCause = message.getAvps().getAvp(273);
                                boolean bl = discCause != null ? discCause.getInteger32() == 0 : (willReconnect = false);
                                if (willReconnect) {
                                    this.doDisconnect();
                                    this.doEndConnection();
                                    break;
                                }
                                this.doDisconnect();
                                PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            }
                            catch (AvpDataException ade) {
                                logger.warn("Disconnect cause is bad.", (Throwable)ade);
                                this.doDisconnect();
                                PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            }
                            break;
                        }
                        case DWR_EVENT: {
                            PeerFSMImpl.this.setInActiveTimer();
                            try {
                                PeerFSMImpl.this.context.sendDwaMessage(this.message(event), 2001, null);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DWA, reconnecting", e);
                                this.doDisconnect();
                                this.doEndConnection();
                            }
                            break;
                        }
                        case DWA_EVENT: {
                            PeerFSMImpl.this.setInActiveTimer();
                            PeerFSMImpl.this.watchdogSent = false;
                            break;
                        }
                        case SEND_MSG_EVENT: {
                            try {
                                PeerFSMImpl.this.context.sendMessage(this.message(event));
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send message", e);
                                this.doDisconnect();
                                this.doEndConnection();
                            }
                            break;
                        }
                        default: {
                            logger.debug("Unknown event type {} in state {}", (Object)this.type(event), (Object)PeerFSMImpl.this.state);
                            return false;
                        }
                    }
                    return true;
                }
            }, new PeerFSMImpl.MyState(){

                public boolean processEvent(StateEvent event) {
                    switch (this.type(event)) {
                        case DISCONNECT_EVENT: {
                            this.doEndConnection();
                            break;
                        }
                        case TIMEOUT_EVENT: {
                            this.doDisconnect();
                            this.doEndConnection();
                            break;
                        }
                        case STOP_EVENT: {
                            try {
                                if (event.getData() == null) {
                                    PeerFSMImpl.this.context.sendDprMessage(0);
                                } else {
                                    Integer disconnectCause = (Integer)event.getData();
                                    PeerFSMImpl.this.context.sendDprMessage(disconnectCause);
                                }
                                PeerFSMImpl.this.setInActiveTimer();
                                PeerFSMImpl.this.switchToNextState(FsmState.STOPPING);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DPR", e);
                                this.doDisconnect();
                                PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            }
                            break;
                        }
                        case CEA_EVENT: 
                        case CER_EVENT: 
                        case DWA_EVENT: {
                            this.clearTimer();
                            PeerFSMImpl.this.switchToNextState(FsmState.OKAY);
                            break;
                        }
                        case DPR_EVENT: {
                            try {
                                int code = PeerFSMImpl.this.context.processDprMessage((IMessage)event.getData());
                                PeerFSMImpl.this.context.sendDpaMessage(this.message(event), code, null);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DPA", e);
                            }
                            IMessage message = (IMessage)event.getData();
                            try {
                                if (message.getAvps().getAvp(273) != null && message.getAvps().getAvp(273).getInteger32() == 0) {
                                    this.doDisconnect();
                                    this.doEndConnection();
                                    break;
                                }
                                this.doDisconnect();
                                PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            }
                            catch (AvpDataException e1) {
                                logger.warn("Disconnect cause is bad.", (Throwable)e1);
                                this.doDisconnect();
                                PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            }
                            break;
                        }
                        case DWR_EVENT: {
                            try {
                                int code = PeerFSMImpl.this.context.processDwrMessage((IMessage)event.getData());
                                PeerFSMImpl.this.context.sendDwaMessage(this.message(event), code, null);
                                PeerFSMImpl.this.switchToNextState(FsmState.OKAY);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send DWA", e);
                                this.doDisconnect();
                                PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            }
                            break;
                        }
                        case RECEIVE_MSG_EVENT: {
                            this.clearTimer();
                            PeerFSMImpl.this.context.receiveMessage(this.message(event));
                            PeerFSMImpl.this.switchToNextState(FsmState.OKAY);
                            break;
                        }
                        case SEND_MSG_EVENT: {
                            throw new IllegalStateException("Connection is down");
                        }
                        default: {
                            logger.debug("Unknown event type {} in state {}", (Object)this.type(event), (Object)PeerFSMImpl.this.state);
                            return false;
                        }
                    }
                    return true;
                }
            }, new PeerFSMImpl.MyState(){

                public void entryAction() {
                    this.setTimer(0L);
                    PeerFSMImpl.this.mustRun = false;
                    PeerFSMImpl.this.context.removeStatistics();
                }

                public boolean processEvent(StateEvent event) {
                    switch (this.type(event)) {
                        case START_EVENT: {
                            try {
                                PeerFSMImpl.this.context.createStatistics();
                                if (!PeerFSMImpl.this.context.isConnected()) {
                                    PeerFSMImpl.this.context.connect();
                                }
                                PeerFSMImpl.this.context.sendCerMessage();
                                this.setTimer(PeerFSMImpl.this.CEA_TIMEOUT);
                                PeerFSMImpl.this.switchToNextState(FsmState.INITIAL);
                            }
                            catch (Throwable e) {
                                logger.debug("Connect error", e);
                                this.doEndConnection();
                            }
                            break;
                        }
                        case CER_EVENT: {
                            PeerFSMImpl.this.context.createStatistics();
                            int resultCode = PeerFSMImpl.this.context.processCerMessage(this.key(event), this.message(event));
                            if (resultCode == 2001) {
                                try {
                                    PeerFSMImpl.this.context.sendCeaMessage(resultCode, (Message)this.message(event), null);
                                    PeerFSMImpl.this.switchToNextState(FsmState.OKAY);
                                }
                                catch (Exception e) {
                                    logger.debug("Failed to send CEA.", (Throwable)e);
                                    this.doDisconnect();
                                    this.doEndConnection();
                                }
                                break;
                            }
                            try {
                                PeerFSMImpl.this.context.sendCeaMessage(resultCode, (Message)this.message(event), null);
                            }
                            catch (Exception e) {
                                logger.debug("Failed to send CEA.", (Throwable)e);
                            }
                            this.doDisconnect();
                            this.doEndConnection();
                            break;
                        }
                        case SEND_MSG_EVENT: {
                            throw new IllegalStateException("Connection is down");
                        }
                        case DISCONNECT_EVENT: 
                        case TIMEOUT_EVENT: 
                        case STOP_EVENT: {
                            break;
                        }
                        default: {
                            logger.debug("Unknown event type {} in state {}", (Object)this.type(event), (Object)PeerFSMImpl.this.state);
                            return false;
                        }
                    }
                    return true;
                }
            }, new PeerFSMImpl.MyState(){

                public boolean processEvent(StateEvent event) {
                    switch (this.type(event)) {
                        case CONNECT_EVENT: {
                            try {
                                PeerFSMImpl.this.context.sendCerMessage();
                                this.setTimer(PeerFSMImpl.this.CEA_TIMEOUT);
                                PeerFSMImpl.this.switchToNextState(FsmState.INITIAL);
                            }
                            catch (Throwable e) {
                                logger.debug("Can not send CER", e);
                                this.setTimer(PeerFSMImpl.this.REC_TIMEOUT);
                            }
                            break;
                        }
                        case TIMEOUT_EVENT: {
                            try {
                                PeerFSMImpl.this.context.connect();
                            }
                            catch (Exception e) {
                                logger.debug("Can not connect to remote peer", (Throwable)e);
                                this.setTimer(PeerFSMImpl.this.REC_TIMEOUT);
                            }
                            break;
                        }
                        case STOP_EVENT: {
                            this.setTimer(0L);
                            this.doDisconnect();
                            PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            break;
                        }
                        case DISCONNECT_EVENT: {
                            break;
                        }
                        case SEND_MSG_EVENT: {
                            throw new IllegalStateException("Connection is down");
                        }
                        default: {
                            logger.debug("Unknown event type {} in state {}", (Object)this.type(event), (Object)PeerFSMImpl.this.state);
                            return false;
                        }
                    }
                    return true;
                }
            }, new PeerFSMImpl.MyState(){

                public void entryAction() {
                    this.setTimer(PeerFSMImpl.this.CEA_TIMEOUT);
                }

                public boolean processEvent(StateEvent event) {
                    switch (this.type(event)) {
                        case DISCONNECT_EVENT: {
                            this.setTimer(0L);
                            this.doEndConnection();
                            break;
                        }
                        case TIMEOUT_EVENT: {
                            this.doDisconnect();
                            this.doEndConnection();
                            break;
                        }
                        case STOP_EVENT: {
                            this.setTimer(0L);
                            this.doDisconnect();
                            PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            break;
                        }
                        case CEA_EVENT: {
                            this.setTimer(0L);
                            if (PeerFSMImpl.this.context.processCeaMessage(this.key(event), this.message(event))) {
                                PeerFSMImpl.this.switchToNextState(FsmState.OKAY);
                                break;
                            }
                            this.doDisconnect();
                            this.doEndConnection();
                            break;
                        }
                        case CER_EVENT: {
                            int resultCode = PeerFSMImpl.this.context.processCerMessage(this.key(event), this.message(event));
                            if (resultCode == 2001) {
                                try {
                                    PeerFSMImpl.this.context.sendCeaMessage(resultCode, (Message)this.message(event), null);
                                    PeerFSMImpl.this.switchToNextState(FsmState.OKAY);
                                }
                                catch (Exception e) {
                                    logger.debug("Can not send CEA", (Throwable)e);
                                    this.doDisconnect();
                                    this.doEndConnection();
                                }
                                break;
                            }
                            if (resultCode != -1 && resultCode != 5010) break;
                            this.doDisconnect();
                            this.doEndConnection();
                            break;
                        }
                        case SEND_MSG_EVENT: {
                            throw new IllegalStateException("Connection is down");
                        }
                        default: {
                            logger.debug("Unknown event type {} in state {}", (Object)this.type(event), (Object)PeerFSMImpl.this.state);
                            return false;
                        }
                    }
                    return true;
                }
            }, new PeerFSMImpl.MyState(){

                public boolean processEvent(StateEvent event) {
                    switch (this.type(event)) {
                        case TIMEOUT_EVENT: 
                        case DPA_EVENT: {
                            PeerFSMImpl.this.switchToNextState(FsmState.DOWN);
                            break;
                        }
                        case RECEIVE_MSG_EVENT: {
                            PeerFSMImpl.this.context.receiveMessage(this.message(event));
                            break;
                        }
                        case SEND_MSG_EVENT: {
                            throw new IllegalStateException("Stack now is stopping");
                        }
                        case DISCONNECT_EVENT: 
                        case STOP_EVENT: {
                            break;
                        }
                        default: {
                            logger.debug("Unknown event type {} in state {}", (Object)this.type(event), (Object)PeerFSMImpl.this.state);
                            return false;
                        }
                    }
                    return true;
                }
            }};
        }
        return this.states;
    }
}

