/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.s6a;

import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.s6a.ServerS6aSession;
import org.jdiameter.api.s6a.ServerS6aSessionListener;
import org.jdiameter.api.s6a.events.JAuthenticationInformationAnswer;
import org.jdiameter.api.s6a.events.JCancelLocationRequest;
import org.jdiameter.api.s6a.events.JDeleteSubscriberDataRequest;
import org.jdiameter.api.s6a.events.JInsertSubscriberDataRequest;
import org.jdiameter.api.s6a.events.JNotifyAnswer;
import org.jdiameter.api.s6a.events.JPurgeUEAnswer;
import org.jdiameter.api.s6a.events.JResetRequest;
import org.jdiameter.api.s6a.events.JUpdateLocationAnswer;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.s6a.IS6aMessageFactory;
import org.jdiameter.common.api.app.s6a.S6aSessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.s6a.S6aSession;
import org.jdiameter.server.impl.app.s6a.Event;
import org.jdiameter.server.impl.app.s6a.IServerS6aSessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S6aServerSessionImpl
extends S6aSession
implements ServerS6aSession,
EventListener<Request, Answer>,
NetworkReqListener {
    private static final Logger logger = LoggerFactory.getLogger(S6aServerSessionImpl.class);
    private transient ServerS6aSessionListener listener;
    protected long appId = -1L;
    protected IServerS6aSessionData sessionData;

    public S6aServerSessionImpl(IServerS6aSessionData sessionData, IS6aMessageFactory fct, ISessionFactory sf, ServerS6aSessionListener lst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        this.appId = fct.getApplicationId();
        if (this.appId < 0L) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.listener = lst;
        this.messageFactory = fct;
        this.sessionData = sessionData;
    }

    public void sendAuthenticationInformationAnswer(JAuthenticationInformationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, null, (AppEvent)answer);
    }

    public void sendPurgeUEAnswer(JPurgeUEAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, null, (AppEvent)answer);
    }

    public void sendUpdateLocationAnswer(JUpdateLocationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, null, (AppEvent)answer);
    }

    public void sendNotifyAnswer(JNotifyAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, null, (AppEvent)answer);
    }

    public void sendCancelLocationRequest(JCancelLocationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void sendInsertSubscriberDataRequest(JInsertSubscriberDataRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void sendDeleteSubscriberDataRequest(JDeleteSubscriberDataRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void sendResetRequest(JResetRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public <E> E getState(Class<E> stateType) {
        return (E)((Object)(stateType == S6aSessionState.class ? this.sessionData.getS6aSessionState() : null));
    }

    /*
     * Exception decompiling
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        try {
            this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)request), null));
        }
        catch (Exception e) {
            logger.debug("Failed to process timeout message", (Throwable)e);
        }
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    protected void send(Event.Type type, AppEvent request, AppEvent answer) throws InternalException {
        try {
            if (type != null) {
                this.handleEvent(new Event(type, request, answer));
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    protected void setState(S6aSessionState newState) {
        S6aSessionState oldState = this.sessionData.getS6aSessionState();
        this.sessionData.setS6aSessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
        if (newState == S6aSessionState.TERMINATED || newState == S6aSessionState.TIMEDOUT) {
            super.cancelMsgTimer();
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTimer(String timerName) {
        if (timerName.equals("MSG_TIMEOUT")) {
            try {
                this.sendAndStateLock.lock();
                try {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)this.sessionData.getBuffer()), null));
                }
                catch (Exception e) {
                    logger.debug("Failure handling Timeout event.");
                }
                this.sessionData.setBuffer(null);
                this.sessionData.setTsTimerId(null);
                Object var4_3 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                try {
                    this.sendAndStateLock.lock();
                    super.release();
                }
                catch (Exception e) {
                    logger.debug("Failed to release session", (Throwable)e);
                    Object var3_2 = null;
                    this.sendAndStateLock.unlock();
                }
                Object var3_1 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    private class AnswerDelivery
    implements Runnable {
        ServerS6aSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        public void run() {
            try {
                switch (this.answer.getCommandCode()) {
                    case 317: {
                        S6aServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_CLA, (AppEvent)S6aServerSessionImpl.this.messageFactory.createCancelLocationRequest(this.request), (AppEvent)S6aServerSessionImpl.this.messageFactory.createCancelLocationAnswer(this.answer)));
                        break;
                    }
                    case 319: {
                        S6aServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_IDA, (AppEvent)S6aServerSessionImpl.this.messageFactory.createInsertSubscriberDataRequest(this.request), (AppEvent)S6aServerSessionImpl.this.messageFactory.createInsertSubscriberDataAnswer(this.answer)));
                        break;
                    }
                    case 320: {
                        S6aServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_DSA, (AppEvent)S6aServerSessionImpl.this.messageFactory.createDeleteSubscriberDataRequest(this.request), (AppEvent)S6aServerSessionImpl.this.messageFactory.createDeleteSubscriberDataAnswer(this.answer)));
                        break;
                    }
                    case 322: {
                        S6aServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_RSA, (AppEvent)S6aServerSessionImpl.this.messageFactory.createResetRequest(this.request), (AppEvent)S6aServerSessionImpl.this.messageFactory.createResetAnswer(this.answer)));
                        break;
                    }
                    default: {
                        S6aServerSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ServerS6aSession session;
        Request request;

        private RequestDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 318: {
                        S6aServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_AIR, (AppEvent)S6aServerSessionImpl.this.messageFactory.createAuthenticationInformationRequest(this.request), null));
                        break;
                    }
                    case 321: {
                        S6aServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_PUR, (AppEvent)S6aServerSessionImpl.this.messageFactory.createPurgeUERequest(this.request), null));
                        break;
                    }
                    case 316: {
                        S6aServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_ULR, (AppEvent)S6aServerSessionImpl.this.messageFactory.createUpdateLocationRequest(this.request), null));
                        break;
                    }
                    case 323: {
                        S6aServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_NOR, (AppEvent)S6aServerSessionImpl.this.messageFactory.createNotifyRequest(this.request), null));
                        break;
                    }
                    default: {
                        S6aServerSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }
}

