/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.rx;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.rx.ServerRxSession;
import org.jdiameter.api.rx.ServerRxSessionListener;
import org.jdiameter.api.rx.events.RxAAAnswer;
import org.jdiameter.api.rx.events.RxAARequest;
import org.jdiameter.api.rx.events.RxAbortSessionAnswer;
import org.jdiameter.api.rx.events.RxAbortSessionRequest;
import org.jdiameter.api.rx.events.RxReAuthAnswer;
import org.jdiameter.api.rx.events.RxReAuthRequest;
import org.jdiameter.api.rx.events.RxSessionTermAnswer;
import org.jdiameter.api.rx.events.RxSessionTermRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.rx.IRxMessageFactory;
import org.jdiameter.common.api.app.rx.IServerRxSessionContext;
import org.jdiameter.common.api.app.rx.ServerRxSessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.rx.AppRxSessionImpl;
import org.jdiameter.server.impl.app.rx.Event;
import org.jdiameter.server.impl.app.rx.IServerRxSessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerRxSessionImpl
extends AppRxSessionImpl
implements ServerRxSession,
NetworkReqListener,
EventListener<Request, Answer> {
    private static final Logger logger = LoggerFactory.getLogger(ServerRxSessionImpl.class);
    protected Lock sendAndStateLock = new ReentrantLock();
    protected transient IRxMessageFactory factory = null;
    protected transient IServerRxSessionContext context = null;
    protected transient ServerRxSessionListener listener = null;
    protected long[] authAppIds = new long[]{4L};
    protected IServerRxSessionData sessionData;

    public ServerRxSessionImpl(IServerRxSessionData sessionData, IRxMessageFactory fct, ISessionFactory sf, ServerRxSessionListener lst, IServerRxSessionContext ctx, StateChangeListener<AppSession> stLst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationIds() == null) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.context = ctx;
        this.authAppIds = fct.getApplicationIds();
        this.listener = lst;
        this.factory = fct;
        this.sessionData = sessionData;
        super.addStateChangeNotification(stLst);
    }

    public void sendAAAnswer(RxAAAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.handleEvent(new Event(false, null, (AppAnswerEvent)answer));
    }

    public void sendSessionTermAnswer(RxSessionTermAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.handleEvent(new Event(false, null, (AppAnswerEvent)answer));
    }

    public void sendReAuthRequest(RxReAuthRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_RAR, (AppRequestEvent)request, null);
    }

    public void sendAbortSessionRequest(RxAbortSessionRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_ASR, (AppRequestEvent)request, null);
    }

    public boolean isStateless() {
        return this.sessionData.isStateless();
    }

    public <E> E getState(Class<E> stateType) {
        return (E)(stateType == ServerRxSessionState.class ? this.sessionData.getServerRxSessionState() : null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        newState = null;
        try {
            try {
                this.sendAndStateLock.lock();
                localEvent = (Event)event;
                state = this.sessionData.getServerRxSessionState();
                eventType = (Event.Type)localEvent.getType();
                block6 : switch (1.$SwitchMap$org$jdiameter$common$api$app$rx$ServerRxSessionState[state.ordinal()]) {
                    case 1: {
                        switch (1.$SwitchMap$org$jdiameter$server$impl$app$rx$Event$Type[eventType.ordinal()]) {
                            case 1: {
                                this.listener.doAARequest((ServerRxSession)this, (RxAARequest)localEvent.getRequest());
                                break block6;
                            }
                            case 2: {
                                this.listener.doAARequest((ServerRxSession)this, (RxAARequest)localEvent.getRequest());
                                break block6;
                            }
                            case 3: {
                                answer = (RxAAAnswer)localEvent.getAnswer();
                                try {
                                    resultCode = answer.getResultCodeAvp().getUnsigned32();
                                    newState = this.isSuccess(resultCode) != false ? ServerRxSessionState.OPEN : ServerRxSessionState.IDLE;
                                    this.dispatchEvent(localEvent.getAnswer());
                                    break block6;
                                }
                                catch (AvpDataException e) {
                                    throw new InternalException((Throwable)e);
                                }
                            }
                        }
                        throw new InternalException("Wrong state: " + ServerRxSessionState.IDLE + " one event: " + (Object)eventType + " " + localEvent.getRequest() + " " + localEvent.getAnswer());
                    }
                    case 2: {
                        switch (1.$SwitchMap$org$jdiameter$server$impl$app$rx$Event$Type[eventType.ordinal()]) {
                            case 1: {
                                this.listener.doAARequest((ServerRxSession)this, (RxAARequest)localEvent.getRequest());
                                break;
                            }
                            case 3: {
                                answer = (RxAAAnswer)localEvent.getAnswer();
                                try {
                                    if (!this.isSuccess(answer.getResultCodeAvp().getUnsigned32())) {
                                        // empty if block
                                    }
                                }
                                catch (AvpDataException e) {
                                    throw new InternalException((Throwable)e);
                                }
                                this.dispatchEvent(localEvent.getAnswer());
                                break;
                            }
                            case 4: {
                                this.listener.doSessionTermRequest((ServerRxSession)this, (RxSessionTermRequest)localEvent.getRequest());
                                break;
                            }
                            case 5: {
                                STA = (RxSessionTermAnswer)localEvent.getAnswer();
                                try {
                                    try {
                                        if (this.isSuccess(STA.getResultCodeAvp().getUnsigned32())) ** GOTO lbl53
                                    }
                                    catch (AvpDataException e) {
                                        throw new InternalException((Throwable)e);
                                    }
lbl53:
                                    // 2 sources

                                    var10_13 = null;
                                    newState = ServerRxSessionState.IDLE;
                                }
                                catch (Throwable var9_16) {
                                    var10_14 = null;
                                    newState = ServerRxSessionState.IDLE;
                                    throw var9_16;
                                }
                                this.dispatchEvent(localEvent.getAnswer());
                                break;
                            }
                            case 6: {
                                this.listener.doReAuthAnswer((ServerRxSession)this, (RxReAuthRequest)localEvent.getRequest(), (RxReAuthAnswer)localEvent.getAnswer());
                                break;
                            }
                            case 7: {
                                this.dispatchEvent(localEvent.getRequest());
                                break;
                            }
                            case 8: {
                                this.listener.doAbortSessionAnswer((ServerRxSession)this, (RxAbortSessionRequest)localEvent.getRequest(), (RxAbortSessionAnswer)localEvent.getAnswer());
                                break;
                            }
                            case 9: {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                        }
                        break;
                    }
                }
                var6_8 = true;
                var12_17 = null;
                if (newState != null) {
                    this.setState(newState);
                }
                this.sendAndStateLock.unlock();
                return var6_8;
            }
            catch (Exception e) {
                throw new InternalException((Throwable)e);
            }
        }
        catch (Throwable var11_19) {
            var12_18 = null;
            if (newState != null) {
                this.setState(newState);
            }
            this.sendAndStateLock.unlock();
            throw var11_19;
        }
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    @Override
    public void onTimer(String timerName) {
    }

    public void timeoutExpired(Request request) {
    }

    protected boolean isProvisional(long resultCode) {
        return resultCode >= 1000L && resultCode < 2000L;
    }

    protected boolean isSuccess(long resultCode) {
        return resultCode >= 2000L && resultCode < 3000L;
    }

    protected void setState(ServerRxSessionState newState) {
        this.setState(newState, true);
    }

    protected void setState(ServerRxSessionState newState, boolean release) {
        ServerRxSessionState oldState = this.sessionData.getServerRxSessionState();
        this.sessionData.setServerRxSessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
        if (newState == ServerRxSessionState.IDLE && release) {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                try {
                    this.sendAndStateLock.lock();
                    super.release();
                }
                catch (Exception e) {
                    logger.debug("Failed to release session", (Throwable)e);
                    Object var3_2 = null;
                    this.sendAndStateLock.unlock();
                }
                Object var3_1 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    protected void send(Event.Type type, AppRequestEvent request, AppAnswerEvent answer) throws InternalException {
        try {
            block4: {
                try {
                    this.sendAndStateLock.lock();
                    if (type == null) break block4;
                    this.handleEvent(new Event(type, request, answer));
                }
                catch (Exception e) {
                    throw new InternalException((Throwable)e);
                }
            }
            Object var6_4 = null;
            this.sendAndStateLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.sendAndStateLock.unlock();
            throw throwable;
        }
    }

    protected void dispatchEvent(AppEvent event) throws InternalException {
        try {
            this.session.send(event.getMessage(), (EventListener)this);
        }
        catch (Exception e) {
            logger.debug("Failure trying to dispatch event", (Throwable)e);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerRxSessionImpl other = (ServerRxSessionImpl)obj;
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }

    private class AnswerDelivery
    implements Runnable {
        ServerRxSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 258: {
                        ServerRxSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_RAA, (AppRequestEvent)ServerRxSessionImpl.this.factory.createReAuthRequest(this.request), (AppAnswerEvent)ServerRxSessionImpl.this.factory.createReAuthAnswer(this.answer)));
                        break;
                    }
                    case 274: {
                        ServerRxSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_ASA, (AppRequestEvent)ServerRxSessionImpl.this.factory.createAbortSessionRequest(this.request), (AppAnswerEvent)ServerRxSessionImpl.this.factory.createAbortSessionAnswer(this.answer)));
                        break;
                    }
                    default: {
                        ServerRxSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ServerRxSession session;
        Request request;

        private RequestDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 265: {
                        ServerRxSessionImpl.this.handleEvent(new Event(true, (AppRequestEvent)ServerRxSessionImpl.this.factory.createAARequest(this.request), null));
                        break;
                    }
                    case 275: {
                        ServerRxSessionImpl.this.handleEvent(new Event(true, (AppRequestEvent)ServerRxSessionImpl.this.factory.createSessionTermRequest(this.request), null));
                        break;
                    }
                    default: {
                        ServerRxSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }
}

