/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Peer;
import org.jdiameter.api.URI;
import org.jdiameter.client.impl.helpers.UIDGenerator;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPeer
implements Comparable<Peer> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPeer.class);
    public static final int INT_COMMON_APP_ID = -1;
    protected static UIDGenerator uid = new UIDGenerator();
    protected IStatistic statistic;
    protected List<IStatisticRecord> perSecondRecords = new ArrayList<IStatisticRecord>();
    protected URI uri;
    protected IStatisticManager statisticFactory;
    private Lock statisticsLock = new ReentrantLock();

    public AbstractPeer(URI uri, IStatisticManager statisticFactory) {
        this.uri = uri;
        this.statisticFactory = statisticFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createPeerStatistics() {
        block7: {
            block6: {
                logger.debug("Creating Peer Statistics for URI {}", (Object)this.uri);
                try {
                    this.statisticsLock.lock();
                    if (this.statistic != null) {
                        Object var16_1 = null;
                        break block6;
                    }
                    String uriString = this.uri == null ? "local" : this.uri.toString();
                    IStatisticRecord appGenRequestCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.AppGenRequest);
                    IStatisticRecord appGenCPSRequestCounter = this.statisticFactory.newPerSecondCounterRecord(uriString, IStatisticRecord.Counters.AppGenRequestPerSecond, appGenRequestCounter);
                    IStatisticRecord appGenRejectedRequestCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.AppGenRejectedRequest);
                    this.perSecondRecords.add(appGenCPSRequestCounter);
                    IStatisticRecord appGenResponseCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.AppGenResponse);
                    IStatisticRecord appGenCPSResponseCounter = this.statisticFactory.newPerSecondCounterRecord(uriString, IStatisticRecord.Counters.AppGenResponsePerSecond, appGenResponseCounter);
                    IStatisticRecord appGenRejectedResponseCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.AppGenRejectedResponse);
                    this.perSecondRecords.add(appGenCPSResponseCounter);
                    IStatisticRecord netGenRequestCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.NetGenRequest);
                    IStatisticRecord netGenCPSRequestCounter = this.statisticFactory.newPerSecondCounterRecord(uriString, IStatisticRecord.Counters.NetGenRequestPerSecond, netGenRequestCounter);
                    IStatisticRecord netGenRejectedRequestCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.NetGenRejectedRequest);
                    this.perSecondRecords.add(netGenCPSRequestCounter);
                    IStatisticRecord netGenResponseCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.NetGenResponse);
                    IStatisticRecord netGenCPSResponseCounter = this.statisticFactory.newPerSecondCounterRecord(uriString, IStatisticRecord.Counters.NetGenResponsePerSecond, netGenResponseCounter);
                    IStatisticRecord netGenRejectedResponseCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.NetGenRejectedResponse);
                    this.perSecondRecords.add(netGenCPSResponseCounter);
                    IStatisticRecord sysGenResponseCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.SysGenResponse);
                    this.statistic = this.statisticFactory.newStatistic(uriString, IStatistic.Groups.Peer, appGenRequestCounter, appGenCPSRequestCounter, appGenRejectedRequestCounter, appGenResponseCounter, appGenCPSResponseCounter, appGenRejectedResponseCounter, netGenRequestCounter, netGenCPSRequestCounter, netGenRejectedRequestCounter, netGenResponseCounter, netGenCPSResponseCounter, netGenRejectedResponseCounter, sysGenResponseCounter);
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var16_3 = null;
                    logger.debug("Completed creating Peer Statistics for URI {}: {}", (Object)this.uri, (Object)this.statistic);
                    if (this.statistic == null) {
                        logger.warn("Failed to create Peer Statistics for URI {}, creating dummy and setting to disabled", (Object)this.uri);
                        this.statistic = this.statisticFactory.newStatistic("local", IStatistic.Groups.Peer, new IStatisticRecord[0]);
                        this.statistic.enable(false);
                    }
                    this.statisticsLock.unlock();
                    throw throwable;
                }
            }
            logger.debug("Completed creating Peer Statistics for URI {}: {}", (Object)this.uri, (Object)this.statistic);
            if (this.statistic == null) {
                logger.warn("Failed to create Peer Statistics for URI {}, creating dummy and setting to disabled", (Object)this.uri);
                this.statistic = this.statisticFactory.newStatistic("local", IStatistic.Groups.Peer, new IStatisticRecord[0]);
                this.statistic.enable(false);
            }
            this.statisticsLock.unlock();
            return;
        }
        Object var16_2 = null;
        logger.debug("Completed creating Peer Statistics for URI {}: {}", (Object)this.uri, (Object)this.statistic);
        if (this.statistic == null) {
            logger.warn("Failed to create Peer Statistics for URI {}, creating dummy and setting to disabled", (Object)this.uri);
            this.statistic = this.statisticFactory.newStatistic("local", IStatistic.Groups.Peer, new IStatisticRecord[0]);
            this.statistic.enable(false);
        }
        this.statisticsLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removePeerStatistics() {
        block5: {
            block4: {
                logger.debug("Removing Peer Statistics for URI {}", (Object)this.uri);
                try {
                    this.statisticsLock.lock();
                    if (this.statistic == null) {
                        Object var4_1 = null;
                        break block4;
                    }
                    for (IStatisticRecord rec : this.perSecondRecords) {
                        this.statisticFactory.removePerSecondCounterRecord(rec);
                    }
                    this.statisticFactory.removeStatistic(this.statistic);
                    this.perSecondRecords.clear();
                    this.statistic = null;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    logger.debug("Completed removing Peer Statistics for URI {}: {}", (Object)this.uri, (Object)this.statistic);
                    this.statisticsLock.unlock();
                    throw throwable;
                }
            }
            logger.debug("Completed removing Peer Statistics for URI {}: {}", (Object)this.uri, (Object)this.statistic);
            this.statisticsLock.unlock();
            return;
        }
        Object var4_2 = null;
        logger.debug("Completed removing Peer Statistics for URI {}: {}", (Object)this.uri, (Object)this.statistic);
        this.statisticsLock.unlock();
    }

    @Override
    public int compareTo(Peer o) {
        return this.uri.compareTo((Object)o.getUri());
    }

    protected void disconnect(int disconnectCause) throws InternalException, IllegalDiameterStateException {
    }
}

