/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.concurrent;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jdiameter.api.Configuration;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.concurrent.IConcurrentEntityFactory;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.jdiameter.common.impl.concurrent.AbstractTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommonScheduledExecutorService
extends ScheduledThreadPoolExecutor {
    private IStatistic statistic;
    private IConcurrentEntityFactory entityFactory;
    private IStatisticRecord execTimeSumm;
    private IStatisticRecord execTimeCount;
    private IStatisticRecord waitTimeSumm;
    private IStatisticRecord waitTimeCount;
    private IStatisticManager statisticFactory;

    public CommonScheduledExecutorService(String name, Configuration config, IConcurrentEntityFactory entityFactory, IStatisticManager statisticFactory) {
        super(config == null ? ((Integer)Parameters.ConcurrentEntityPoolSize.defValue()).intValue() : config.getIntValue(Parameters.ConcurrentEntityPoolSize.ordinal(), ((Integer)Parameters.ConcurrentEntityPoolSize.defValue()).intValue()));
        this.statisticFactory = statisticFactory;
        this.entityFactory = entityFactory;
        IStatisticRecord rejectedCount = statisticFactory.newCounterRecord(IStatisticRecord.Counters.RejectedTasks);
        this.execTimeSumm = statisticFactory.newCounterRecord("TimeSumm", "TimeSumm");
        this.execTimeCount = statisticFactory.newCounterRecord("TimeCount", "TimeCount");
        this.waitTimeSumm = statisticFactory.newCounterRecord("TimeSumm", "TimeSumm");
        this.waitTimeCount = statisticFactory.newCounterRecord("TimeCount", "TimeCount");
        this.statistic = statisticFactory.newStatistic(name, IStatistic.Groups.ScheduledExecService, rejectedCount);
        IStatisticRecord execTimeCounter = statisticFactory.newCounterRecord(IStatisticRecord.Counters.ExecTimeTask, new AbstractTask.AverageValueHolder(this.statistic, IStatisticRecord.Counters.ExecTimeTask), this.execTimeSumm, this.execTimeCount);
        IStatisticRecord waitTimeCounter = statisticFactory.newCounterRecord(IStatisticRecord.Counters.WaitTimeTask, new AbstractTask.AverageValueHolder(this.statistic, IStatisticRecord.Counters.WaitTimeTask), this.waitTimeSumm, this.waitTimeCount);
        this.statistic.appendCounter(statisticFactory.newCounterRecord(IStatisticRecord.Counters.WorkingThread), statisticFactory.newCounterRecord(IStatisticRecord.Counters.CanceledTasks), statisticFactory.newCounterRecord(IStatisticRecord.Counters.BrokenTasks), execTimeCounter, waitTimeCounter, statisticFactory.newCounterRecord(IStatisticRecord.Counters.WaitTimeTask));
        if (config == null) {
            this.setThreadFactory(entityFactory.newThreadFactory(name));
        } else {
            this.setThreadFactory(entityFactory.newThreadFactory(config.getStringValue(Parameters.ConcurrentEntityDescription.ordinal(), name)));
        }
        super.setRejectedExecutionHandler(entityFactory.newRejectedExecutionHandler(rejectedCount));
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit unit) {
        return super.schedule(this.entityFactory.newDefaultRunnable(runnable, this.statistic, this.execTimeSumm, this.execTimeCount, this.waitTimeSumm, this.waitTimeCount), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return super.schedule(this.entityFactory.newDefaultCallable(callable, this.statistic, this.execTimeSumm, this.execTimeCount, this.waitTimeSumm, this.waitTimeCount), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(this.entityFactory.newDefaultRunnable(runnable, this.statistic, this.execTimeSumm, this.execTimeCount, this.waitTimeSumm, this.waitTimeCount), initialDelay, period, unit);
    }

    public IStatistic getStatistic() {
        return this.statistic;
    }

    @Override
    public void shutdown() {
        this.statisticFactory.removeStatistic(this.statistic);
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.statisticFactory.removeStatistic(this.statistic);
        return super.shutdownNow();
    }
}

