/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tls.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jdiameter.api.Configuration;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.transport.tls.netty.DiameterMessageDecoder;
import org.jdiameter.client.impl.transport.tls.netty.DiameterMessageEncoder;
import org.jdiameter.client.impl.transport.tls.netty.DiameterMessageHandler;
import org.jdiameter.client.impl.transport.tls.netty.InbandSecurityHandler;
import org.jdiameter.client.impl.transport.tls.netty.StartTlsInitiator;
import org.jdiameter.client.impl.transport.tls.netty.StartTlsServerHandler;
import org.jdiameter.client.impl.transport.tls.netty.TLSClientConnection;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSTransportClient {
    private static final Logger logger = LoggerFactory.getLogger(TLSTransportClient.class);
    private TLSClientConnection parentConnection;
    private IConcurrentFactory concurrentFactory;
    private IMessageParser parser;
    private Configuration config;
    private InetSocketAddress destAddress;
    private InetSocketAddress origAddress;
    private String socketDescription = null;
    private Channel channel;
    private EventLoopGroup workerGroup;
    private volatile TlsHandshakingState tlsHandshakingState = TlsHandshakingState.INIT;

    protected TLSTransportClient(TLSClientConnection parenConnection, IConcurrentFactory concurrentFactory, IMessageParser parser, Configuration config) {
        this.parentConnection = parenConnection;
        this.concurrentFactory = concurrentFactory;
        this.parser = parser;
        this.config = config;
    }

    public TLSTransportClient(TLSClientConnection parenConnection, IConcurrentFactory concurrentFactory, IMessageParser parser, Configuration config, InetSocketAddress destAddress, InetSocketAddress origAddress) {
        this(parenConnection, concurrentFactory, parser, config);
        if (destAddress == null) {
            throw new IllegalArgumentException("Destination address is required");
        }
        this.destAddress = destAddress;
        this.origAddress = origAddress;
        this.socketDescription = origAddress.toString() + "->" + destAddress.toString();
        logger.debug("Created TLSTransportClient (client) for {}", (Object)this.socketDescription);
    }

    public TLSTransportClient(TLSClientConnection parenConnection, IConcurrentFactory concurrentFactory, IMessageParser parser, Configuration config, Channel channel) {
        this(parenConnection, concurrentFactory, parser, config);
        if (channel == null) {
            throw new IllegalArgumentException("Channel is required");
        }
        this.channel = channel;
        this.origAddress = (InetSocketAddress)this.channel.localAddress();
        this.destAddress = (InetSocketAddress)this.channel.remoteAddress();
        this.socketDescription = this.origAddress.toString() + "->" + this.destAddress.toString();
        ChannelPipeline pipeline = this.channel.pipeline();
        pipeline.addLast("startTlsServerHandler", (ChannelHandler)new StartTlsServerHandler(this));
        pipeline.addLast("decoder", (ChannelHandler)new DiameterMessageDecoder(parenConnection, parser));
        pipeline.addLast("msgHandler", (ChannelHandler)new DiameterMessageHandler(this.parentConnection, true));
        pipeline.addLast("encoder", (ChannelHandler)new DiameterMessageEncoder(parser));
        pipeline.addLast("inbandWriter", (ChannelHandler)new InbandSecurityHandler());
        logger.debug("Created TLSTransportClient (server) for {}", (Object)this.socketDescription);
    }

    public void start() throws InterruptedException {
        logger.debug("Staring client TLSTransportClient {} ", (Object)this.socketDescription);
        if (this.isConnected()) {
            logger.debug("Already connected TLSTransportClient {} ", (Object)this.socketDescription);
            return;
        }
        this.workerGroup = new NioEventLoopGroup();
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new DiameterMessageDecoder(TLSTransportClient.this.parentConnection, TLSTransportClient.this.parser));
                pipeline.addLast("msgHandler", (ChannelHandler)new DiameterMessageHandler(TLSTransportClient.this.parentConnection, false));
                pipeline.addLast("startTlsInitiator", (ChannelHandler)new StartTlsInitiator(TLSTransportClient.this.config, TLSTransportClient.this));
                pipeline.addLast("encoder", (ChannelHandler)new DiameterMessageEncoder(TLSTransportClient.this.parser));
                pipeline.addLast("inbandWriter", (ChannelHandler)new InbandSecurityHandler());
            }
        });
        this.channel = bootstrap.remoteAddress((SocketAddress)this.destAddress).connect().sync().channel();
        this.parentConnection.onConnected();
        logger.debug("Started TLS Transport on Socket {}", (Object)this.socketDescription);
    }

    public TLSClientConnection getParent() {
        return this.parentConnection;
    }

    public InetSocketAddress getDestAddress() {
        return this.destAddress;
    }

    public void setDestAddress(InetSocketAddress address) {
        this.destAddress = address;
        if (logger.isDebugEnabled()) {
            logger.debug("Destination address is set to [{}] : [{}]", (Object)this.destAddress.getHostName(), (Object)this.destAddress.getPort());
        }
    }

    public void setOrigAddress(InetSocketAddress address) {
        this.origAddress = address;
        if (logger.isDebugEnabled()) {
            logger.debug("Origin address is set to [{}] : [{}]", (Object)this.origAddress.getHostName(), (Object)this.origAddress.getPort());
        }
    }

    public InetSocketAddress getOrigAddress() {
        return this.origAddress;
    }

    void sendMessage(IMessage message) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Failed to send message over [" + this.socketDescription + "]");
        }
        if (this.tlsHandshakingState == TlsHandshakingState.SHAKING) {
            return;
        }
        logger.debug("About to send a message over the TLS socket [{}]", (Object)this.socketDescription);
        this.channel.writeAndFlush((Object)message);
    }

    boolean isConnected() {
        return this.channel != null && this.channel.isActive();
    }

    public void stop() {
        this.closeChannel();
        this.closeWorkerGroup();
        this.getParent().disconnect();
    }

    public void release() throws Exception {
        this.stop();
        this.destAddress = null;
        this.origAddress = null;
    }

    private void closeChannel() {
        if (this.channel != null && this.channel.isActive()) {
            try {
                this.channel.closeFuture().sync();
            }
            catch (InterruptedException e) {
                logger.error("Error stopping socket " + this.socketDescription, (Throwable)e);
            }
            this.channel = null;
        }
    }

    private void closeWorkerGroup() {
        if (this.workerGroup != null && !this.workerGroup.isShuttingDown()) {
            try {
                this.workerGroup.shutdownGracefully().sync();
            }
            catch (InterruptedException e) {
                logger.error("Error stopping socket " + this.socketDescription, (Throwable)e);
            }
            this.workerGroup = null;
        }
    }

    public TlsHandshakingState getTlsHandshakingState() {
        return this.tlsHandshakingState;
    }

    public void setTlsHandshakingState(TlsHandshakingState tlsHandshakingState) {
        this.tlsHandshakingState = tlsHandshakingState;
    }

    public TLSClientConnection getParentConnection() {
        return this.parentConnection;
    }

    public IMessageParser getParser() {
        return this.parser;
    }

    public Configuration getConfig() {
        return this.config;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TlsHandshakingState {
        INIT,
        SHAKING,
        SHAKEN;

    }
}

