/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tls.netty;

import io.netty.channel.Channel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.OverloadException;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.io.IConnection;
import org.jdiameter.client.api.io.IConnectionListener;
import org.jdiameter.client.api.io.TransportError;
import org.jdiameter.client.api.io.TransportException;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.transport.tls.TLSUtils;
import org.jdiameter.client.impl.transport.tls.netty.TLSTransportClient;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.server.impl.helpers.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLSClientConnection
implements IConnection {
    private static Logger logger = LoggerFactory.getLogger(TLSClientConnection.class);
    private TLSTransportClient client;
    private SSLSocketFactory factory;
    private Configuration sslConfig;
    private final long createdTime = System.currentTimeMillis();
    private LinkedBlockingQueue<Event> buffer = new LinkedBlockingQueue(64);
    private Lock lock = new ReentrantLock();
    private ConcurrentLinkedQueue<IConnectionListener> listeners = new ConcurrentLinkedQueue();
    private String cachedKey = null;

    public TLSClientConnection(Configuration config, IConcurrentFactory concurrentFactory, InetAddress remoteAddress, int remotePort, InetAddress localAddress, int localPort, IMessageParser parser, String ref) throws Exception {
        String secRef = ref;
        if (secRef == null) {
            if (!config.isAttributeExist(Parameters.SecurityRef.ordinal())) {
                throw new IllegalArgumentException("No security_ref attribute present in local peer!");
            }
            secRef = config.getStringValue(Parameters.SecurityRef.ordinal(), "");
        }
        this.sslConfig = TLSUtils.getSSLConfiguration(config, secRef);
        this.client = new TLSTransportClient(this, concurrentFactory, parser, this.sslConfig, new InetSocketAddress(remoteAddress, remotePort), new InetSocketAddress(localAddress, localPort));
    }

    public TLSClientConnection(Configuration config, IConcurrentFactory concurrentFactory, InetAddress remoteAddress, int remotePort, InetAddress localAddress, int localPort, IConnectionListener listener, IMessageParser parser, String ref) throws InterruptedException {
        this.listeners.add(listener);
        String secRef = ref;
        if (secRef == null) {
            if (!config.isAttributeExist(Parameters.SecurityRef.ordinal())) {
                throw new IllegalArgumentException("No security_ref attribute present in local peer!");
            }
            secRef = config.getStringValue(Parameters.SecurityRef.ordinal(), "");
        }
        this.sslConfig = TLSUtils.getSSLConfiguration(config, secRef);
        this.client = new TLSTransportClient(this, concurrentFactory, parser, this.sslConfig, new InetSocketAddress(remoteAddress, remotePort), new InetSocketAddress(localAddress, localPort));
    }

    public TLSClientConnection(Configuration config, Configuration localPeerSSLConfig, IConcurrentFactory concurrentFactory, IMessageParser parser, Channel channel) throws Exception {
        if (localPeerSSLConfig == null) {
            throw new IllegalArgumentException("Can not create connection without TLS parameters");
        }
        this.sslConfig = localPeerSSLConfig;
        this.client = new TLSTransportClient(this, concurrentFactory, parser, this.sslConfig, channel);
    }

    protected TLSTransportClient getClient() {
        return this.client;
    }

    public Configuration getSSLConfig() {
        return this.sslConfig;
    }

    public SSLSocketFactory getSSLFactory() {
        return this.factory;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.getClient().getDestAddress().getAddress();
    }

    @Override
    public int getRemotePort() {
        return this.getClient().getDestAddress().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionListener(IConnectionListener listener) {
        this.lock.lock();
        try {
            this.listeners.add(listener);
            if (this.buffer.size() != 0) {
                for (Event e : this.buffer) {
                    try {
                        this.onEvent(e);
                    }
                    catch (AvpDataException e1) {}
                }
                this.buffer.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remAllConnectionListener() {
        this.lock.lock();
        try {
            this.listeners.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remConnectionListener(IConnectionListener listener) {
        this.lock.lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void release() throws IOException {
        try {
            if (this.getClient() != null) {
                this.getClient().release();
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            this.buffer.clear();
            this.remAllConnectionListener();
        }
    }

    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        return false;
    }

    public <T> T unwrap(Class<T> aClass) throws InternalException {
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.getClient() != null && this.getClient().isConnected();
    }

    @Override
    public boolean isNetworkInitiated() {
        return false;
    }

    @Override
    public String getKey() {
        if (this.cachedKey == null) {
            this.cachedKey = new StringBuffer("aaas://").append(this.getRemoteAddress().getHostName()).append(":").append(this.getRemotePort()).toString();
        }
        return this.cachedKey;
    }

    @Override
    public void connect() throws TransportException {
        try {
            this.getClient().start();
        }
        catch (Exception e) {
            throw new TransportException("Cannot init transport: ", TransportError.Internal, e);
        }
    }

    @Override
    public void disconnect() throws InternalError {
        try {
            if (this.getClient() != null) {
                this.getClient().stop();
            }
        }
        catch (Exception e) {
            throw new InternalError("Error while stopping transport: " + e.getMessage());
        }
    }

    @Override
    public void sendMessage(IMessage message) throws TransportException, OverloadException {
        try {
            if (this.getClient() != null) {
                this.getClient().sendMessage(message);
            }
        }
        catch (Exception e) {
            throw new TransportException("Cannot send message: ", TransportError.FailedSendMessage, e);
        }
    }

    protected void onDisconnect() throws AvpDataException {
        this.onEvent(new Event(EventType.DISCONNECTED));
    }

    protected void onMessageReceived(IMessage message) throws AvpDataException {
        this.onEvent(new Event(EventType.MESSAGE_RECEIVED, message));
    }

    protected void onAvpDataException(AvpDataException e) {
        try {
            this.onEvent(new Event(EventType.DATA_EXCEPTION, (Exception)((Object)e)));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    protected void onConnected() {
        try {
            this.onEvent(new Event(EventType.CONNECTED));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEvent(Event event) throws AvpDataException {
        this.lock.lock();
        try {
            if (this.processBufferedMessages(event)) {
                for (IConnectionListener listener : this.listeners) {
                    switch (event.type) {
                        case CONNECTED: {
                            listener.connectionOpened(this.getKey());
                            break;
                        }
                        case DISCONNECTED: {
                            listener.connectionClosed(this.getKey(), null);
                            break;
                        }
                        case MESSAGE_RECEIVED: {
                            listener.messageReceived(this.getKey(), event.message);
                            break;
                        }
                        case DATA_EXCEPTION: {
                            listener.internalError(this.getKey(), null, new TransportException("Avp Data Exception:", TransportError.ReceivedBrokenMessage, event.exception));
                        }
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean processBufferedMessages(Event event) throws AvpDataException {
        if (this.listeners.size() == 0) {
            try {
                this.buffer.add(event);
            }
            catch (IllegalStateException e) {
                Event[] tempBuffer = this.buffer.toArray(new Event[this.buffer.size()]);
                this.buffer.remove(tempBuffer[tempBuffer.length - 1]);
                this.buffer.add(event);
            }
            return false;
        }
        return true;
    }

    private static class Event {
        EventType type;
        IMessage message;
        Exception exception;

        Event(EventType type) {
            this.type = type;
        }

        Event(EventType type, Exception exception) {
            this(type);
            this.exception = exception;
        }

        Event(EventType type, IMessage message) {
            this(type);
            this.message = message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EventType {
        CONNECTED,
        DISCONNECTED,
        MESSAGE_RECEIVED,
        DATA_EXCEPTION;

    }
}

