/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tcp.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.transport.tcp.netty.DiameterMessageDecoder;
import org.jdiameter.client.impl.transport.tcp.netty.DiameterMessageEncoder;
import org.jdiameter.client.impl.transport.tcp.netty.DiameterMessageHandler;
import org.jdiameter.client.impl.transport.tcp.netty.TCPClientConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPTransportClient {
    protected EventLoopGroup workerGroup;
    protected EventExecutorGroup eventExecutorGroup = new DefaultEventExecutorGroup(4);
    protected Channel channel;
    protected TCPClientConnection parentConnection;
    protected InetSocketAddress destAddress;
    protected InetSocketAddress sourceAddress;
    protected String socketDescription;
    protected static final Logger logger = LoggerFactory.getLogger(TCPClientConnection.class);
    protected IMessageParser parser;
    protected static final int CONNECT_TIMEOUT = 500;

    protected TCPTransportClient(TCPClientConnection parentConnection, IMessageParser parser) {
        if (parentConnection == null) {
            throw new IllegalArgumentException("Parent connection cannot be null");
        }
        this.parentConnection = parentConnection;
        if (parser == null) {
            throw new IllegalArgumentException("Parser cannot be null");
        }
        this.parser = parser;
    }

    public TCPTransportClient(TCPClientConnection parentConnection, IMessageParser parser, InetSocketAddress destAddress, InetSocketAddress sourceAddress) {
        this(parentConnection, parser);
        logger.debug("Client only connection");
        if (destAddress == null && sourceAddress == null) {
            throw new IllegalArgumentException("Either Destination or Source address is required");
        }
        if (sourceAddress != null) {
            this.sourceAddress = sourceAddress;
        }
        if (destAddress != null) {
            this.destAddress = destAddress;
            this.socketDescription = destAddress.toString();
        }
    }

    public TCPTransportClient(TCPClientConnection parentConnection, IMessageParser parser, Channel channel) {
        this(parentConnection, parser);
        logger.debug("Server only connection");
        if (channel == null) {
            throw new IllegalArgumentException("Channel cannot be null");
        }
        this.channel = channel;
        ChannelPipeline pipeline = this.channel.pipeline();
        pipeline.addLast("decoder", (ChannelHandler)new DiameterMessageDecoder(parentConnection, parser));
        pipeline.addLast("encoder", (ChannelHandler)new DiameterMessageEncoder(parser));
        pipeline.addLast(this.eventExecutorGroup, "msgHandler", (ChannelHandler)new DiameterMessageHandler(parentConnection));
        this.destAddress = (InetSocketAddress)this.channel.remoteAddress();
    }

    public void start() throws InterruptedException {
        logger.debug("Starting TCP Transport on [{}]", (Object)this.socketDescription);
        if (this.isConnected()) {
            logger.debug("TCP Transport already started, [{}]", (Object)this.socketDescription);
            return;
        }
        this.workerGroup = new NioEventLoopGroup();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)500)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new DiameterMessageDecoder(TCPTransportClient.this.parentConnection, TCPTransportClient.this.parser));
                pipeline.addLast("encoder", (ChannelHandler)new DiameterMessageEncoder(TCPTransportClient.this.parser));
                pipeline.addLast(TCPTransportClient.this.eventExecutorGroup, "msgHandler", (ChannelHandler)new DiameterMessageHandler(TCPTransportClient.this.parentConnection));
            }
        });
        this.channel = bootstrap.remoteAddress((SocketAddress)this.destAddress).connect().sync().channel();
        logger.debug("TCP Transport connected successfully, [{}]", (Object)this.socketDescription);
        this.parentConnection.onConnected();
    }

    public void stop() {
        logger.debug("Stopping TCP Transport, [{}]", (Object)this.socketDescription);
        if (!this.isConnected()) {
            logger.debug("Already stoppped TCP Transport, [{}]", (Object)this.socketDescription);
            return;
        }
        this.closeChannel();
        this.closeWorkerGroup();
        this.closeEventExecutorGroup();
        logger.debug("Transport is stopped [{}]", (Object)this.socketDescription);
    }

    private void closeEventExecutorGroup() {
        if (this.eventExecutorGroup != null) {
            try {
                this.eventExecutorGroup.shutdownGracefully().sync();
            }
            catch (InterruptedException e) {
                logger.error("Error stopping socket " + this.socketDescription, (Throwable)e);
            }
            this.eventExecutorGroup = null;
        }
    }

    private void closeWorkerGroup() {
        if (this.workerGroup != null) {
            try {
                this.workerGroup.shutdownGracefully().sync();
            }
            catch (InterruptedException e) {
                logger.error("Error stopping socket " + this.socketDescription, (Throwable)e);
            }
            this.workerGroup = null;
        }
    }

    private void closeChannel() {
        if (this.channel != null) {
            try {
                this.channel.closeFuture().sync();
            }
            catch (InterruptedException e) {
                logger.error("Error stopping socket " + this.socketDescription, (Throwable)e);
            }
            this.channel = null;
        }
    }

    public void release() throws InterruptedException, IOException {
        logger.debug("Releasing TCP Transport, [{}]", (Object)this.socketDescription);
        this.stop();
        this.destAddress = null;
        this.sourceAddress = null;
    }

    public void sendMessage(IMessage message) {
        if (!this.isConnected()) {
            throw new IllegalStateException("TCP transport is stopped on socket " + this.socketDescription);
        }
        this.channel.writeAndFlush((Object)message);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Transport to ");
        if (this.destAddress != null) {
            buffer.append(this.destAddress.getHostName());
            buffer.append(":");
            buffer.append(this.destAddress.getPort());
        } else {
            buffer.append("null");
        }
        buffer.append("@");
        buffer.append(super.toString());
        return buffer.toString();
    }

    public TCPClientConnection getParent() {
        return this.parentConnection;
    }

    public InetSocketAddress getDestAddress() {
        return this.destAddress;
    }

    boolean isConnected() {
        return this.channel != null && this.channel.isActive();
    }
}

